/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.util.TreePath;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;

public class ConvertSwitchToRuleSwitch {
    public static ErrorDescription switch2RuleSwitch(HintContext ctx) {
        if (!CompilerOptionsQuery.getOptions((FileObject)ctx.getInfo().getFileObject()).getArguments().contains("--enable-preview")) {
            return null;
        }
        SwitchTree st = (SwitchTree)ctx.getPath().getLeaf();
        boolean completesNormally = false;
        boolean wasDefault = false;
        boolean wasEmpty = false;
        for (CaseTree caseTree : st.getCases()) {
            if (caseTree.getStatements() == null) {
                return null;
            }
            if (completesNormally) {
                if (!wasEmpty) {
                    return null;
                }
                if (wasDefault) {
                    return null;
                }
                if (!wasDefault && caseTree.getExpression() == null) {
                    return null;
                }
            }
            completesNormally = Utilities.completesNormally(ctx.getInfo(), new TreePath(ctx.getPath(), caseTree));
            wasDefault = caseTree.getExpression() == null;
            wasEmpty = caseTree.getStatements().isEmpty();
        }
        if (wasDefault && Utilities.isCompatibleWithSwitchExpression(st)) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertSwitchToSwitchExpression(), (Fix[])new Fix[]{new FixImpl1(ctx.getInfo(), ctx.getPath()).toEditorFix()});
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertSwitchToRuleSwitch(), (Fix[])new Fix[]{new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    private static final class FixImpl1
    extends JavaFix {
        public FixImpl1(CompilationInfo info, TreePath switchStatement) {
            super(info, switchStatement);
        }

        protected String getText() {
            return Bundle.FIX_ConvertToSwitchExpression();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            TreePath tp = ctx.getPath();
            SwitchTree st = (SwitchTree)tp.getLeaf();
            Utilities.performRewriteRuleSwitch(ctx, tp, st, true);
        }
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath switchStatement) {
            super(info, switchStatement);
        }

        protected String getText() {
            return Bundle.FIX_ConvertToRuleSwitch();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            TreePath tp = ctx.getPath();
            SwitchTree st = (SwitchTree)tp.getLeaf();
            Utilities.performRewriteRuleSwitch(ctx, tp, st, false);
        }
    }
}

