/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExpandEnhancedForLoop {
    public static ErrorDescription run(HintContext ctx) {
        TreePath tp = ctx.getPath();
        EnhancedForLoopTree efl = (EnhancedForLoopTree)tp.getLeaf();
        long statementStart = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), efl.getStatement());
        int caret = ctx.getCaretLocation();
        if ((long)caret >= statementStart) {
            return null;
        }
        TypeMirror expressionType = ctx.getInfo().getTrees().getTypeMirror(new TreePath(tp, efl.getExpression()));
        if (expressionType == null || expressionType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        ExecutableElement iterator = ExpandEnhancedForLoop.findIterable(ctx.getInfo());
        Types t = ctx.getInfo().getTypes();
        if (iterator == null || !t.isSubtype((DeclaredType)expressionType, t.erasure(iterator.getEnclosingElement().asType()))) {
            return null;
        }
        FixImpl fix = new FixImpl(TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo()));
        List<Fix> fixes = Collections.singletonList(fix.toEditorFix());
        return ErrorDescriptionFactory.createErrorDescription((Severity)ctx.getSeverity(), (String)NbBundle.getMessage(ExpandEnhancedForLoop.class, (String)"ERR_ExpandEhancedForLoop"), fixes, (FileObject)ctx.getInfo().getFileObject(), (int)caret, (int)caret);
    }

    public static ExecutableElement findIterable(CompilationInfo info) {
        TypeElement iterable = info.getElements().getTypeElement("java.lang.Iterable");
        if (iterable == null) {
            return null;
        }
        for (ExecutableElement ee : ElementFilter.methodsIn(iterable.getEnclosedElements())) {
            if (!ee.getParameters().isEmpty() || !ee.getSimpleName().contentEquals("iterator")) continue;
            return ee;
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(TreePathHandle forLoop) {
            super(forLoop);
        }

        public String getText() {
            return NbBundle.getMessage(ExpandEnhancedForLoop.class, (String)"ERR_ExpandEhancedForLoop");
        }

        protected void performRewrite(@NonNull JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            if (path == null) {
                return;
            }
            EnhancedForLoopTree efl = (EnhancedForLoopTree)path.getLeaf();
            TypeMirror expressionType = copy.getTrees().getTypeMirror(new TreePath(path, efl.getExpression()));
            if (expressionType == null || expressionType.getKind() != TypeKind.DECLARED) {
                return;
            }
            ExecutableElement getIterator = ExpandEnhancedForLoop.findIterable((CompilationInfo)copy);
            ExecutableType getIteratorType = (ExecutableType)copy.getTypes().asMemberOf((DeclaredType)expressionType, getIterator);
            TypeMirror iteratorType = Utilities.resolveTypeForDeclaration((CompilationInfo)copy, getIteratorType.getReturnType());
            TreeMaker make = copy.getTreeMaker();
            Tree iteratorTypeTree = make.Type(iteratorType);
            MethodInvocationTree getIteratorTree = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(efl.getExpression(), (CharSequence)"iterator"), Collections.emptyList());
            MethodInvocationTree getNextTree = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"it"), (CharSequence)"next"), Collections.emptyList());
            MethodInvocationTree hasNextTree = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"it"), (CharSequence)"hasNext"), Collections.emptyList());
            VariableTree orig = efl.getVariable();
            VariableTree init = make.Variable(orig.getModifiers(), (CharSequence)"it", iteratorTypeTree, (ExpressionTree)getIteratorTree);
            VariableTree value = make.Variable(orig.getModifiers(), (CharSequence)orig.getName(), orig.getType(), (ExpressionTree)getNextTree);
            LinkedList<? extends StatementTree> statements = new LinkedList<StatementTree>();
            statements.add(0, value);
            if (efl.getStatement() != null) {
                switch (efl.getStatement().getKind()) {
                    case BLOCK: {
                        BlockTree oldBlock = (BlockTree)efl.getStatement();
                        statements.addAll(oldBlock.getStatements());
                        break;
                    }
                    case EMPTY_STATEMENT: {
                        break;
                    }
                    default: {
                        statements.add(efl.getStatement());
                    }
                }
            }
            BlockTree newBlock = make.Block(statements, false);
            ForLoopTree forLoop = make.ForLoop(Collections.singletonList(init), (ExpressionTree)hasNextTree, Collections.emptyList(), (StatementTree)newBlock);
            copy.rewrite((Tree)efl, (Tree)forLoop);
        }
    }
}

