/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.SlownessData;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SlownessReporter {
    private final Queue<NotifySnapshot> pending = new LinkedList<NotifySnapshot>();
    private static final String UI_ACTION_BUTTON_PRESS = "UI_ACTION_BUTTON_PRESS";
    private static final String UI_ACTION_EDITOR = "UI_ACTION_EDITOR";
    private static final String UI_ACTION_KEY_PRESS = "UI_ACTION_KEY_PRESS";
    private static final String DELEGATE_PATTERN = "delegate=.*@";
    static final long LATEST_ACTION_LIMIT = 1000L;
    private static final int PRIORITY;
    private static final int CLEAR;
    private static final RequestProcessor IO_RP;

    private String getParam(LogRecord rec, int index) {
        if (rec.getParameters() != null && rec.getParameters().length > index) {
            return rec.getParameters()[index].toString();
        }
        assert (rec.getParameters() != null);
        assert (rec.getParameters().length > index) : Integer.toString(rec.getParameters().length);
        return null;
    }

    String getLatestAction(final long time, final long slownessEndTime) {
        final String[] latestActionHolder = new String[1];
        Installer.readLogs(new Handler(){

            @Override
            public void publish(LogRecord rec) {
                if (slownessEndTime - rec.getMillis() - time > 1000L) {
                    return;
                }
                String latestActionClassName = null;
                if ("IDE_STARTUP".equals(rec.getMessage())) {
                    latestActionClassName = NbBundle.getMessage(SlownessReporter.class, (String)"IDE_STARTUP");
                } else if (SlownessReporter.UI_ACTION_EDITOR.equals(rec.getMessage()) || SlownessReporter.UI_ACTION_BUTTON_PRESS.equals(rec.getMessage()) || SlownessReporter.UI_ACTION_KEY_PRESS.equals(rec.getMessage())) {
                    latestActionClassName = SlownessReporter.this.getParam(rec, 4);
                }
                if (latestActionClassName != null) {
                    latestActionClassName = latestActionClassName.replaceAll("&", "");
                    Pattern p = Pattern.compile(SlownessReporter.DELEGATE_PATTERN);
                    Matcher m = p.matcher(latestActionClassName);
                    if (m.find()) {
                        String delegate = m.group();
                        latestActionClassName = delegate.substring(9, delegate.length() - 1);
                    }
                }
                if (latestActionClassName != null) {
                    latestActionHolder[0] = latestActionClassName;
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        return latestActionHolder[0];
    }

    void notifySlowness(final byte[] nps, final long time, final long slownessEndTime, final String slownessType) {
        IO_RP.post(new Runnable(){

            @Override
            public void run() {
                final String latestActionName = SlownessReporter.this.getLatestAction(time, slownessEndTime);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SlownessReporter.this.pending.add(new NotifySnapshot(new SlownessData(time, nps, slownessType, latestActionName)));
                        if (SlownessReporter.this.pending.size() > 5) {
                            ((NotifySnapshot)SlownessReporter.this.pending.remove()).clear();
                        }
                    }
                });
            }
        });
    }

    static {
        int defPrio = 20000;
        if (!$assertionsDisabled) {
            defPrio = 10000;
            if (10000 <= 0) {
                throw new AssertionError();
            }
        }
        PRIORITY = Integer.getInteger("org.netbeans.modules.uihandler.SlownessReporter.priority", defPrio);
        CLEAR = Integer.getInteger("org.netbeans.modules.uihandler.SlownessReporter.clear", 0);
        IO_RP = new RequestProcessor(SlownessReporter.class);
    }

    private static final class NotifySnapshot
    implements ActionListener,
    Runnable {
        private final Notification note;
        private final SlownessData data;

        NotifySnapshot(SlownessData data) {
            this.data = data;
            NotificationDisplayer.Priority priority = data.getTime() > (long)PRIORITY ? NotificationDisplayer.Priority.LOW : NotificationDisplayer.Priority.SILENT;
            String message = NbBundle.getMessage(NotifySnapshot.class, (String)data.getSlownessType());
            this.note = NotificationDisplayer.getDefault().notify(message, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/uihandler/vilik.png", (boolean)true), this.createPanel(), this.createPanel(), priority, NotificationDisplayer.Category.WARNING);
            if (CLEAR > 0) {
                Installer.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        this.clear();
                    }
                }, CLEAR, 1);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Installer.RP.post((Runnable)this);
        }

        public void clear() {
            this.note.clear();
        }

        private JComponent createPanel() {
            JPanel result = new JPanel();
            result.setOpaque(false);
            result.setLayout(new BoxLayout(result, 1));
            result.add(new JLabel(NbBundle.getMessage(NotifySnapshot.class, (String)("BlockedFor" + this.data.getSlownessType()), (Object)this.data.getTime(), (Object)(this.data.getTime() / 1000L))));
            result.add(this.createDetails(NbBundle.getMessage(NotifySnapshot.class, (String)"Report")));
            return result;
        }

        private JButton createDetails(String text) {
            HtmlButton btn = new HtmlButton(text);
            btn.setFocusable(false);
            btn.setBorder(BorderFactory.createEmptyBorder());
            btn.setBorderPainted(false);
            btn.setFocusPainted(false);
            btn.setOpaque(false);
            btn.setContentAreaFilled(false);
            btn.addActionListener(this);
            btn.setCursor(Cursor.getPredefinedCursor(12));
            return btn;
        }

        @Override
        public void run() {
            Installer.displaySummary("ERROR_URL", true, false, true, this.data);
        }

        private static class HtmlButton
        extends JButton {
            public HtmlButton(String text) {
                super(text);
            }

            @Override
            protected void paintComponent(Graphics g) {
                HtmlRenderer.renderString((String)("<html><a>" + this.getText() + "</a></html>"), (Graphics)g, (int)0, (int)this.getBaseline(Integer.MAX_VALUE, this.getFont().getSize()), (int)Integer.MAX_VALUE, (int)this.getFont().getSize(), (Font)this.getFont(), (Color)this.getForeground(), (int)0, (boolean)true);
            }
        }
    }
}

