/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.io.File;
import java.net.PasswordAuthentication;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitURI;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.clone.CloneDestinationStep;
import org.netbeans.modules.git.ui.clone.FetchBranchesStep;
import org.netbeans.modules.git.ui.clone.RepositoryStep;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

class CloneWizard
implements ChangeListener {
    private PanelsIterator wizardIterator;
    private WizardDescriptor wizardDescriptor;
    private final String forPath;
    private final PasswordAuthentication pa;
    static final List<String> ALL_BRANCHES = new ArrayList<String>();

    public CloneWizard(PasswordAuthentication pa, String forPath) {
        this.forPath = forPath;
        this.pa = pa;
    }

    boolean show() {
        boolean finished;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(CloneWizard.class, (String)"LBL_CloneWizard.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        if (this.pa != null && this.forPath != null) {
            Git.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    CloneWizard.this.wizardIterator.repositoryStep.waitPopulated();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CloneWizard.this.wizardDescriptor.doNextClick();
                        }
                    });
                }
            });
        }
        this.setErrorMessage(this.wizardIterator.repositoryStep.getErrorMessage());
        dialog.setVisible(true);
        dialog.toFront();
        Object value = this.wizardDescriptor.getValue();
        boolean bl = finished = value == WizardDescriptor.FINISH_OPTION;
        if (finished) {
            this.onFinished();
        } else if (value == WizardDescriptor.CLOSED_OPTION || value == WizardDescriptor.CANCEL_OPTION) {
            this.wizardIterator.repositoryStep.cancelBackgroundTasks();
        }
        return finished;
    }

    private void setErrorMessage(AbstractWizardPanel.Message msg) {
        if (this.wizardDescriptor != null) {
            if (msg == null) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            } else if (msg.isInfo()) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)msg.getMessage());
            } else {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)msg.getMessage());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        AbstractWizardPanel step = (AbstractWizardPanel)e.getSource();
        this.setErrorMessage(step.getErrorMessage());
    }

    GitURI getRemoteURI() {
        return this.wizardIterator.repositoryStep.getURI();
    }

    List<String> getBranchNames() {
        if (this.wizardIterator.current() == this.wizardIterator.cloneDestinationStep) {
            return this.wizardIterator.fetchBranchesStep.getSelectedBranchNames();
        }
        return ALL_BRANCHES;
    }

    File getDestination() {
        return this.wizardIterator.current() == this.wizardIterator.cloneDestinationStep ? this.wizardIterator.cloneDestinationStep.getDestination() : this.wizardIterator.repositoryStep.getDestination();
    }

    String getRemoteName() {
        if (this.wizardIterator.current() == this.wizardIterator.cloneDestinationStep) {
            return this.wizardIterator.cloneDestinationStep.getRemoteName();
        }
        return "origin";
    }

    GitBranch getBranch() {
        if (this.wizardIterator.current() == this.wizardIterator.cloneDestinationStep) {
            return this.wizardIterator.cloneDestinationStep.getBranch();
        }
        Map<String, GitBranch> branches = this.wizardIterator.repositoryStep.getBranches();
        GitBranch activeBranch = null;
        for (GitBranch b : branches.values()) {
            if (b.isActive()) {
                activeBranch = b;
                break;
            }
            if (activeBranch != null) continue;
            activeBranch = b;
        }
        return activeBranch;
    }

    boolean scanForProjects() {
        return this.wizardIterator.cloneDestinationStep.scanForProjects();
    }

    private void onFinished() {
        String targetFolderPath = this.getDestination().getParentFile().getAbsolutePath();
        GitModuleConfig.getDefault().getPreferences().put("cloneDestinationStep.cloneDirectory", targetFolderPath);
    }

    boolean isFinishing() {
        return this.wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION;
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor> {
        private RepositoryStep repositoryStep;
        private FetchBranchesStep fetchBranchesStep;
        private CloneDestinationStep cloneDestinationStep;

        private PanelsIterator() {
        }

        protected WizardDescriptor.Panel<WizardDescriptor>[] initializePanels() {
            this.repositoryStep = new RepositoryStep(CloneWizard.this, CloneWizard.this.pa, CloneWizard.this.forPath);
            this.repositoryStep.addChangeListener(CloneWizard.this);
            this.fetchBranchesStep = new FetchBranchesStep();
            this.fetchBranchesStep.addChangeListener(CloneWizard.this);
            this.cloneDestinationStep = new CloneDestinationStep();
            this.cloneDestinationStep.addChangeListener(CloneWizard.this);
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this.repositoryStep, this.fetchBranchesStep, this.cloneDestinationStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public synchronized void nextPanel() {
            if (this.current() == this.repositoryStep) {
                Map<String, GitBranch> branches = this.repositoryStep.getBranches();
                this.fetchBranchesStep.fillRemoteBranches(branches.values());
                this.cloneDestinationStep.setDestinationFolder(this.repositoryStep.getDestinationFolder());
                this.repositoryStep.store();
            } else if (this.current() == this.fetchBranchesStep) {
                this.cloneDestinationStep.setBranches(this.fetchBranchesStep.getSelectedBranches());
                this.cloneDestinationStep.initCloneName(this.repositoryStep.getURI());
            }
            super.nextPanel();
        }

        public synchronized void previousPanel() {
            super.previousPanel();
        }
    }
}

