/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.MethodTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.JavadocHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;

public class ParameterNameProviderImpl {
    public static boolean DISABLE_ARTIFICAL_PARAMETER_NAMES;
    static final int MAX_CACHE_SIZE = 100;
    private static final LinkedHashMap<String, Map<String, java.util.List<String>>> source_toplevelClass2method2Parameters;
    private static final LinkedHashMap<String, Map<String, java.util.List<String>>> javadoc_class2method2Parameters;
    private static final LinkedHashMap<String, java.util.List<String>> artificial_method2Parameters;
    private final ClasspathInfo cpInfo;
    private final JavacTask task;
    private static final boolean ALWAYS_ALLOW_JDOC_ARG_NAMES;
    private static final Pattern ctor_summary_name;
    private static final Pattern method_summary_name;
    private static final Pattern field_detail_name;
    private static final Pattern ctor_detail_name;
    private static final Pattern method_detail_name;
    private static final int MAX_LEN = 6;
    private static final char[] VOWELS;

    public static void register(JavacTask task, ClasspathInfo cpInfo) {
        try {
            Class<?> c = Class.forName("com.sun.source.util.ParameterNameProvider");
            final ParameterNameProviderImpl impl = new ParameterNameProviderImpl(cpInfo, task);
            InvocationHandler h = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("getParameterName")) {
                        return impl.getParameterName((VariableElement)args[0]);
                    }
                    return null;
                }
            };
            Object proxy = Proxy.newProxyInstance(ParameterNameProviderImpl.class.getClassLoader(), new Class[]{c}, h);
            JavacTask.class.getDeclaredMethod("setParameterNameProvider", c).invoke((Object)task, proxy);
        }
        catch (ClassNotFoundException c) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public ParameterNameProviderImpl(ClasspathInfo cpInfo, JavacTask task) {
        this.cpInfo = cpInfo;
        this.task = task;
    }

    public CharSequence getParameterName(VariableElement parameter) {
        Element clazzCandidate;
        java.util.List<Object> names;
        String methodKey;
        Element method;
        block5: {
            method = parameter.getEnclosingElement();
            methodKey = ParameterNameProviderImpl.computeKey(method);
            names = null;
            Element topLevel = parameter;
            while (topLevel.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                topLevel = topLevel.getEnclosingElement();
            }
            ElementHandle<VariableElement> topLevelHandle = ElementHandle.create(topLevel);
            String topLevelKey = ParameterNameProviderImpl.computeKey(topLevel);
            try {
                names = (java.util.List<String>)source_toplevelClass2method2Parameters.computeIfAbsent(topLevelKey, d -> {
                    JavaSource javaSource;
                    final HashMap parametersInClass = new HashMap();
                    FileObject source = SourceUtils.getFile(topLevelHandle, this.cpInfo);
                    JavaSource javaSource2 = javaSource = source != null ? JavaSource.forFileObject(source) : null;
                    if (javaSource != null) {
                        try {
                            javaSource.runUserActionTask(cc -> {
                                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                new TreePathScanner<Void, Void>(){

                                    @Override
                                    public Void visitMethod(MethodTree mt, Void v) {
                                        Element el = cc.getTrees().getElement(this.getCurrentPath());
                                        if (el != null && el.getKind() == ElementKind.METHOD) {
                                            parametersInClass.put(ParameterNameProviderImpl.computeKey(el), ((ExecutableElement)el).getParameters().stream().map(p -> p.getSimpleName().toString()).collect(Collectors.toList()));
                                        }
                                        return (Void)super.visitMethod(mt, v);
                                    }
                                }.scan(cc.getCompilationUnit(), null);
                            }, true);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return parametersInClass;
                }).get(methodKey);
            }
            catch (ConcurrentModificationException ex) {
                if (!source_toplevelClass2method2Parameters.containsKey(topLevelKey)) break block5;
                names = source_toplevelClass2method2Parameters.get(topLevelKey).get(methodKey);
            }
        }
        if (names == null && (clazzCandidate = method.getEnclosingElement()) != null && (clazzCandidate.getKind().isClass() || clazzCandidate.getKind().isInterface())) {
            TypeElement clazz = (TypeElement)clazzCandidate;
            names = (java.util.List)javadoc_class2method2Parameters.computeIfAbsent(clazz.getQualifiedName().toString(), clz -> {
                HashMap result = new HashMap();
                ParameterNameProviderImpl.fillInParameterNamesFromJavadoc(((JavacTaskImpl)this.task).getContext(), clazz, (m, n) -> result.put(ParameterNameProviderImpl.computeKey(m), n));
                return result;
            }).get(methodKey);
        }
        if (names == null) {
            names = !DISABLE_ARTIFICAL_PARAMETER_NAMES ? artificial_method2Parameters.computeIfAbsent(methodKey, mk -> {
                HashSet usedNames = new HashSet();
                return ((ExecutableElement)method).getParameters().stream().map(p -> ParameterNameProviderImpl.generateReadableParameterName(p.asType().toString(), usedNames)).collect(Collectors.toList());
            }) : Collections.emptyList();
        }
        ParameterNameProviderImpl.capCache(source_toplevelClass2method2Parameters);
        ParameterNameProviderImpl.capCache(javadoc_class2method2Parameters);
        ParameterNameProviderImpl.capCache(artificial_method2Parameters);
        int idx = ((ExecutableElement)method).getParameters().indexOf(parameter);
        return idx != -1 && idx < names.size() ? (CharSequence)names.get(idx) : null;
    }

    private static String computeKey(Element el) {
        return Arrays.stream(SourceUtils.getJVMSignature(ElementHandle.create(el))).collect(Collectors.joining(":"));
    }

    static void capCache(LinkedHashMap<String, ?> map) {
        Iterator<String> it = map.keySet().iterator();
        while (map.size() > 100) {
            it.next();
            it.remove();
        }
    }

    public static boolean fillInParameterNamesFromJavadoc(Context ctx, TypeElement type, BiConsumer<ExecutableElement, java.util.List<String>> setNamesToMethod) {
        JavadocHelper.TextStream page = JavadocHelper.getJavadoc((Element)type, ALWAYS_ALLOW_JDOC_ARG_NAMES, null);
        if (!(page == null || page.isRemote() && EventQueue.isDispatchThread())) {
            ParameterNameProviderImpl.getParamNamesFromJavadocText(ctx, page, (Symbol.ClassSymbol)type, setNamesToMethod);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getParamNamesFromJavadocText(final Context context, JavadocHelper.TextStream page, final Symbol.ClassSymbol clazz, final BiConsumer<ExecutableElement, java.util.List<String>> setNamesToMethod) {
        InputStream is = null;
        String charset = null;
        while (true) {
            ParserDelegator parser;
            try {
                is = page.openStream();
                InputStreamReader reader = charset == null ? new InputStreamReader(is) : new InputStreamReader(is, charset);
                parser = new ParserDelegator();
                ((HTMLEditorKit.Parser)parser).parse(reader, new HTMLEditorKit.ParserCallback(){
                    private int state = 0;
                    private String signature = null;
                    private StringBuilder sb = null;

                    @Override
                    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                        if (t == HTML.Tag.A) {
                            int idx;
                            String attrHref;
                            String attrName = (String)a.getAttribute(HTML.Attribute.NAME);
                            if (attrName != null && ctor_summary_name.matcher(attrName).matches()) {
                                this.state = 10;
                            } else if (attrName != null && method_summary_name.matcher(attrName).matches()) {
                                this.state = 20;
                            } else if (attrName != null && field_detail_name.matcher(attrName).matches()) {
                                this.state = 30;
                            } else if (attrName != null && ctor_detail_name.matcher(attrName).matches()) {
                                this.state = 30;
                            } else if (attrName != null && method_detail_name.matcher(attrName).matches()) {
                                this.state = 30;
                            } else if ((this.state == 12 || this.state == 22) && (attrHref = (String)a.getAttribute(HTML.Attribute.HREF)) != null && (idx = attrHref.indexOf(35)) >= 0) {
                                this.signature = attrHref.substring(idx + 1);
                                this.sb = new StringBuilder();
                            }
                        } else if (t == HTML.Tag.TABLE) {
                            if (this.state == 10 || this.state == 20) {
                                ++this.state;
                            }
                        } else if (t == HTML.Tag.CODE) {
                            if (this.state == 11 || this.state == 21) {
                                ++this.state;
                            }
                        } else if (t == HTML.Tag.DIV && a.containsAttribute(HTML.Attribute.CLASS, "block")) {
                            if (this.state == 11 && this.signature != null && this.sb != null) {
                                this.setParamNames(this.signature, this.sb.toString().trim(), true);
                                this.signature = null;
                                this.sb = null;
                            } else if (this.state == 21 && this.signature != null && this.sb != null) {
                                this.setParamNames(this.signature, this.sb.toString().trim(), false);
                                this.signature = null;
                                this.sb = null;
                            }
                        }
                    }

                    @Override
                    public void handleEndTag(HTML.Tag t, int pos) {
                        if (t == HTML.Tag.CODE) {
                            if (this.state == 12 || this.state == 22) {
                                --this.state;
                            }
                        } else if (t == HTML.Tag.TABLE && (this.state == 11 || this.state == 21)) {
                            --this.state;
                        }
                    }

                    @Override
                    public void handleText(char[] data, int pos) {
                        if (this.signature != null && this.sb != null && (this.state == 12 || this.state == 22)) {
                            this.sb.append(data);
                        }
                    }

                    @Override
                    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                        if (t == HTML.Tag.BR) {
                            if (this.state == 11 && this.signature != null && this.sb != null) {
                                this.setParamNames(this.signature, this.sb.toString().trim(), true);
                                this.signature = null;
                                this.sb = null;
                            } else if (this.state == 21 && this.signature != null && this.sb != null) {
                                this.setParamNames(this.signature, this.sb.toString().trim(), false);
                                this.signature = null;
                                this.sb = null;
                            }
                        }
                    }

                    private void setParamNames(String signature, String names, boolean isCtor) {
                        ArrayList<String> paramTypes = new ArrayList<String>();
                        int idx = -1;
                        for (int i = 0; i < signature.length(); ++i) {
                            switch (signature.charAt(i)) {
                                case '(': 
                                case ')': 
                                case ',': 
                                case '-': {
                                    if (idx > -1 && idx < i - 1) {
                                        String typeName = signature.substring(idx + 1, i).trim();
                                        if (typeName.endsWith("...")) {
                                            typeName = typeName.substring(0, typeName.length() - 3) + "[]";
                                        }
                                        paramTypes.add(typeName);
                                    }
                                    idx = i;
                                }
                            }
                        }
                        String methodName = null;
                        ArrayList<String> paramNames = new ArrayList<String>();
                        idx = -1;
                        block9: for (int i = 0; i < names.length(); ++i) {
                            switch (names.charAt(i)) {
                                case '(': {
                                    methodName = names.substring(0, i);
                                    continue block9;
                                }
                                case ')': 
                                case ',': {
                                    if (idx <= -1) continue block9;
                                    paramNames.add(names.substring(idx + 1, i));
                                    idx = -1;
                                    continue block9;
                                }
                                case '\u00a0': {
                                    idx = i;
                                }
                            }
                        }
                        assert (methodName != null) : "Null methodName. Signature: [" + signature + "], Names: [" + names + "]";
                        assert (paramTypes.size() == paramNames.size()) : "Inconsistent param types/names. Signature: [" + signature + "], Names: [" + names + "]";
                        if (paramNames.size() > 0) {
                            for (Symbol s : clazz.members().getSymbolsByName(isCtor ? clazz.name.table.names.init : clazz.name.table.fromString(methodName))) {
                                if (s.kind != Kinds.Kind.MTH || s.owner != clazz) continue;
                                Symbol.MethodSymbol sym = (Symbol.MethodSymbol)s;
                                List<Symbol.VarSymbol> params = sym.params;
                                if (!this.checkParamTypes(params, paramTypes)) continue;
                                setNamesToMethod.accept(sym, paramNames);
                            }
                        }
                    }

                    private boolean checkParamTypes(List<Symbol.VarSymbol> params, ArrayList<String> paramTypes) {
                        Types types = Types.instance(context);
                        for (String typeName : paramTypes) {
                            if (params.isEmpty()) {
                                return false;
                            }
                            Type type = ((Symbol.VarSymbol)params.head).type;
                            if (type.isParameterized()) {
                                type = types.erasure(type);
                            }
                            if (!typeName.equals(type.toString())) {
                                return false;
                            }
                            params = params.tail;
                        }
                        return params.isEmpty();
                    }
                }, charset != null);
                boolean bl = true;
                return bl;
            }
            catch (ChangedCharSetException e) {
                if (charset == null) {
                    charset = JavadocHelper.getCharSet(e);
                    continue;
                }
                e.printStackTrace();
            }
            catch (InterruptedIOException x) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                parser = null;
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                continue;
            }
            break;
        }
        return false;
    }

    @NonNull
    public static String generateReadableParameterName(@NonNull String typeName, @NonNull Set<String> used) {
        boolean arr = typeName.indexOf("[") > 0 || typeName.endsWith("...");
        typeName = ParameterNameProviderImpl.trimToSimpleName(typeName);
        String result = typeName.toLowerCase();
        if (typeName.endsWith("Listener")) {
            result = Character.toLowerCase(typeName.charAt(0)) + "l";
        } else if ("Object".equals(typeName)) {
            result = "o";
        } else if ("Class".equals(typeName)) {
            result = "type";
        } else if ("InputStream".equals(typeName)) {
            result = "in";
        } else if ("OutputStream".equals(typeName)) {
            result = "out";
        } else if ("Runnable".equals(typeName)) {
            result = "r";
        } else if ("Lookup".equals(typeName)) {
            result = "lkp";
        } else if (typeName.endsWith("Stream")) {
            result = "stream";
        } else if (typeName.endsWith("Writer")) {
            result = "writer";
        } else if (typeName.endsWith("Reader")) {
            result = "reader";
        } else if (typeName.endsWith("Panel")) {
            result = "pnl";
        } else if (typeName.endsWith("Action")) {
            result = "action";
        }
        if (result.length() > 6 && (result = ParameterNameProviderImpl.tryToMakeAcronym(typeName)).length() > 6 && (result = ParameterNameProviderImpl.elideVowelsAndRepetitions(result)).length() > 6) {
            result = ("" + result.charAt(0)).toLowerCase();
        }
        if (result.trim().length() == 0) {
            result = "value";
        }
        if (arr) {
            result = result + "s";
        }
        if (ParameterNameProviderImpl.isPrimitiveTypeName(result) || !BaseUtilities.isJavaIdentifier((String)result)) {
            StringBuilder sb = new StringBuilder();
            sb.append(result.charAt(0));
            result = sb.toString();
        }
        String test = result;
        int revs = 0;
        while (used.contains(test)) {
            test = result + ++revs;
        }
        result = test;
        used.add(result);
        return result;
    }

    private static String trimToSimpleName(String typeName) {
        String result = typeName;
        int ix = result.indexOf("<");
        if (ix > 0 && ix != typeName.length() - 1) {
            result = typeName.substring(0, ix);
        }
        if (result.endsWith("...")) {
            result = result.substring(0, result.length() - 3);
        }
        if ((ix = result.lastIndexOf("$")) > 0 && ix != result.length() - 1) {
            result = result.substring(ix + 1);
        } else {
            ix = result.lastIndexOf(".");
            if (ix > 0 && ix != result.length() - 1) {
                result = result.substring(ix + 1);
            }
        }
        ix = result.indexOf("[");
        if (ix > 0) {
            result = result.substring(0, ix);
        }
        return result;
    }

    private static String elideVowelsAndRepetitions(String name) {
        char[] chars = name.toCharArray();
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char lastUsed = '\u0000';
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isDigit(c)) continue;
            if (i == 0 || Character.isUpperCase(c)) {
                if (lastUsed != c) {
                    sb.append(c);
                    lastUsed = c;
                }
            } else if (c != last && !ParameterNameProviderImpl.isVowel(c) && lastUsed != c) {
                sb.append(c);
                lastUsed = c;
            }
            last = c;
        }
        return sb.toString();
    }

    private static boolean isVowel(char c) {
        return Arrays.binarySearch(VOWELS, c) >= 0;
    }

    private static boolean isPrimitiveTypeName(String typeName) {
        return "void".equals(typeName) || "int".equals(typeName) || "long".equals(typeName) || "float".equals(typeName) || "double".equals(typeName) || "short".equals(typeName) || "char".equals(typeName) || "boolean".equals(typeName);
    }

    private static String tryToMakeAcronym(String s) {
        char[] c = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            if (!Character.isUpperCase(c[i])) continue;
            sb.append(c[i]);
        }
        if (sb.length() > 1) {
            return sb.toString().toLowerCase();
        }
        return s.toLowerCase();
    }

    static {
        source_toplevelClass2method2Parameters = new LinkedHashMap();
        javadoc_class2method2Parameters = new LinkedHashMap();
        artificial_method2Parameters = new LinkedHashMap();
        ALWAYS_ALLOW_JDOC_ARG_NAMES = Boolean.getBoolean("java.source.args.from.http.jdoc");
        ctor_summary_name = Pattern.compile("constructor[_.]summary");
        method_summary_name = Pattern.compile("method[_.]summary");
        field_detail_name = Pattern.compile("field[_.]detail");
        ctor_detail_name = Pattern.compile("constructor[_.]detail");
        method_detail_name = Pattern.compile("method[_.]detail");
        VOWELS = new char[]{'a', 'e', 'i', 'o', 'u', 'y', '\u00e9', '\u00ea', '\u00e8', '\u00e1', '\u00e2', '\u00e6', '\u00e0', '\u03b1', '\u00e3', '\u00e5', '\u00e4', '\u00eb', '\u00f3', '\u00f4', '\u0153', '\u00f2', '\u03bf', '\u00f5', '\u00f6', '\u00ed', '\u00ee', '\u00ec', '\u03b9', '\u00ef', '\u00fa', '\u00fb', '\u00f9', '\u03d2', '\u03c5', '\u00fc', '\u0430', '\u043e', '\u044f', '\u0438', '\u0439', '\u0435', '\u044b', '\u044d', '\u0443', '\u044e'};
    }
}

