/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.libraries;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Bundle;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Dependency;
import org.netbeans.modules.javascript.nodejs.ui.libraries.EditPanel;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Library;
import org.netbeans.modules.javascript.nodejs.ui.libraries.LibraryProvider;
import org.netbeans.modules.javascript.nodejs.ui.libraries.SearchPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DependenciesPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(DependenciesPanel.class.getName(), 3);
    private Dependencies allDependencies;
    private List<Dependency> dependencies;
    private final DependencyTableModel tableModel = new DependencyTableModel();
    private boolean installedLibrariesSet;
    private Project project;
    private SearchPanel searchPanel;
    private Dependency.Type dependencyType;
    private JButton addButton;
    private JButton dummyButton;
    private JButton editButton;
    private JButton moveDevelopment;
    private JLabel moveLabel;
    private JButton moveOptional;
    private JButton moveRegular;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JTable table;
    private JButton updateButton;

    public DependenciesPanel() {
        this.initComponents();
        this.table.getSelectionModel().addListSelectionListener(new Listener());
        VersionColumnRenderer versionColumnRenderer = new VersionColumnRenderer();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(versionColumnRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(versionColumnRenderer);
        tableColumnModel.getColumn(3).setCellRenderer(versionColumnRenderer);
        GroupLayout layout = (GroupLayout)this.getLayout();
        layout.setHonorsVisibility(this.dummyButton, false);
        this.updateButtons();
    }

    void setProject(Project project) {
        this.project = project;
    }

    void setDependencyType(Dependency.Type dependencyType) {
        this.dependencyType = dependencyType;
        this.moveRegular.setVisible(dependencyType != Dependency.Type.REGULAR);
        this.moveDevelopment.setVisible(dependencyType != Dependency.Type.DEVELOPMENT);
        this.moveOptional.setVisible(dependencyType != Dependency.Type.OPTIONAL);
        this.dummyButton.setVisible(false);
        String hiddenButtonText = null;
        switch (dependencyType) {
            case REGULAR: {
                hiddenButtonText = this.moveRegular.getText();
                break;
            }
            case DEVELOPMENT: {
                hiddenButtonText = this.moveDevelopment.getText();
                break;
            }
            case OPTIONAL: {
                hiddenButtonText = this.moveOptional.getText();
            }
        }
        this.dummyButton.setText(hiddenButtonText);
    }

    Dependency.Type getDependencyType() {
        return this.dependencyType;
    }

    void setDependencies(Dependencies allDependencies) {
        this.allDependencies = allDependencies;
        this.dependencies = allDependencies.forType(this.dependencyType);
        this.sortDependencies();
        HashSet<String> dependencyNames = new HashSet<String>();
        for (Dependency dependency : this.dependencies) {
            dependencyNames.add(dependency.getName());
        }
        this.loadDependencyInfo(dependencyNames);
        allDependencies.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DependenciesPanel.this.sortDependencies();
                DependenciesPanel.this.tableModel.fireTableDataChanged();
            }
        });
    }

    List<Dependency> getSelectedDependencies() {
        return this.dependencies;
    }

    private void sortDependencies() {
        Collections.sort(this.dependencies, new DependencyComparator());
    }

    private void loadDependencyInfo(final Set<String> dependencyNames) {
        if (RP.isRequestProcessorThread()) {
            LibraryProvider provider = LibraryProvider.forProject(this.project);
            for (String dependencyName : dependencyNames) {
                Library library = provider.libraryDetails(dependencyName, false);
                this.updateDependencyInfo(dependencyName, library);
            }
        } else {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DependenciesPanel.this.loadDependencyInfo(dependencyNames);
                }
            });
        }
    }

    private void updateDependencyInfo(final String libraryName, final Library library) {
        if (EventQueue.isDispatchThread()) {
            this.allDependencies.dependencyInfo.put(libraryName, library);
            this.tableModel.fireTableRowsUpdated(0, this.dependencies.size() - 1);
            this.updateButtons();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DependenciesPanel.this.updateDependencyInfo(libraryName, library);
                }
            });
        }
    }

    void setInstalledLibraries(Map<String, String> installedLibraries) {
        this.installedLibrariesSet = true;
        if (installedLibraries != null) {
            for (Dependency dependency : this.dependencies) {
                String name = dependency.getName();
                String installedVersion = installedLibraries.get(name);
                dependency.setInstalledVersion(installedVersion);
            }
        }
        this.tableModel.fireTableRowsUpdated(0, this.dependencies.size() - 1);
    }

    final void updateButtons() {
        int selectedRows = this.table.getSelectedRowCount();
        this.editButton.setEnabled(selectedRows == 1);
        this.removeButton.setEnabled(selectedRows > 0);
        this.moveRegular.setEnabled(selectedRows > 0);
        this.moveDevelopment.setEnabled(selectedRows > 0);
        this.moveOptional.setEnabled(selectedRows > 0);
        boolean updateAvailable = false;
        for (int selectedRow : this.table.getSelectedRows()) {
            Library.Version latestVersion;
            Dependency dependency = this.dependencies.get(selectedRow);
            String name = dependency.getName();
            Library library = this.allDependencies.dependencyInfo.get(name);
            if (library == null || (latestVersion = library.getLatestVersion()) == null || Objects.equals(latestVersion.getName(), dependency.getInstalledVersion())) continue;
            updateAvailable = true;
            break;
        }
        this.updateButton.setEnabled(updateAvailable);
    }

    private SearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel(LibraryProvider.forProject(this.project));
        }
        return this.searchPanel;
    }

    private void showSearchDialog() {
        String libraryName;
        SearchPanel panel = this.getSearchPanel();
        panel.activate();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.DependenciesPanel_searchDialog_title(), true, new Object[]{panel.getAddButton(), panel.getCancelButton()}, (Object)panel.getAddButton(), 0, HelpCtx.DEFAULT_HELP, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        panel.deactivate();
        if (descriptor.getValue() == panel.getAddButton() && (libraryName = panel.getSelectedLibrary()) != null) {
            String requiredVersion = panel.getRequiredVersion();
            String installedVersion = panel.getInstalledVersion();
            this.addLibrary(libraryName, requiredVersion, installedVersion);
        }
    }

    private void showEditDialog() {
        EditPanel panel = new EditPanel();
        int border = LayoutStyle.getInstance().getContainerGap(panel, 1, null);
        panel.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
        panel.setLibraryProvider(LibraryProvider.forProject(this.project));
        int selectedRow = this.table.getSelectedRow();
        Dependency dependency = this.dependencies.get(selectedRow);
        panel.setDependency(dependency);
        String update = Bundle.DependenciesPanel_editDialog_update();
        String cancel = Bundle.DependenciesPanel_editDialog_cancel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.DependenciesPanel_editDialog_title(), true, new Object[]{update, cancel}, (Object)update, 0, HelpCtx.DEFAULT_HELP, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        if (update.equals(descriptor.getValue())) {
            this.addLibrary(dependency.getName(), panel.getRequiredVersion(), panel.getInstalledVersion());
        }
    }

    private void addLibrary(String libraryName, String requiredVersion, String installedVersion) {
        Dependency dependency;
        int index = this.findDependency(libraryName);
        if (index == -1) {
            if (!this.checkOtherDependencyTypes(libraryName)) {
                return;
            }
            dependency = new Dependency(libraryName);
            this.dependencies.add(dependency);
            this.loadDependencyInfo(Collections.singleton(libraryName));
            this.sortDependencies();
        } else {
            dependency = this.dependencies.get(index);
        }
        dependency.setRequiredVersion(requiredVersion);
        dependency.setInstalledVersion(installedVersion);
        if (index == -1) {
            this.tableModel.fireTableDataChanged();
            index = this.findDependency(libraryName);
            this.table.getSelectionModel().setSelectionInterval(index, index);
        } else {
            this.tableModel.fireTableRowsUpdated(0, this.dependencies.size() - 1);
        }
    }

    private boolean checkOtherDependencyTypes(String libraryName) {
        List<Dependency.Type> types = this.allDependencies.otherDependencyTypes(libraryName, this.dependencyType);
        if (!types.isEmpty()) {
            StringBuilder dependencyTypesMessage = new StringBuilder();
            for (Dependency.Type type : types) {
                String dependencyTypeMessage;
                switch (type) {
                    case REGULAR: {
                        dependencyTypeMessage = Bundle.DependenciesPanel_otherRegularDependency();
                        break;
                    }
                    case DEVELOPMENT: {
                        dependencyTypeMessage = Bundle.DependenciesPanel_otherDevelopmentDependency();
                        break;
                    }
                    case OPTIONAL: {
                        dependencyTypeMessage = Bundle.DependenciesPanel_otherOptionalDependency();
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                dependencyTypesMessage.append(Bundle.DependenciesPanel_alsoDependency(dependencyTypeMessage));
            }
            String message = Bundle.DependenciesPanel_otherDependencyWarning(libraryName, dependencyTypesMessage);
            NotifyDescriptor descriptor = new NotifyDescriptor((Object)message, Bundle.DependenciesPanel_otherDependencyTitle(), -1, 1, new Object[]{Bundle.DependenciesPanel_addAndRemove(), Bundle.DependenciesPanel_addAndKeep(), Bundle.DependenciesPanel_cancel()}, (Object)Bundle.DependenciesPanel_addAndRemove());
            DialogDisplayer.getDefault().notify(descriptor);
            Object retVal = descriptor.getValue();
            if (Bundle.DependenciesPanel_addAndKeep().equals(retVal)) {
                return true;
            }
            if (Bundle.DependenciesPanel_addAndRemove().equals(retVal)) {
                this.allDependencies.removeOtherDependencies(libraryName, this.dependencyType);
                return true;
            }
            return false;
        }
        return true;
    }

    private int findDependency(String name) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            Dependency dependency = this.dependencies.get(i);
            if (!dependency.getName().equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    private void removeSelectedDependencies() {
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.dependencies.remove(selectedRows[i]);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void updateSelectedDependencies() {
        int[] selectedRows;
        for (int selectedRow : selectedRows = this.table.getSelectedRows()) {
            String newVersion;
            String oldVersion;
            Library.Version version;
            Dependency dependency = this.dependencies.get(selectedRow);
            String name = dependency.getName();
            Library library = this.allDependencies.dependencyInfo.get(name);
            if (library == null || (version = library.getLatestVersion()) == null || Objects.equals(oldVersion = dependency.getInstalledVersion(), newVersion = version.getName())) continue;
            dependency.setInstalledVersion(newVersion);
            if (!Objects.equals(dependency.getRequiredVersion(), oldVersion)) continue;
            dependency.setRequiredVersion(newVersion);
        }
        this.tableModel.fireTableRowsUpdated(0, this.dependencies.size() - 1);
        this.updateButtons();
    }

    private void moveSelectedDependencies(Dependency.Type targetType) {
        ArrayList<Dependency> toMove = new ArrayList<Dependency>();
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            Dependency dependency = this.dependencies.remove(selectedRows[i]);
            toMove.add(dependency);
        }
        this.allDependencies.addDependencies(toMove, targetType);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.updateButton = new JButton();
        this.moveRegular = new JButton();
        this.moveDevelopment = new JButton();
        this.moveOptional = new JButton();
        this.moveLabel = new JLabel();
        this.dummyButton = new JButton();
        this.table.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.editButton.text"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.editButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.updateButton.text"));
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.updateButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveRegular, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.moveRegular.text"));
        this.moveRegular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.moveRegularActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveDevelopment, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.moveDevelopment.text"));
        this.moveDevelopment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.moveDevelopmentActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveOptional, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.moveOptional.text"));
        this.moveOptional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.moveOptionalActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.moveLabel, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.moveLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addComponent(this.editButton).addComponent(this.removeButton).addComponent(this.updateButton).addComponent(this.moveRegular).addComponent(this.moveDevelopment).addComponent(this.moveOptional).addComponent(this.moveLabel).addComponent(this.dummyButton)).addContainerGap()));
        layout.linkSize(0, this.addButton, this.dummyButton, this.editButton, this.moveDevelopment, this.moveOptional, this.moveRegular, this.removeButton, this.updateButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateButton).addGap(18, 18, 18).addComponent(this.moveLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveRegular).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDevelopment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveOptional).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.scrollPane)).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.showSearchDialog();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.showEditDialog();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeSelectedDependencies();
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.updateSelectedDependencies();
    }

    private void moveRegularActionPerformed(ActionEvent evt) {
        this.moveSelectedDependencies(Dependency.Type.REGULAR);
    }

    private void moveDevelopmentActionPerformed(ActionEvent evt) {
        this.moveSelectedDependencies(Dependency.Type.DEVELOPMENT);
    }

    private void moveOptionalActionPerformed(ActionEvent evt) {
        this.moveSelectedDependencies(Dependency.Type.OPTIONAL);
    }

    static class Dependencies {
        private final Map<Dependency.Type, List<Dependency>> dependencies = new EnumMap<Dependency.Type, List<Dependency>>(Dependency.Type.class);
        private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
        final Map<String, Library> dependencyInfo = new HashMap<String, Library>();

        Dependencies(PackageJson.NpmDependencies npmDependencies) {
            this.dependencies.put(Dependency.Type.REGULAR, this.toList(npmDependencies.dependencies));
            this.dependencies.put(Dependency.Type.DEVELOPMENT, this.toList(npmDependencies.devDependencies));
            this.dependencies.put(Dependency.Type.OPTIONAL, this.toList(npmDependencies.optionalDependencies));
        }

        private List<Dependency> toList(Map<String, String> map) {
            ArrayList<Dependency> list = new ArrayList<Dependency>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String name = entry.getKey();
                String requiredVersion = entry.getValue();
                Dependency dependency = new Dependency(name);
                dependency.setRequiredVersion(requiredVersion);
                list.add(dependency);
            }
            return list;
        }

        List<Dependency> forType(Dependency.Type type) {
            return this.dependencies.get((Object)type);
        }

        List<Dependency.Type> otherDependencyTypes(String dependencyName, Dependency.Type dependencyType) {
            ArrayList<Dependency.Type> types = new ArrayList<Dependency.Type>();
            block0: for (Map.Entry<Dependency.Type, List<Dependency>> entry : this.dependencies.entrySet()) {
                Dependency.Type type = entry.getKey();
                if (dependencyType == type) continue;
                for (Dependency dependency : entry.getValue()) {
                    if (!dependencyName.equals(dependency.getName())) continue;
                    types.add(type);
                    continue block0;
                }
            }
            return types;
        }

        void removeOtherDependencies(String dependencyName, Dependency.Type dependencyType) {
            block0: for (Map.Entry<Dependency.Type, List<Dependency>> entry : this.dependencies.entrySet()) {
                Dependency.Type type = entry.getKey();
                if (dependencyType == type) continue;
                for (Dependency dependency : entry.getValue()) {
                    if (!dependencyName.equals(dependency.getName())) continue;
                    entry.getValue().remove(dependency);
                    continue block0;
                }
            }
            this.fireChange();
        }

        void addDependencies(List<Dependency> toAdd, Dependency.Type targetType) {
            List<Dependency> targetList = this.dependencies.get((Object)targetType);
            targetList.addAll(toAdd);
            this.fireChange();
        }

        void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        private void fireChange() {
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(null);
            }
        }
    }

    class Listener
    implements ListSelectionListener {
        Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DependenciesPanel.this.updateButtons();
        }
    }

    class DependencyTableModel
    extends AbstractTableModel {
        DependencyTableModel() {
        }

        @Override
        public int getRowCount() {
            return DependenciesPanel.this.dependencies == null ? 0 : DependenciesPanel.this.dependencies.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            String columnName;
            switch (column) {
                case 0: {
                    columnName = Bundle.DependenciesPanel_table_libraryColumn();
                    break;
                }
                case 1: {
                    columnName = Bundle.DependenciesPanel_table_requiredVersionColumn();
                    break;
                }
                case 2: {
                    columnName = Bundle.DependenciesPanel_table_installedVersionColumn();
                    break;
                }
                case 3: {
                    columnName = Bundle.DependenciesPanel_table_latestVersionColumn();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return columnName;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value;
            Dependency dependency = (Dependency)DependenciesPanel.this.dependencies.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value = dependency.getName();
                    break;
                }
                case 1: {
                    value = dependency.getRequiredVersion();
                    break;
                }
                case 2: {
                    if (DependenciesPanel.this.installedLibrariesSet) {
                        value = dependency.getInstalledVersion();
                        if (value != null) break;
                        value = VersionColumnRenderer.NO_VERSION;
                        break;
                    }
                    value = VersionColumnRenderer.CHECKING;
                    break;
                }
                case 3: {
                    String libraryName = dependency.getName();
                    Library library = ((DependenciesPanel)DependenciesPanel.this).allDependencies.dependencyInfo.get(libraryName);
                    if (library == null) {
                        value = ((DependenciesPanel)DependenciesPanel.this).allDependencies.dependencyInfo.containsKey(libraryName) ? VersionColumnRenderer.UNKNOWN : VersionColumnRenderer.CHECKING;
                        break;
                    }
                    String latestVersion = library.getLatestVersion().getName();
                    if (latestVersion.equals(dependency.getInstalledVersion())) {
                        value = VersionColumnRenderer.UP_TO_DATE;
                        break;
                    }
                    value = latestVersion;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return value;
        }
    }

    static class VersionColumnRenderer
    extends DefaultTableCellRenderer {
        static final Object UP_TO_DATE = new Object();
        static final Object CHECKING = new Object();
        static final Object UNKNOWN = new Object();
        static final Object NO_VERSION = new Object();

        VersionColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String icon = null;
            String toolTip = null;
            if (value == UNKNOWN) {
                icon = "org/netbeans/modules/javascript/nodejs/ui/resources/unknown.png";
                toolTip = Bundle.DependenciesPanel_version_unknown();
            } else if (value == CHECKING) {
                icon = "org/netbeans/modules/javascript/nodejs/ui/resources/checking.png";
                toolTip = Bundle.DependenciesPanel_version_checking();
            } else if (value == UP_TO_DATE) {
                icon = "org/netbeans/modules/javascript/nodejs/ui/resources/uptodate.gif";
                toolTip = Bundle.DependenciesPanel_version_uptodate();
            } else if (value == NO_VERSION) {
                icon = "org/netbeans/modules/javascript/nodejs/ui/resources/no-version.png";
                toolTip = Bundle.DependenciesPanel_version_noversion();
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(0);
            this.setToolTipText(toolTip);
            if (icon == null) {
                this.setIcon(null);
            } else {
                this.setText(null);
                this.setIcon(ImageUtilities.loadImageIcon((String)icon, (boolean)false));
            }
            return this;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="No need to be serializable")
    static class DependencyComparator
    implements Comparator<Dependency> {
        DependencyComparator() {
        }

        @Override
        public int compare(Dependency o1, Dependency o2) {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        }
    }
}

