/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.common.xmlutils;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.XMLJ2eeDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;

public class XMLJ2eeEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie.Observable,
LineCookie,
CloseCookie,
PrintCookie {
    private static final int AUTO_PARSING_DELAY = 2000;
    private DialogDescriptor dialog;
    private RequestProcessor.Task parsingDocumentTask;
    XMLJ2eeDataObject dataObject;
    SaveCookie saveCookie = new Save();

    public XMLJ2eeEditorSupport(XMLJ2eeDataObject obj) {
        super((DataObject)obj, null, (CloneableEditorSupport.Env)new XmlEnv(obj));
        this.dataObject = obj;
        this.setMIMEType("text/xml");
    }

    protected CloneableEditorSupport.Pane createPane() {
        if (this.dataObject.getEditorMimeType() != null) {
            return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)this.dataObject.getEditorMimeType(), (Serializable)this.getDataObject());
        }
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/xml", (Serializable)this.getDataObject());
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        EditorKit k = this.createEditorKit();
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF8");
        BufferedWriter writer = new BufferedWriter(osw);
        k.write(writer, (Document)doc, 0, doc.getLength());
        ((Writer)writer).close();
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        EditorKit k = this.createEditorKit();
        InputStreamReader isr = new InputStreamReader(stream, "UTF8");
        BufferedReader reader = new BufferedReader(isr);
        k.read(reader, (Document)doc, 0);
        ((Reader)reader).close();
    }

    public void restartTimer() {
        this.dataObject.setDocumentDirty(true);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                XMLJ2eeEditorSupport.this.dataObject.parsingDocument();
            }
        };
        this.parsingDocumentTask = this.parsingDocumentTask == null || this.parsingDocumentTask.isFinished() || this.parsingDocumentTask.cancel() ? RequestProcessor.getDefault().post(r, 100) : RequestProcessor.getDefault().post(r, 2000);
    }

    protected boolean notifyModified() {
        boolean notif = super.notifyModified();
        if (!notif) {
            return false;
        }
        XMLJ2eeDataObject obj = (XMLJ2eeDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.addSaveCookie(this.saveCookie);
        }
        if (!obj.isNodeDirty()) {
            this.restartTimer();
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        XMLJ2eeDataObject obj = (XMLJ2eeDataObject)this.getDataObject();
        obj.removeSaveCookie();
    }

    public void saveDocument() throws IOException {
        final StyledDocument doc = this.getDocument();
        String enc = EncodingUtil.detectEncoding((Document)doc);
        if (enc == null) {
            enc = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), enc);
            if (!this.checkCharsetConversion(enc)) {
                return;
            }
            super.saveDocument();
        }
        catch (UnsupportedEncodingException ex) {
            String message = NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"TEXT_SAVE_AS_UTF", (Object)enc);
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)message);
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (res.equals(NotifyDescriptor.YES_OPTION)) {
                try {
                    int MAX_PROLOG = 1000;
                    int maxPrologLen = Math.min(1000, doc.getLength());
                    final char[] prolog = doc.getText(0, maxPrologLen).toCharArray();
                    int prologLen = 0;
                    if (prolog[0] == '<' && prolog[1] == '?' && prolog[2] == 'x') {
                        for (int i = 3; i < maxPrologLen; ++i) {
                            if (prolog[i] != '?' || prolog[i + 1] != '>') continue;
                            prologLen = i + 1;
                            break;
                        }
                    }
                    final int passPrologLen = prologLen;
                    Runnable edit = new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    doc.remove(0, passPrologLen + 1);
                                    doc.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(prolog, 0, passPrologLen + 1) + " -->", null);
                                }
                                catch (BadLocationException e) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    e.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)doc, (Runnable)edit);
                    super.saveDocument();
                }
                catch (BadLocationException lex) {
                    Exceptions.printStackTrace((Throwable)lex);
                }
            }
            return;
        }
    }

    private boolean checkCharsetConversion(String encoding) {
        boolean value = true;
        try {
            CharsetEncoder coder = Charset.forName(encoding).newEncoder();
            if (!coder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding}), 0, 2);
                nd.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                    value = false;
                }
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return value;
    }

    public UndoRedo.Manager getUndo() {
        return this.getUndoRedo();
    }

    protected String messageName() {
        String name = super.messageName();
        int index1 = name.indexOf(91);
        if (index1 >= 0) {
            String prefix = name.substring(0, index1);
            int index2 = name.lastIndexOf(93);
            String postfix = "";
            if (index2 >= 0) {
                postfix = name.substring(index2 + 1);
            }
            return prefix + postfix;
        }
        return name;
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(XMLJ2eeDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((XMLJ2eeDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (XMLJ2eeEditorSupport)this.getDataObject().getCookie(XMLJ2eeEditorSupport.class);
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            XMLJ2eeDataObject obj = (XMLJ2eeDataObject)XMLJ2eeEditorSupport.this.getDataObject();
            if (obj.isDocumentValid()) {
                obj.setSavingDocument(true);
                XMLJ2eeEditorSupport.this.saveDocument();
            } else {
                obj.displayErrorMessage();
                XMLJ2eeEditorSupport.this.dialog = new DialogDescriptor((Object)NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"MSG_invalidXmlWarning"), NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"TTL_invalidXmlWarning"));
                Dialog d = DialogDisplayer.getDefault().createDialog(XMLJ2eeEditorSupport.this.dialog);
                d.setVisible(true);
                if (XMLJ2eeEditorSupport.this.dialog.getValue() == DialogDescriptor.OK_OPTION) {
                    obj.setSavingDocument(true);
                    XMLJ2eeEditorSupport.this.saveDocument();
                }
            }
        }
    }
}

