/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.html.editor.api.index.HtmlIndex;
import org.netbeans.modules.html.editor.indexing.Entry;
import org.netbeans.modules.html.editor.indexing.HtmlFileModel;
import org.netbeans.modules.html.editor.indexing.HtmlLinkEntry;
import org.netbeans.modules.html.editor.refactoring.DiffElement;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.FileReferenceModification;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HtmlRenameRefactoringPlugin
implements RefactoringPlugin {
    private static final Logger LOGGER = Logger.getLogger(HtmlRenameRefactoringPlugin.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private RenameRefactoring refactoring;

    public HtmlRenameRefactoringPlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        HtmlIndex index;
        Lookup lookup = this.refactoring.getRefactoringSource();
        FileObject file = (FileObject)lookup.lookup(FileObject.class);
        if (file == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        try {
            index = HtmlIndex.get(project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ModificationResult modificationResult = new ModificationResult();
        if (file.isFolder()) {
            this.refactorFolder(file, modificationResult, index);
        } else {
            this.refactorFile(file, modificationResult, index);
        }
        refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
            }
        }
        return null;
    }

    private void refactorFolder(FileObject file, ModificationResult modificationResult, HtmlIndex index) {
        LOGGER.fine("refactor folder " + file);
        String newName = this.refactoring.getNewName();
        try {
            HtmlIndex.AllDependenciesMaps alldeps = index.getAllDependencies();
            Map<FileObject, Collection<FileReference>> source2dest = alldeps.getSource2dest();
            FileObject renamedFolder = file;
            WeakHashMap<FileObject, HtmlFileModel> modelsCache = new WeakHashMap<FileObject, HtmlFileModel>();
            HashSet<Entry> refactoredReferenceEntries = new HashSet<Entry>();
            for (FileObject source : source2dest.keySet()) {
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                Collection<FileReference> destinations = source2dest.get(source);
                for (FileReference dest : destinations) {
                    FileReferenceModification modification = dest.createModification();
                    if (!modification.rename(renamedFolder, newName)) continue;
                    HtmlFileModel model = (HtmlFileModel)modelsCache.get(source);
                    if (model == null) {
                        try {
                            model = new HtmlFileModel(Source.create((FileObject)source));
                            modelsCache.put(source, model);
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (model == null) continue;
                    List<HtmlLinkEntry> imports = model.getReferences();
                    for (Entry entry : imports) {
                        if (refactoredReferenceEntries.contains(entry) || !entry.isValidInSourceDocument() || !entry.getName().equals(dest.linkPath())) continue;
                        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)source);
                        diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), modification.getModifiedReferencePath(), NbBundle.getMessage(HtmlRenameRefactoringPlugin.class, (String)"MSG_Modify_File_Import")));
                        refactoredReferenceEntries.add(entry);
                    }
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(source, diffs);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void refactorFile(FileObject file, ModificationResult modificationResult, HtmlIndex index) {
        LOGGER.fine("refactor file " + file.getPath());
        String newName = this.refactoring.getNewName();
        DependenciesGraph deps = index.getDependencies(file);
        if (deps == null) {
            return;
        }
        Collection allRefering = deps.getSourceNode().getReferingNodes();
        for (DependenciesGraph.Node ref : allRefering) {
            FileObject refering = ref.getFile();
            try {
                CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)refering);
                Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)refering);
                HtmlFileModel model = new HtmlFileModel(source);
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                for (Entry entry : model.getReferences()) {
                    String imp = entry.getName();
                    FileObject resolvedFileObject = WebUtils.resolve((FileObject)refering, (String)imp);
                    if (resolvedFileObject == null || !resolvedFileObject.equals(file) || !entry.isValidInSourceDocument()) continue;
                    String extension = file.getExt();
                    int slashIndex = imp.lastIndexOf(47);
                    String newImport = slashIndex != -1 ? imp.substring(0, slashIndex) + "/" + newName + "." + extension : newName + "." + extension;
                    diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), newImport, NbBundle.getMessage(HtmlRenameRefactoringPlugin.class, (String)"MSG_Modify_File_Import")));
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(refering, diffs);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

