/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.PlatformFramework;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PlatformFrameworkStaxUnmarshaller
implements Unmarshaller<PlatformFramework, StaxUnmarshallerContext> {
    private static PlatformFrameworkStaxUnmarshaller instance;

    public PlatformFramework unmarshall(StaxUnmarshallerContext context) throws Exception {
        PlatformFramework platformFramework = new PlatformFramework();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return platformFramework;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    platformFramework.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Version", targetDepth)) continue;
                platformFramework.setVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return platformFramework;
    }

    public static PlatformFrameworkStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PlatformFrameworkStaxUnmarshaller();
        }
        return instance;
    }
}

