/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CustomizerBrowser
extends JPanel {
    private static final long serialVersionUID = -8744546565465456L;
    private final PhpProjectProperties uiProps;
    private final BrowserUISupport.BrowserComboBoxModel browserModel;
    private JComboBox<WebBrowser> browserComboBox;
    private JLabel browserLabel;
    private JLabel reloadInfoLabel;
    private JCheckBox reloadOnSaveCheckBox;

    CustomizerBrowser(ProjectCustomizer.Category category, PhpProjectProperties uiProps) {
        assert (category != null);
        assert (uiProps != null);
        this.uiProps = uiProps;
        this.browserModel = BrowserUISupport.createBrowserModel((String)uiProps.getBrowserId(), (boolean)true);
        this.initComponents();
        this.init();
    }

    private JComboBox<WebBrowser> createBrowserComboBox() {
        return BrowserUISupport.createBrowserPickerComboBox((String)this.browserModel.getSelectedBrowserId(), (boolean)true, (boolean)false, (ComboBoxModel)this.browserModel);
    }

    private void init() {
        this.browserComboBox.setModel((ComboBoxModel<WebBrowser>)this.browserModel);
        this.browserComboBox.setRenderer(BrowserUISupport.createBrowserRenderer());
        this.browserComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerBrowser.this.storeData();
                CustomizerBrowser.this.setReloadVisible();
            }
        });
        this.reloadOnSaveCheckBox.setSelected(Boolean.valueOf(this.uiProps.getBrowserReloadOnSave()));
        this.reloadOnSaveCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerBrowser.this.storeData();
            }
        });
        this.setReloadVisible();
    }

    void storeData() {
        this.uiProps.setBrowserId(this.browserModel.getSelectedBrowserId());
        this.uiProps.setBrowserReloadOnSave(String.valueOf(this.reloadOnSaveCheckBox.isSelected()));
    }

    void setReloadVisible() {
        WebBrowser browser = this.browserModel.getSelectedBrowser();
        boolean visible = browser != null && browser.hasNetBeansIntegration();
        this.reloadOnSaveCheckBox.setVisible(visible);
        this.reloadInfoLabel.setVisible(visible);
    }

    private void initComponents() {
        this.browserLabel = new JLabel();
        this.browserComboBox = this.createBrowserComboBox();
        this.reloadOnSaveCheckBox = new JCheckBox();
        this.reloadInfoLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.browserLabel, (String)NbBundle.getMessage(CustomizerBrowser.class, (String)"CustomizerBrowser.browserLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadOnSaveCheckBox, (String)NbBundle.getMessage(CustomizerBrowser.class, (String)"CustomizerBrowser.reloadOnSaveCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.reloadInfoLabel, (String)NbBundle.getMessage(CustomizerBrowser.class, (String)"CustomizerBrowser.reloadInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.browserLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browserComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.reloadInfoLabel)).addComponent(this.reloadOnSaveCheckBox))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browserLabel).addComponent(this.browserComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reloadOnSaveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reloadInfoLabel).addGap(0, 0, Short.MAX_VALUE)));
    }
}

