/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;

public class AttributeValueFinder {
    private final XMLSyntaxSupport xmlSupport;
    private final int start;
    private int foundOffset = -1;
    private String foundValue;

    public AttributeValueFinder(SyntaxSupport syntaxSupport, int start) {
        this.start = start;
        this.xmlSupport = XMLSyntaxSupport.getSyntaxSupport((Document)syntaxSupport.getDocument());
    }

    public AttributeValueFinder(XMLSyntaxSupport syntaxSupport, int start) {
        this.start = start;
        this.xmlSupport = syntaxSupport;
    }

    public boolean find(String attrName) throws BadLocationException {
        this.foundOffset = -1;
        this.foundValue = null;
        if (this.xmlSupport == null) {
            return false;
        }
        Token item = this.xmlSupport.getNextToken(this.start);
        if (item == null || item.id() != XMLTokenId.TAG) {
            return false;
        }
        return (Boolean)this.xmlSupport.runWithSequence(this.start, s -> {
            String currentAttrName = null;
            while (s.moveNext()) {
                Token t = s.token();
                XMLTokenId id = (XMLTokenId)t.id();
                if (id == XMLTokenId.ARGUMENT) {
                    currentAttrName = t.text().toString();
                    continue;
                }
                if (id == XMLTokenId.VALUE) {
                    if (currentAttrName == null || !currentAttrName.equals(attrName)) continue;
                    this.foundOffset = s.offset();
                    this.foundValue = t.text().toString();
                    return true;
                }
                if (id != XMLTokenId.TAG) continue;
                break;
            }
            return false;
        });
    }

    public int getFoundOffset() {
        return this.foundOffset;
    }

    public String getValue() {
        return this.foundValue;
    }
}

