/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.spi.nodes.AbstractGradleNodeList;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public final class SourcesNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project project) {
        return new NList(project);
    }

    private static class ResourcesFolderNode
    extends FilterNode {
        final SourceGroup group;

        private ResourcesFolderNode(SourceGroup group, Node original) {
            super(original);
            this.group = group;
        }

        public String getName() {
            return this.group.getName();
        }

        public String getDisplayName() {
            return this.group.getDisplayName();
        }

        static Node createResourcesFolderNode(SourceGroup group) {
            try {
                DataObject root = DataObject.find((FileObject)group.getRootFolder());
                return new ResourcesFolderNode(group, root.getNodeDelegate());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }

    private static class NList
    extends AbstractGradleNodeList<SourceGroup>
    implements ChangeListener {
        private static final RequestProcessor RP = new RequestProcessor(NList.class);
        private final Project project;

        private NList(Project prj) {
            this.project = prj;
        }

        public List<SourceGroup> keys() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            ArrayList<SourceGroup> ret = new ArrayList<SourceGroup>();
            ret.addAll(Arrays.asList(srcs.getSourceGroups("java")));
            ret.addAll(Arrays.asList(srcs.getSourceGroups("resources")));
            ret.addAll(Arrays.asList(srcs.getSourceGroups("generated")));
            ret.sort(Comparator.comparing(SourceGroup::getName));
            return ret;
        }

        public Node node(SourceGroup group) {
            Node ret;
            String name;
            Project owner = FileOwnerQuery.getOwner((FileObject)group.getRootFolder());
            if (owner != this.project) {
                if (owner == null) {
                    Logger.getLogger(SourcesNodeFactory.class.getName()).log(Level.INFO, "Cannot find a project owner for folder {0}", group.getRootFolder());
                    return null;
                }
                AbstractNode erroNode = new AbstractNode(Children.LEAF);
                String prjText = ProjectUtils.getInformation((Project)owner).getDisplayName();
                erroNode.setDisplayName("Error Node: " + group.getDisplayName() + " " + prjText);
                return erroNode;
            }
            switch (name = group.getName()) {
                case "42gatling.data": 
                case "43gatling.bodies": 
                case "49gatling.resources": {
                    ret = ResourcesFolderNode.createResourcesFolderNode(group);
                    break;
                }
                default: {
                    ret = PackageView.createPackageView((SourceGroup)group);
                }
            }
            ret.setShortDescription(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)group.getRootFolder()));
            return ret;
        }

        public void addNotify() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            srcs.addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            srcs.removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            RP.post(() -> ((NList)this).fireChange());
        }
    }
}

