/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.editor;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JavaToCHyperlinkProvider
implements HyperlinkProviderExt {
    private static final SourceGroup[] NO_GROUPS = new SourceGroup[0];

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.findNext().isHyperlinkPoint(doc, offset, type);
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        return this.findNext().getHyperlinkSpan(doc, offset, type);
    }

    public void performClickAction(Document doc, final int offset, HyperlinkType type) {
        SourceGroup[] nativeGroups;
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        Project prj = file != null ? FileOwnerQuery.getOwner((FileObject)file) : null;
        SourceGroup[] sourceGroupArray = nativeGroups = prj != null ? ProjectUtils.getSources((Project)prj).getSourceGroups("jdk-project-sources-native") : NO_GROUPS;
        if (nativeGroups.length == 0) {
            this.findNext().performClickAction(doc, offset, type);
            return;
        }
        final String[][] lookFor = new String[1][];
        try {
            JavaSource.forDocument((Document)doc).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.PARSED);
                    TreePath tp = parameter.getTreeUtilities().pathFor(offset);
                    if (tp.getLeaf().getKind() != Tree.Kind.METHOD || !((MethodTree)tp.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                        return;
                    }
                    int[] nameSpan = parameter.getTreeUtilities().findNameSpan((MethodTree)tp.getLeaf());
                    if (nameSpan[0] <= offset && offset <= nameSpan[1]) {
                        parameter.toPhase(JavaSource.Phase.RESOLVED);
                        Element el = parameter.getTrees().getElement(tp);
                        if (el != null && el.getKind() == ElementKind.METHOD) {
                            lookFor[0] = SourceUtils.getJVMSignature((ElementHandle)ElementHandle.create((Element)el));
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (lookFor[0] == null) {
            this.findNext().performClickAction(doc, offset, type);
            return;
        }
        String mangledBase = "Java_" + this.mangle(lookFor[0][0]) + "_" + this.mangle(lookFor[0][1]);
        String mangledWithParameters = mangledBase + "__" + this.mangle(lookFor[0][2].replaceAll("\\((.*)\\).*", "$1"));
        FileObject fileToOpen = null;
        int targetOffset = -1;
        block4: for (SourceGroup root : nativeGroups) {
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)root.getRootFolder());
            Enumeration en = root.getRootFolder().getChildren(true);
            while (en.hasMoreElements()) {
                FileObject current = (FileObject)en.nextElement();
                if (!current.hasExt("c") && !current.hasExt("cc") && !current.hasExt("cpp")) continue;
                try {
                    String content = new String(current.asBytes(), encoding);
                    int pos = content.indexOf(mangledWithParameters);
                    if (pos == -1) {
                        pos = content.indexOf(mangledBase);
                    }
                    if (pos == -1) continue;
                    fileToOpen = current;
                    targetOffset = pos;
                    break block4;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (fileToOpen != null) {
            UiUtils.open(fileToOpen, (int)targetOffset);
        }
    }

    private String mangle(String original) {
        StringBuilder mangled = new StringBuilder();
        block6: for (char c : original.toCharArray()) {
            switch (c) {
                case '.': 
                case '/': {
                    mangled.append("_");
                    continue block6;
                }
                case '_': {
                    mangled.append("_1");
                    continue block6;
                }
                case ';': {
                    mangled.append("_2");
                    continue block6;
                }
                case '[': {
                    mangled.append("_3");
                    continue block6;
                }
                default: {
                    mangled.append(c);
                }
            }
        }
        return mangled.toString();
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return this.findNext().getTooltipText(doc, offset, type);
    }

    private HyperlinkProviderExt findNext() {
        boolean seenMe = false;
        for (HyperlinkProviderExt p : MimeLookup.getLookup((String)"text/x-java").lookupAll(HyperlinkProviderExt.class)) {
            if (seenMe) {
                return p;
            }
            seenMe = p == this;
        }
        return new HyperlinkProviderExt(){

            public Set<HyperlinkType> getSupportedHyperlinkTypes() {
                return EnumSet.noneOf(HyperlinkType.class);
            }

            public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
                return false;
            }

            public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
                return new int[]{0, 0};
            }

            public void performClickAction(Document doc, int offset, HyperlinkType type) {
            }

            public String getTooltipText(Document doc, int offset, HyperlinkType type) {
                return null;
            }
        };
    }
}

