/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.regex.result.LazyCaptureGroupsResult;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.result.SingleIndexArrayResult;
import com.oracle.truffle.regex.result.SingleResult;
import com.oracle.truffle.regex.result.SingleResultLazyStart;
import com.oracle.truffle.regex.result.TraceFinderResult;
import com.oracle.truffle.regex.runtime.nodes.DispatchNode;
import com.oracle.truffle.regex.runtime.nodes.LazyCaptureGroupGetResultNode;
import com.oracle.truffle.regex.runtime.nodes.TraceFinderGetResultNode;

@ReportPolymorphism
@GenerateUncached
abstract class RegexResultGetStartNode
extends Node {
    private static final int INVALID_RESULT = -1;

    RegexResultGetStartNode() {
    }

    abstract int execute(Object var1, int var2);

    @Specialization
    static int doNoMatch(NoMatchResult receiver, int groupNumber) {
        return -1;
    }

    @Specialization
    static int doSingleResult(SingleResult receiver, int groupNumber, @Cached ConditionProfile boundsProfile) {
        if (boundsProfile.profile(groupNumber == 0)) {
            return receiver.getStart();
        }
        return -1;
    }

    @Specialization
    static int doSingleResultLazyStart(SingleResultLazyStart receiver, int groupNumber, @Cached DispatchNode calcResult, @Cached ConditionProfile boundsProfile, @Cached.Exclusive @Cached ConditionProfile calcLazyProfile) {
        if (boundsProfile.profile(groupNumber == 0)) {
            if (calcLazyProfile.profile(!receiver.isStartCalculated())) {
                receiver.setStart((Integer)calcResult.execute(receiver.getFindStartCallTarget(), receiver.createArgsFindStart()));
            }
            return receiver.getStart();
        }
        return -1;
    }

    @Specialization
    static int doSingleIndexArray(SingleIndexArrayResult receiver, int groupNumber) {
        return RegexResultGetStartNode.fromSingleArray(receiver.getIndices(), groupNumber);
    }

    @Specialization
    static int doTraceFinder(TraceFinderResult receiver, int groupNumber, @Cached TraceFinderGetResultNode getResultNode) {
        return RegexResultGetStartNode.fromSingleArray(getResultNode.execute(receiver), groupNumber);
    }

    @Specialization
    static int doLazyCaptureGroups(LazyCaptureGroupsResult receiver, int groupNumber, @Cached LazyCaptureGroupGetResultNode getResultNode) {
        return RegexResultGetStartNode.fromSingleArray(getResultNode.execute(receiver), groupNumber);
    }

    private static int fromSingleArray(int[] array, int groupNumber) {
        try {
            return array[groupNumber * 2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }
}

