/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.charset.CharMatchers;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeListMatcherNodeGen;

public abstract class RangeListMatcher
extends InvertibleCharMatcher {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] ranges;

    RangeListMatcher(boolean invert, int[] ranges) {
        super(invert);
        this.ranges = ranges;
    }

    public static RangeListMatcher create(boolean invert, int[] ranges) {
        return RangeListMatcherNodeGen.create(invert, ranges);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    @Specialization
    public boolean match(int c) {
        for (int i = 0; i < this.ranges.length; i += 2) {
            int lo = this.ranges[i];
            int hi = this.ranges[i + 1];
            if (RangeListMatcher.isSingleChar(lo, hi)) {
                if (lo != c) continue;
                return this.result(true);
            }
            if (RangeListMatcher.isTwoChars(lo, hi)) {
                if (c != lo && c != hi) continue;
                return this.result(true);
            }
            if (lo <= c) {
                if (hi < c) continue;
                return this.result(true);
            }
            return this.result(false);
        }
        return this.result(false);
    }

    private static boolean isSingleChar(int lo, int hi) {
        CompilerAsserts.partialEvaluationConstant((int)lo);
        CompilerAsserts.partialEvaluationConstant((int)hi);
        return lo == hi;
    }

    private static boolean isTwoChars(int lo, int hi) {
        CompilerAsserts.partialEvaluationConstant((int)lo);
        CompilerAsserts.partialEvaluationConstant((int)hi);
        return lo + 1 == hi;
    }

    @Override
    public int estimatedCost() {
        return this.ranges.length;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "list " + this.modifiersToString() + "[" + CharMatchers.rangesToString(this.ranges) + "]";
    }
}

