/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser;

import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.InlineParserFactory;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.parser.PostProcessorFactory;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessorFactory;
import com.vladsch.flexmark.parser.delimiter.DelimiterProcessor;
import com.vladsch.flexmark.parser.internal.DocumentParser;
import com.vladsch.flexmark.parser.internal.InlineParserImpl;
import com.vladsch.flexmark.parser.internal.LinkRefProcessorData;
import com.vladsch.flexmark.parser.internal.PostProcessorManager;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IParse;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.DataValueFactory;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Parser
implements IParse {
    public static final DataKey<Iterable<Extension>> EXTENSIONS = BuilderBase.EXTENSIONS;
    public static final DataKey<KeepType> REFERENCES_KEEP = new DataKey("REFERENCES_KEEP", (Object)KeepType.FIRST);
    public static final DataKey<ReferenceRepository> REFERENCES = new DataKey("REFERENCES", ReferenceRepository::new);
    public static final DataKey<Boolean> ASTERISK_DELIMITER_PROCESSOR = new DataKey("ASTERISK_DELIMITER_PROCESSOR", (Object)true);
    public static final DataKey<Boolean> TRACK_DOCUMENT_LINES = new DataKey("TRACK_DOCUMENT_LINES", (Object)false);
    public static final DataKey<Boolean> BLOCK_QUOTE_PARSER = new DataKey("BLOCK_QUOTE_PARSER", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_EXTEND_TO_BLANK_LINE = new DataKey("BLOCK_QUOTE_EXTEND_TO_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> BLOCK_QUOTE_IGNORE_BLANK_LINE = new DataKey("BLOCK_QUOTE_IGNORE_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> BLOCK_QUOTE_ALLOW_LEADING_SPACE = new DataKey("BLOCK_QUOTE_ALLOW_LEADING_SPACE", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_INTERRUPTS_PARAGRAPH = new DataKey("BLOCK_QUOTE_INTERRUPTS_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("BLOCK_QUOTE_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("BLOCK_QUOTE_WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    @Deprecated
    public static final DataKey<Boolean> BLOCK_QUOTE_TO_BLANK_LINE = BLOCK_QUOTE_EXTEND_TO_BLANK_LINE;
    public static final DataKey<Boolean> FENCED_CODE_BLOCK_PARSER = new DataKey("FENCED_CODE_BLOCK_PARSER", (Object)true);
    public static final DataKey<Boolean> MATCH_CLOSING_FENCE_CHARACTERS = new DataKey("MATCH_CLOSING_FENCE_CHARACTERS", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_CONTENT_BLOCK = new DataKey("FENCED_CODE_CONTENT_BLOCK", (Object)false);
    public static final DataKey<Boolean> CODE_SOFT_LINE_BREAKS = new DataKey("CODE_SOFT_LINE_BREAKS", (Object)false);
    @Deprecated
    public static final DataKey<Boolean> CODE_CONTENT_BLOCK = FENCED_CODE_CONTENT_BLOCK;
    public static final DataKey<Boolean> HARD_LINE_BREAK_LIMIT = new DataKey("HARD_LINE_BREAK_LIMIT", (Object)false);
    public static final DataKey<Boolean> HEADING_PARSER = new DataKey("HEADING_PARSER", (Object)true);
    public static final DataKey<Integer> HEADING_SETEXT_MARKER_LENGTH = new DataKey("HEADING_SETEXT_MARKER_LENGTH", (Object)1);
    public static final DataKey<Boolean> HEADING_NO_ATX_SPACE = new DataKey("HEADING_NO_ATX_SPACE", (Object)false);
    public static final DataKey<Boolean> HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE = new DataKey("HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE", (Object)false);
    public static final DataKey<Boolean> HEADING_NO_LEAD_SPACE = new DataKey("HEADING_NO_LEAD_SPACE", (Object)false);
    public static final DataKey<Boolean> HEADING_CAN_INTERRUPT_ITEM_PARAGRAPH = new DataKey("HEADING_CAN_INTERRUPT_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_PARSER = new DataKey("HTML_BLOCK_PARSER", (Object)true);
    public static final DataKey<Boolean> HTML_COMMENT_BLOCKS_INTERRUPT_PARAGRAPH = new DataKey("HTML_COMMENT_BLOCKS_INTERRUPT_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> HTML_FOR_TRANSLATOR = new DataKey("HTML_FOR_TRANSLATOR", (Object)false);
    public static final DataKey<Boolean> INLINE_DELIMITER_DIRECTIONAL_PUNCTUATIONS = new DataKey("INLINE_DELIMITER_DIRECTIONAL_PUNCTUATIONS", (Object)false);
    public static final DataKey<Boolean> INDENTED_CODE_BLOCK_PARSER = new DataKey("INDENTED_CODE_BLOCK_PARSER", (Object)true);
    public static final DataKey<Boolean> INDENTED_CODE_NO_TRAILING_BLANK_LINES = new DataKey("INDENTED_CODE_NO_TRAILING_BLANK_LINES", (Object)true);
    public static final DataKey<Boolean> INTELLIJ_DUMMY_IDENTIFIER = new DataKey("INTELLIJ_DUMMY_IDENTIFIER", (Object)false);
    public static final DataKey<Boolean> MATCH_NESTED_LINK_REFS_FIRST = new DataKey("MATCH_NESTED_LINK_REFS_FIRST", (Object)true);
    public static final DataKey<Boolean> PARSE_INNER_HTML_COMMENTS = new DataKey("PARSE_INNER_HTML_COMMENTS", (Object)false);
    public static final DataKey<Boolean> PARSE_MULTI_LINE_IMAGE_URLS = new DataKey("PARSE_MULTI_LINE_IMAGE_URLS", (Object)false);
    public static final DataKey<Boolean> PARSE_JEKYLL_MACROS_IN_URLS = new DataKey("PARSE_JEKYLL_MACROS_IN_URLS", (Object)false);
    public static final DataKey<Boolean> SPACE_IN_LINK_URLS = new DataKey("SPACE_IN_LINK_URLS", (Object)false);
    public static final DataKey<Boolean> SPACE_IN_LINK_ELEMENTS = new DataKey("SPACE_IN_LINK_ELEMENTS", (Object)false);
    public static final DataKey<Boolean> WWW_AUTO_LINK_ELEMENT = new DataKey("WWW_AUTO_LINK_ELEMENT", (Object)false);
    public static final DataKey<Boolean> REFERENCE_PARAGRAPH_PRE_PROCESSOR = new DataKey("REFERENCE_BLOCK_PRE_PROCESSOR", (Object)true);
    public static final DataKey<Boolean> THEMATIC_BREAK_PARSER = new DataKey("THEMATIC_BREAK_PARSER", (Object)true);
    public static final DataKey<Boolean> THEMATIC_BREAK_RELAXED_START = new DataKey("THEMATIC_BREAK_RELAXED_START", (Object)true);
    public static final DataKey<Boolean> UNDERSCORE_DELIMITER_PROCESSOR = new DataKey("UNDERSCORE_DELIMITER_PROCESSOR", (Object)true);
    public static final DataKey<Boolean> BLANK_LINES_IN_AST = new DataKey("BLANK_LINES_IN_AST", (Object)false);
    public static final DataKey<Boolean> STRONG_WRAPS_EMPHASIS = new DataKey("STRONG_WRAPS_EMPHASIS", (Object)false);
    public static final DataKey<Boolean> LINKS_ALLOW_MATCHED_PARENTHESES = new DataKey("LINKS_ALLOW_MATCHED_PARENTHESES", (Object)true);
    public static final DataKey<Boolean> LIST_BLOCK_PARSER = new DataKey("LIST_BLOCK_PARSER", (Object)true);
    public static final DataKey<ParserEmulationProfile> PARSER_EMULATION_PROFILE = new DataKey("PARSER_EMULATION_PROFILE", (Object)ParserEmulationProfile.COMMONMARK);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSER = new DataKey("HTML_BLOCK_DEEP_PARSER", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_NON_BLOCK = new DataKey("HTML_BLOCK_DEEP_PARSE_NON_BLOCK", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_COMMENT_ONLY_FULL_LINE = new DataKey("HTML_BLOCK_COMMENT_ONLY_FULL_LINE", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_START_ONLY_ON_BLOCK_TAGS = new DataKey("HTML_BLOCK_START_ONLY_ON_BLOCK_TAGS", HTML_BLOCK_DEEP_PARSER);
    public static final DataKey<List<String>> HTML_BLOCK_TAGS = new DataKey("HTML_BLOCK_TAGS", (DataValueFactory)new DataValueFactory<List<String>>(){

        public List<String> apply(DataHolder value) {
            return Arrays.asList("address", "article", "aside", "base", "basefont", "blockquote", "body", "caption", "center", "col", "colgroup", "dd", "details", "dialog", "dir", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hr", "html", "iframe", "legend", "li", "link", "main", "math", "menu", "menuitem", "meta", "nav", "noframes", "ol", "optgroup", "option", "p", "param", "section", "source", "summary", "table", "tbody", "td", "tfoot", "th", "thead", "title", "tr", "track", "ul");
        }
    });
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS = new DataKey("HTML_BL OCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_FIRST_OPEN_TAG_ON_ONE_LINE = new DataKey("HTML_BL HTML_BLOCK_DEEP_PARSE_FIRST_OPEN_TAG_ON_ONE_LINE", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_MARKDOWN_INTERRUPTS_CLOSED = new DataKey("HTML_BLOCK_DEEP_PARSE_MARKDOWN_INTERRUPTS_CLOSED", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS_PARTIAL_TAG = new DataKey("HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS_PARTIAL_TAG", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_INDENTED_CODE_INTERRUPTS = new DataKey("HTML_BLOCK_DEEP_PARSE_INDENTED_CODE_INTERRUPTS", (Object)false);
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_TAG_PATTERN = new DataKey("TRANSLATION_HTML_BLOCK_TAG_PATTERN", (Object)"___(?:\\d+)_");
    public static final DataKey<String> TRANSLATION_HTML_INLINE_TAG_PATTERN = new DataKey("TRANSLATION_HTML_INLINE_TAG_PATTERN", (Object)"__(?:\\d+)_");
    public static final DataKey<String> TRANSLATION_AUTOLINK_TAG_PATTERN = new DataKey("TRANSLATION_AUTOLINK_TAG_PATTERN", (Object)"____(?:\\d+)_");
    @Deprecated
    public static final DataKey<ParserEmulationProfile> PARSER_EMULATION_FAMILY = PARSER_EMULATION_PROFILE;
    public static final DataKey<Integer> LISTS_CODE_INDENT = new DataKey("LISTS_CODE_INDENT", (Object)4);
    public static final DataKey<Integer> LISTS_ITEM_INDENT = new DataKey("LISTS_ITEM_INDENT", (Object)4);
    public static final DataKey<Integer> LISTS_NEW_ITEM_CODE_INDENT = new DataKey("LISTS_NEW_ITEM_CODE_INDENT", (Object)4);
    public static final DataKey<Boolean> LISTS_ITEM_MARKER_SPACE = new DataKey("LISTS_ITEM_MARKER_SPACE", (Object)false);
    public static final DataKey<String[]> LISTS_ITEM_MARKER_SUFFIXES = new DataKey("LISTS_ITEM_MARKER_SUFFIXES", (Object)new String[0]);
    public static final DataKey<Boolean> LISTS_NUMBERED_ITEM_MARKER_SUFFIXED = new DataKey("LISTS_NUMBERED_ITEM_MARKER_SUFFIXED", (Object)true);
    public static final DataKey<Boolean> LISTS_AUTO_LOOSE = new DataKey("LISTS_AUTO_LOOSE", (Object)true);
    public static final DataKey<Boolean> LISTS_AUTO_LOOSE_ONE_LEVEL_LISTS = new DataKey("LISTS_AUTO_LOOSE_ONE_LEVEL_LISTS", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_PREV_HAS_TRAILING_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_PREV_HAS_TRAILING_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_LAST_ITEM_PREV_HAS_TRAILING_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_LAST_ITEM_PREV_HAS_TRAILING_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN = new DataKey("LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_BLANK_LINE_FOLLOWS_ITEM_PARAGRAPH = new DataKey("LISTS_LOOSE_WHEN_BLANK_LINE_FOLLOWS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_HAS_LOOSE_SUB_ITEM = new DataKey("LISTS_LOOSE_WHEN_HAS_LOOSE_SUB_ITEM", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_HAS_TRAILING_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_HAS_TRAILING_BLANK_LINE", (Object)true);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_CONTAINS_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_CONTAINS_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> LISTS_DELIMITER_MISMATCH_TO_NEW_LIST = new DataKey("LISTS_DELIMITER_MISMATCH_TO_NEW_LIST", (Object)true);
    public static final DataKey<Boolean> LISTS_END_ON_DOUBLE_BLANK = new DataKey("LISTS_END_ON_DOUBLE_BLANK", (Object)false);
    public static final DataKey<Boolean> LISTS_ITEM_TYPE_MISMATCH_TO_NEW_LIST = new DataKey("LISTS_ITEM_TYPE_MISMATCH_TO_NEW_LIST", (Object)true);
    public static final DataKey<Boolean> LISTS_ITEM_TYPE_MISMATCH_TO_SUB_LIST = new DataKey("LISTS_ITEM_TYPE_MISMATCH_TO_SUB_LIST", (Object)false);
    public static final DataKey<Boolean> LISTS_ORDERED_ITEM_DOT_ONLY = new DataKey("LISTS_ORDERED_ITEM_DOT_ONLY", (Object)false);
    public static final DataKey<Boolean> LISTS_ORDERED_LIST_MANUAL_START = new DataKey("LISTS_ORDERED_LIST_MANUAL_START", (Object)true);
    public static final DataKey<Boolean> LISTS_ITEM_CONTENT_AFTER_SUFFIX = new DataKey("LISTS_ITEM_CONTENT_AFTER_SUFFIX", (Object)false);
    public static final DataKey<Boolean> LISTS_BULLET_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_BULLET_ITEM_INTERRUPTS_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_ORDERED_ITEM_INTERRUPTS_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_BULLET_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_BULLET_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_NON_ONE_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_NON_ONE_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<String> LISTS_ITEM_PREFIX_CHARS = new DataKey("LISTS_ITEM_PREFIX_CHARS", (Object)"*-+");
    public static final DataKey<Integer> CODE_BLOCK_INDENT = new DataKey("CODE_BLOCK_INDENT", LISTS_ITEM_INDENT);
    private final List<CustomBlockParserFactory> blockParserFactories;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private final BitSet delimiterCharacters;
    private final BitSet specialCharacters;
    private final Builder builder;
    private final PostProcessorManager.PostProcessorDependencies postProcessorDependencies;
    private final DocumentParser.ParagraphPreProcessorDependencies paragraphPreProcessorFactories;
    private final DocumentParser.BlockPreProcessorDependencies blockPreProcessorDependencies;
    private final LinkRefProcessorData linkRefProcessors;
    private final List<InlineParserExtensionFactory> inlineParserExtensionFactories;
    private final InlineParserFactory inlineParserFactory;
    private final DataHolder options;

    private Parser(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet((DataHolder)builder);
        this.blockParserFactories = DocumentParser.calculateBlockParserFactories(this.options, builder.blockParserFactories);
        this.inlineParserFactory = builder.inlineParserFactory == null ? DocumentParser.INLINE_PARSER_FACTORY : builder.inlineParserFactory;
        this.paragraphPreProcessorFactories = DocumentParser.calculateParagraphPreProcessors(this.options, builder.paragraphPreProcessorFactories, this.inlineParserFactory);
        this.blockPreProcessorDependencies = DocumentParser.calculateBlockPreProcessors(this.options, builder.blockPreProcessorFactories, this.inlineParserFactory);
        this.delimiterProcessors = InlineParserImpl.calculateDelimiterProcessors(this.options, builder.delimiterProcessors);
        this.delimiterCharacters = InlineParserImpl.calculateDelimiterCharacters(this.options, this.delimiterProcessors.keySet());
        this.linkRefProcessors = InlineParserImpl.calculateLinkRefProcessors(this.options, builder.linkRefProcessors);
        this.specialCharacters = InlineParserImpl.calculateSpecialCharacters(this.options, this.delimiterCharacters);
        this.postProcessorDependencies = PostProcessorManager.calculatePostProcessors(this.options, builder.postProcessorFactories);
        this.inlineParserExtensionFactories = builder.inlineParserExtensionFactories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public Document parse(BasedSequence input) {
        DocumentParser documentParser = new DocumentParser(this.options, this.blockParserFactories, this.paragraphPreProcessorFactories, this.blockPreProcessorDependencies, this.inlineParserFactory.inlineParser(this.options, this.specialCharacters, this.delimiterCharacters, this.delimiterProcessors, this.linkRefProcessors, this.inlineParserExtensionFactories));
        Document document = documentParser.parse((CharSequence)input);
        return this.postProcess(document);
    }

    public Document parse(String input) {
        DocumentParser documentParser = new DocumentParser(this.options, this.blockParserFactories, this.paragraphPreProcessorFactories, this.blockPreProcessorDependencies, this.inlineParserFactory.inlineParser(this.options, this.specialCharacters, this.delimiterCharacters, this.delimiterProcessors, this.linkRefProcessors, this.inlineParserExtensionFactories));
        Document document = documentParser.parse((CharSequence)CharSubSequence.of((CharSequence)input));
        return this.postProcess(document);
    }

    public Document parseReader(Reader input) throws IOException {
        DocumentParser documentParser = new DocumentParser(this.options, this.blockParserFactories, this.paragraphPreProcessorFactories, this.blockPreProcessorDependencies, this.inlineParserFactory.inlineParser(this.options, this.specialCharacters, this.delimiterCharacters, this.delimiterProcessors, this.linkRefProcessors, this.inlineParserExtensionFactories));
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    private Document postProcess(Document document) {
        document = PostProcessorManager.processDocument(document, this.postProcessorDependencies);
        return document;
    }

    public Parser withOptions(DataHolder options) {
        return options == null ? this : new Parser(new Builder(this.builder, options));
    }

    public DataHolder getOptions() {
        return new DataSet((DataHolder)this.builder);
    }

    public boolean transferReferences(Document document, Document included) {
        return this.transferReferences(document, included, null);
    }

    public boolean transferReferences(Document document, Document included, Boolean onlyIfUndefined) {
        boolean transferred = false;
        if (this.options.contains(EXTENSIONS)) {
            for (Extension extension : (Iterable)this.options.get(EXTENSIONS)) {
                ReferenceHoldingExtension parserExtension;
                if (!(extension instanceof ReferenceHoldingExtension) || !(parserExtension = (ReferenceHoldingExtension)extension).transferReferences((MutableDataHolder)document, (DataHolder)included)) continue;
                transferred = true;
            }
        }
        if (document.contains(REFERENCES) && included.contains(REFERENCES) && Parser.transferReferences((NodeRepository)REFERENCES.getFrom((DataHolder)document), (NodeRepository)REFERENCES.getFrom((DataHolder)included), onlyIfUndefined != null ? onlyIfUndefined : REFERENCES_KEEP.getFrom((DataHolder)document) == KeepType.FIRST)) {
            transferred = true;
        }
        if (transferred) {
            document.set(HtmlRenderer.RECHECK_UNDEFINED_REFERENCES, (Object)true);
        }
        return transferred;
    }

    public static <T extends Node> boolean transferReferences(NodeRepository<T> destination, NodeRepository<T> included, boolean onlyIfUndefined) {
        return NodeRepository.transferReferences(destination, included, (boolean)onlyIfUndefined, null);
    }

    public static MutableDataHolder addExtensions(MutableDataHolder options, Extension ... extensions) {
        Iterable extensionIterable = (Iterable)options.get(EXTENSIONS);
        ArrayList<Extension> extensionList = new ArrayList<Extension>();
        extensionList.addAll(Arrays.asList(extensions));
        for (Extension extension : extensionIterable) {
            extensionList.add(extension);
        }
        options.set(EXTENSIONS, extensionList);
        return options;
    }

    public static MutableDataHolder removeExtensions(MutableDataHolder options, Class ... extensions) {
        Iterable extensionIterable = (Iterable)options.get(EXTENSIONS);
        HashSet<Extension> extensionList = new HashSet<Extension>();
        for (Extension extension : extensionIterable) {
            boolean keep = true;
            for (Class clazz : extensions) {
                if (!clazz.isInstance(extension)) continue;
                keep = false;
                break;
            }
            if (!keep) continue;
            extensionList.add(extension);
        }
        options.set(EXTENSIONS, extensionList);
        return options;
    }

    public static interface ReferenceHoldingExtension
    extends Extension {
        public boolean transferReferences(MutableDataHolder var1, DataHolder var2);
    }

    public static interface ParserExtension
    extends Extension {
        public void parserOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        private final List<CustomBlockParserFactory> blockParserFactories = new ArrayList<CustomBlockParserFactory>();
        private final List<DelimiterProcessor> delimiterProcessors = new ArrayList<DelimiterProcessor>();
        private final List<PostProcessorFactory> postProcessorFactories = new ArrayList<PostProcessorFactory>();
        private final List<ParagraphPreProcessorFactory> paragraphPreProcessorFactories = new ArrayList<ParagraphPreProcessorFactory>();
        private final List<BlockPreProcessorFactory> blockPreProcessorFactories = new ArrayList<BlockPreProcessorFactory>();
        private final List<LinkRefProcessorFactory> linkRefProcessors = new ArrayList<LinkRefProcessorFactory>();
        private final List<InlineParserExtensionFactory> inlineParserExtensionFactories = new ArrayList<InlineParserExtensionFactory>();
        private InlineParserFactory inlineParserFactory = null;

        public Builder(DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        public Builder() {
        }

        public Builder(Builder other) {
            super((BuilderBase)other);
            this.blockParserFactories.addAll(other.blockParserFactories);
            this.delimiterProcessors.addAll(other.delimiterProcessors);
            this.postProcessorFactories.addAll(other.postProcessorFactories);
            this.paragraphPreProcessorFactories.addAll(other.paragraphPreProcessorFactories);
            this.blockPreProcessorFactories.addAll(other.blockPreProcessorFactories);
            this.linkRefProcessors.addAll(other.linkRefProcessors);
            this.inlineParserFactory = other.inlineParserFactory;
            this.inlineParserExtensionFactories.addAll(other.inlineParserExtensionFactories);
        }

        public Builder(Builder other, DataHolder options) {
            this(other);
            this.withOptions(options);
        }

        public Parser build() {
            return new Parser(this);
        }

        protected void removeApiPoint(Object apiPoint) {
            if (apiPoint instanceof CustomBlockParserFactory) {
                this.blockParserFactories.remove(apiPoint);
            } else if (apiPoint instanceof DelimiterProcessor) {
                this.delimiterProcessors.remove(apiPoint);
            } else if (apiPoint instanceof PostProcessorFactory) {
                this.postProcessorFactories.remove(apiPoint);
            } else if (apiPoint instanceof ParagraphPreProcessorFactory) {
                this.paragraphPreProcessorFactories.remove(apiPoint);
            } else if (apiPoint instanceof BlockPreProcessorFactory) {
                this.blockPreProcessorFactories.remove(apiPoint);
            } else if (apiPoint instanceof LinkRefProcessorFactory) {
                this.linkRefProcessors.remove(apiPoint);
            } else if (apiPoint instanceof InlineParserExtensionFactory) {
                this.inlineParserExtensionFactories.remove(apiPoint);
            } else if (apiPoint instanceof InlineParserFactory) {
                this.inlineParserFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        protected void preloadExtension(Extension extension) {
            if (extension instanceof ParserExtension) {
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.parserOptions((MutableDataHolder)this);
            }
        }

        protected boolean loadExtension(Extension extension) {
            if (extension instanceof ParserExtension) {
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.extend(this);
                return true;
            }
            return false;
        }

        public Builder customBlockParserFactory(CustomBlockParserFactory blockParserFactory) {
            this.blockParserFactories.add(blockParserFactory);
            this.addExtensionApiPoint(blockParserFactory);
            return this;
        }

        public Builder customInlineParserExtensionFactory(InlineParserExtensionFactory inlineParserExtensionFactory) {
            this.inlineParserExtensionFactories.add(inlineParserExtensionFactory);
            this.addExtensionApiPoint(inlineParserExtensionFactory);
            return this;
        }

        public Builder customInlineParserFactory(InlineParserFactory blockParserFactory) {
            if (this.inlineParserFactory != null) {
                throw new IllegalStateException("custom inline parser factory is already set to " + this.inlineParserFactory.getClass().getName());
            }
            this.inlineParserFactory = blockParserFactory;
            this.addExtensionApiPoint(blockParserFactory);
            return this;
        }

        public Builder customDelimiterProcessor(DelimiterProcessor delimiterProcessor) {
            this.delimiterProcessors.add(delimiterProcessor);
            this.addExtensionApiPoint(delimiterProcessor);
            return this;
        }

        public Builder postProcessorFactory(PostProcessorFactory postProcessorFactory) {
            this.postProcessorFactories.add(postProcessorFactory);
            this.addExtensionApiPoint(postProcessorFactory);
            return this;
        }

        public Builder paragraphPreProcessorFactory(ParagraphPreProcessorFactory paragraphPreProcessorFactory) {
            this.paragraphPreProcessorFactories.add(paragraphPreProcessorFactory);
            this.addExtensionApiPoint(paragraphPreProcessorFactory);
            return this;
        }

        public Builder blockPreProcessorFactory(BlockPreProcessorFactory blockPreProcessorFactory) {
            this.blockPreProcessorFactories.add(blockPreProcessorFactory);
            this.addExtensionApiPoint(blockPreProcessorFactory);
            return this;
        }

        public Builder linkRefProcessorFactory(LinkRefProcessorFactory linkRefProcessor) {
            this.linkRefProcessors.add(linkRefProcessor);
            this.addExtensionApiPoint(linkRefProcessor);
            return this;
        }
    }
}

