/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import com.sun.jdi.ClassType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.DebugManagerHandler;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.spi.debugger.ActionsProvider;

public class TruffleDebugManager
extends DebuggerManagerAdapter {
    private static final Logger LOG = Logger.getLogger(TruffleDebugManager.class.getName());
    private static final String ENGINE_CLASS = "org.graalvm.polyglot.Engine";
    private static final String ENGINE_BUILDER_CLASS = "org.graalvm.polyglot.Engine$Builder";
    private static final String EXISTING_ENGINES_TRIGGER = "com.oracle.truffle.api.frame.Frame";
    private JPDABreakpoint debugManagerLoadBP;
    private static final Map<JPDADebugger, Boolean> haveExistingEnginesTrigger = new WeakHashMap<JPDADebugger, Boolean>();
    private static final Map<JPDADebugger, DebugManagerHandler> dmHandlers = new HashMap<JPDADebugger, DebugManagerHandler>();
    private static final Map<JPDADebugger, JPDABreakpointListener> debugBPListeners = new HashMap<JPDADebugger, JPDABreakpointListener>();

    public Breakpoint[] initBreakpoints() {
        this.initLoadBP();
        return new Breakpoint[]{this.debugManagerLoadBP};
    }

    private synchronized void initLoadBP() {
        if (this.debugManagerLoadBP != null) {
            return;
        }
        this.debugManagerLoadBP = MethodBreakpoint.create((String)ENGINE_BUILDER_CLASS, (String)"build");
        ((MethodBreakpoint)this.debugManagerLoadBP).setBreakpointType(1);
        this.debugManagerLoadBP.setHidden(true);
        LOG.log(Level.FINE, "TruffleDebugManager.initBreakpoints(): submitted BP {0}", this.debugManagerLoadBP);
        TruffleAccess.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionAdded(Session session) {
        JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        Map<JPDADebugger, DebugManagerHandler> map = dmHandlers;
        synchronized (map) {
            if (dmHandlers.containsKey(debugger)) {
                return;
            }
        }
        this.initLoadBP();
        JPDABreakpointListener bpl = this.addPolyglotEngineCreationBP(debugger);
        LOG.log(Level.FINE, "TruffleDebugManager.sessionAdded({0}), adding BP listener to {1}", new Object[]{session, this.debugManagerLoadBP});
        Map<JPDADebugger, JPDABreakpointListener> map2 = debugBPListeners;
        synchronized (map2) {
            debugBPListeners.put(debugger, bpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionRemoved(Session session) {
        DebugManagerHandler dmh;
        JPDABreakpointListener bpl;
        JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        Map<JPDADebugger, JPDABreakpointListener> map = debugBPListeners;
        synchronized (map) {
            bpl = debugBPListeners.remove(debugger);
        }
        if (bpl != null) {
            LOG.log(Level.FINE, "TruffleDebugManager.engineRemoved({0}), removing BP listener from {1}", new Object[]{session, this.debugManagerLoadBP});
            this.debugManagerLoadBP.removeJPDABreakpointListener(bpl);
        }
        Map<JPDADebugger, DebugManagerHandler> map2 = dmHandlers;
        synchronized (map2) {
            dmh = dmHandlers.remove(debugger);
        }
        if (dmh != null) {
            LOG.log(Level.FINE, "TruffleDebugManager.engineRemoved({0}), destroying {1}", new Object[]{session, dmh});
            dmh.destroy();
        }
    }

    private JPDABreakpointListener addPolyglotEngineCreationBP(final JPDADebugger debugger) {
        JPDABreakpointListener bpl = new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent event) {
                try {
                    TruffleDebugManager.this.handleEngineBuilder(debugger, event);
                }
                finally {
                    event.resume();
                }
            }
        };
        this.debugManagerLoadBP.addJPDABreakpointListener(bpl);
        final Runnable submitEngineCreation = () -> {
            List enginePe = debugger.getClassesByName(ENGINE_CLASS);
            if (!enginePe.isEmpty() && debugger.canGetInstanceInfo()) {
                long engineInstances = 0L;
                for (JPDAClassType pe : enginePe) {
                    engineInstances += pe.getInstanceCount();
                }
                if (engineInstances > 0L) {
                    this.submitExistingEnginesProbe(debugger, enginePe);
                }
            }
        };
        if (debugger.getState() > 1) {
            submitEngineCreation.run();
        } else {
            debugger.addPropertyChangeListener("state", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (debugger.getState() > 1) {
                        submitEngineCreation.run();
                        debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
                    }
                }
            });
        }
        return bpl;
    }

    private void handleEngineBuilder(JPDADebugger debugger, JPDABreakpointEvent entryEvent) {
        MethodBreakpoint builderExitBreakpoint = MethodBreakpoint.create((String)ENGINE_BUILDER_CLASS, (String)"build");
        builderExitBreakpoint.setBreakpointType(2);
        builderExitBreakpoint.setThreadFilters(debugger, new JPDAThread[]{entryEvent.getThread()});
        builderExitBreakpoint.setSuspend(1);
        builderExitBreakpoint.setHidden(true);
        builderExitBreakpoint.addJPDABreakpointListener(exitEvent -> {
            try {
                builderExitBreakpoint.disable();
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)builderExitBreakpoint);
                this.haveNewPE(debugger, (JPDAThreadImpl)exitEvent.getThread(), (ObjectReference)((JDIVariable)exitEvent.getVariable()).getJDIValue());
            }
            finally {
                exitEvent.resume();
            }
        });
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)builderExitBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitExistingEnginesProbe(JPDADebugger debugger, List<JPDAClassType> enginePe) {
        Map<JPDADebugger, Boolean> map = haveExistingEnginesTrigger;
        synchronized (map) {
            if (Boolean.TRUE.equals(haveExistingEnginesTrigger.get(debugger))) {
                return;
            }
            haveExistingEnginesTrigger.put(debugger, Boolean.TRUE);
        }
        MethodBreakpoint execTrigger = MethodBreakpoint.create((String)EXISTING_ENGINES_TRIGGER, (String)"*");
        execTrigger.setHidden(true);
        execTrigger.setSession(debugger);
        execTrigger.addJPDABreakpointListener(event -> {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)execTrigger);
            try {
                JPDAThreadImpl thread = (JPDAThreadImpl)event.getThread();
                boolean haveSomeEngine = false;
                for (JPDAClassType pe : enginePe) {
                    List instances = pe.getInstances(0L);
                    for (ObjectVariable obj : instances) {
                        Value value = ((JDIVariable)obj).getJDIValue();
                        if (!(value instanceof ObjectReference)) continue;
                        this.haveNewPE(debugger, thread, (ObjectReference)value);
                        haveSomeEngine = true;
                    }
                }
                if (haveSomeEngine) {
                    for (ActionsProvider ap : ((JPDADebuggerImpl)debugger).getSession().lookup(null, ActionsProvider.class)) {
                        if (!ap.getActions().contains("pauseInGraalScript")) continue;
                        ap.isEnabled((Object)"pauseInGraalScript");
                    }
                }
            }
            finally {
                event.resume();
            }
        });
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)execTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void haveNewPE(JPDADebugger debugger, JPDAThreadImpl thread, ObjectReference engine) {
        DebugManagerHandler dmh;
        Map<JPDADebugger, DebugManagerHandler> map = dmHandlers;
        synchronized (map) {
            dmh = dmHandlers.get(debugger);
            if (dmh == null) {
                dmh = new DebugManagerHandler(debugger);
                dmHandlers.put(debugger, dmh);
            }
        }
        dmh.newPolyglotEngineInstance(engine, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof JSLineBreakpoint) {
            ArrayList<DebugManagerHandler> handlers;
            Map<JPDADebugger, DebugManagerHandler> map = dmHandlers;
            synchronized (map) {
                handlers = new ArrayList<DebugManagerHandler>(dmHandlers.values());
            }
            for (DebugManagerHandler dmh : handlers) {
                dmh.breakpointAdded((JSLineBreakpoint)breakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof JSLineBreakpoint) {
            ArrayList<DebugManagerHandler> handlers;
            Map<JPDADebugger, DebugManagerHandler> map = dmHandlers;
            synchronized (map) {
                handlers = new ArrayList<DebugManagerHandler>(dmHandlers.values());
            }
            for (DebugManagerHandler dmh : handlers) {
                dmh.breakpointRemoved((JSLineBreakpoint)breakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassType getDebugAccessorClass(JPDADebugger debugger) {
        Map<JPDADebugger, DebugManagerHandler> map = dmHandlers;
        synchronized (map) {
            DebugManagerHandler dmh = dmHandlers.get(debugger);
            if (dmh != null) {
                return dmh.getAccessorClass();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPDAClassType getDebugAccessorJPDAClass(JPDADebugger debugger) {
        Map<JPDADebugger, DebugManagerHandler> map = dmHandlers;
        synchronized (map) {
            DebugManagerHandler dmh = dmHandlers.get(debugger);
            if (dmh != null) {
                return dmh.getAccessorJPDAClass();
            }
            return null;
        }
    }
}

