/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ComputeTestMethodsImpl
extends EditorAwareJavaSourceTaskFactory {
    public ComputeTestMethodsImpl() {
        super(JavaSource.Phase.ELEMENTS_RESOLVED, JavaSource.Priority.NORMAL, TaskIndexingMode.ALLOWED_DURING_SCAN, new String[0]);
    }

    protected CancellableTask<CompilationInfo> createTask(FileObject file) {
        return new TaskImpl();
    }

    private static class TaskImpl
    implements CancellableTask<CompilationInfo> {
        private final AtomicReference<ComputeTestMethods> currentProvider = new AtomicReference();
        private final AtomicBoolean cancel = new AtomicBoolean();

        private TaskImpl() {
        }

        public void cancel() {
            this.cancel.set(true);
            ComputeTestMethods provider = this.currentProvider.get();
            if (provider != null) {
                provider.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(CompilationInfo info) throws Exception {
            this.cancel.set(false);
            Document doc = info.getDocument();
            if (doc == null) {
                return;
            }
            ArrayList<TestMethodController.TestMethod> methods = new ArrayList<TestMethodController.TestMethod>();
            for (ComputeTestMethods.Factory factory : Lookup.getDefault().lookupAll(ComputeTestMethods.Factory.class)) {
                try {
                    ComputeTestMethods ctm = factory.create();
                    this.currentProvider.set(ctm);
                    if (this.cancel.get()) {
                        return;
                    }
                    List<TestMethodController.TestMethod> currentMethods = ctm.computeTestMethods(info);
                    if (currentMethods != null) {
                        methods.addAll(currentMethods);
                    }
                }
                finally {
                    this.currentProvider.set(null);
                }
                if (this.cancel.get()) continue;
                TestMethodController.setTestMethods((Document)doc, methods);
            }
        }
    }
}

