/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNode;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=RegExpPrototypeBuiltins.class)
public final class RegExpPrototypeBuiltinsFactory {

    @GeneratedBy(value=RegExpPrototypeBuiltins.CompiledRegexPatternAccessor.class)
    static final class CompiledRegexPatternAccessorNodeGen
    extends RegExpPrototypeBuiltins.CompiledRegexPatternAccessor
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CompiledRegexPatternAccessorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        private boolean fallbackGuard_(Object arguments0Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isJSRegExpNode.executeBoolean(arguments0Value_)) {
                    return false;
                }
                arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isRegExpPrototype(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && this.isJSRegExpNode.executeBoolean(arguments0Value__)) {
                    return this.doDynamicObject(arguments0Value__);
                }
                if ((state & 2) != 0 && this.isRegExpPrototype(arguments0Value__)) {
                    return this.doPrototype(arguments0Value__);
                }
            }
            if ((state & 4) != 0 && this.fallbackGuard_(arguments0Value_)) {
                return this.doObject(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isJSRegExpNode.executeBoolean(arguments0Value_)) {
                    this.state_ = state |= 1;
                    return this.doDynamicObject(arguments0Value_);
                }
                if (this.isRegExpPrototype(arguments0Value_)) {
                    this.state_ = state |= 2;
                    return this.doPrototype(arguments0Value_);
                }
            }
            this.state_ = state |= 4;
            return this.doObject(arguments0Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doDynamicObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doPrototype";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "doObject";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.CompiledRegexPatternAccessor create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CompiledRegexPatternAccessorNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.CompiledRegexFlagPropertyAccessor.class)
    static final class CompiledRegexFlagPropertyAccessorNodeGen
    extends RegExpPrototypeBuiltins.CompiledRegexFlagPropertyAccessor
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CompiledRegexFlagPropertyAccessorNodeGen(JSContext context, JSBuiltin builtin, String flagName, JavaScriptNode[] arguments) {
            super(context, builtin, flagName);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        private boolean fallbackGuard_(Object arguments0Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isJSRegExpNode.executeBoolean(arguments0Value_)) {
                    return false;
                }
                arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isRegExpPrototype(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && this.isJSRegExpNode.executeBoolean(arguments0Value__)) {
                    return this.doDynamicObject(arguments0Value__);
                }
                if ((state & 2) != 0 && this.isRegExpPrototype(arguments0Value__)) {
                    return this.doPrototype(arguments0Value__);
                }
            }
            if ((state & 4) != 0 && this.fallbackGuard_(arguments0Value_)) {
                return this.doObject(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isJSRegExpNode.executeBoolean(arguments0Value_)) {
                    this.state_ = state |= 1;
                    return this.doDynamicObject(arguments0Value_);
                }
                if (this.isRegExpPrototype(arguments0Value_)) {
                    this.state_ = state |= 2;
                    return this.doPrototype(arguments0Value_);
                }
            }
            this.state_ = state |= 4;
            return this.doObject(arguments0Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doDynamicObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doPrototype";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "doObject";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.CompiledRegexFlagPropertyAccessor create(JSContext context, JSBuiltin builtin, String flagName, JavaScriptNode[] arguments) {
            return new CompiledRegexFlagPropertyAccessorNodeGen(context, builtin, flagName, arguments);
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.RegExpFlagsGetterNode.class)
    public static final class RegExpFlagsGetterNodeGen
    extends RegExpPrototypeBuiltins.RegExpFlagsGetterNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private IsJSObjectNode object_isObjectNode_;

        private RegExpFlagsGetterNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        private boolean fallbackGuard_(int state, Object arguments0Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if ((state & 2) == 0 || this.object_isObjectNode_.executeBoolean(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && this.object_isObjectNode_.executeBoolean(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doObject(arguments0Value__, this.object_isObjectNode_);
            }
            if ((state & 4) != 0 && this.fallbackGuard_(state, arguments0Value_)) {
                return this.doNotObject(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    boolean Object_duplicateFound_ = false;
                    if ((state & 1) != 0 && this.object_isObjectNode_.executeBoolean(arguments0Value_)) {
                        Object_duplicateFound_ = true;
                    }
                    if (!Object_duplicateFound_) {
                        if ((state & 2) == 0) {
                            this.object_isObjectNode_ = (IsJSObjectNode)super.insert((Node)IsJSObjectNode.create());
                            this.state_ = state |= 2;
                        }
                        if (this.object_isObjectNode_.executeBoolean(arguments0Value_) && (state & 1) == 0) {
                            this.object_isObjectNode_ = (IsJSObjectNode)super.insert((Node)IsJSObjectNode.create());
                            this.state_ = state |= 1;
                            Object_duplicateFound_ = true;
                        }
                    }
                    if (Object_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        String string = this.doObject(arguments0Value_, this.object_isObjectNode_);
                        return string;
                    }
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.doNotObject(arguments0Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 5) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 5 & (state & 5) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doObject";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<IsJSObjectNode>> cached = new ArrayList<List<IsJSObjectNode>>();
                cached.add(Arrays.asList(this.object_isObjectNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doNotObject";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.RegExpFlagsGetterNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new RegExpFlagsGetterNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpMatchAllNode.class)
    public static final class JSRegExpMatchAllNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpMatchAllNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private MatchAllData matchAll_cache;

        private JSRegExpMatchAllNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        private boolean fallbackGuard_(int state, Object arguments0Value, Object arguments1Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if ((state & 2) == 0 || this.matchAll_cache.isObjectNode_.executeBoolean(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 5) != 0) {
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    MatchAllData s1_ = this.matchAll_cache;
                    if (s1_ != null && s1_.isObjectNode_.executeBoolean(arguments0Value__)) {
                        return this.matchAll(frameValue, arguments0Value__, arguments1Value_, s1_.toStringNodeForInput_, s1_.speciesConstructNode_, s1_.getFlagsNode_, s1_.toStringNodeForFlags_, s1_.getLastIndexNode_, s1_.toLengthNode_, s1_.setLastIndexNode_, s1_.createRegExpStringIteratorNode_, s1_.isObjectNode_, s1_.indexInIntRangeProf_);
                    }
                }
                if ((state & 4) != 0 && this.fallbackGuard_(state, arguments0Value_, arguments1Value_)) {
                    return this.matchAll(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    MatchAllData s1_ = this.matchAll_cache;
                    boolean MatchAll_duplicateFound_ = false;
                    if ((state & 1) != 0 && s1_.isObjectNode_.executeBoolean(arguments0Value_)) {
                        MatchAll_duplicateFound_ = true;
                    }
                    if (!MatchAll_duplicateFound_) {
                        if ((state & 2) == 0) {
                            this.matchAll_cache = s1_ = (MatchAllData)super.insert((Node)new MatchAllData());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            this.state_ = state |= 2;
                        }
                        if (s1_.isObjectNode_.executeBoolean(arguments0Value_) && (state & 1) == 0) {
                            s1_ = (MatchAllData)super.insert((Node)new MatchAllData());
                            s1_.toStringNodeForInput_ = s1_.insertAccessor(JSToStringNode.create());
                            s1_.speciesConstructNode_ = s1_.insertAccessor(this.createSpeciesConstructNode());
                            s1_.getFlagsNode_ = s1_.insertAccessor(PropertyGetNode.create("flags", this.getContext()));
                            s1_.toStringNodeForFlags_ = s1_.insertAccessor(JSToStringNode.create());
                            s1_.getLastIndexNode_ = s1_.insertAccessor(PropertyGetNode.create("lastIndex", this.getContext()));
                            s1_.toLengthNode_ = s1_.insertAccessor(JSToLengthNode.create());
                            s1_.setLastIndexNode_ = s1_.insertAccessor(PropertySetNode.create("lastIndex", false, this.getContext(), true));
                            s1_.createRegExpStringIteratorNode_ = s1_.insertAccessor(this.createCreateRegExpStringIteratorNode());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            s1_.indexInIntRangeProf_ = ConditionProfile.createBinaryProfile();
                            this.matchAll_cache = s1_;
                            this.state_ = state |= 1;
                            MatchAll_duplicateFound_ = true;
                        }
                    }
                    if (MatchAll_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.matchAll(frameValue, arguments0Value_, arguments1Value, s1_.toStringNodeForInput_, s1_.speciesConstructNode_, s1_.getFlagsNode_, s1_.toStringNodeForFlags_, s1_.getLastIndexNode_, s1_.toLengthNode_, s1_.setLastIndexNode_, s1_.createRegExpStringIteratorNode_, s1_.isObjectNode_, s1_.indexInIntRangeProf_);
                        return object;
                    }
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.matchAll(arguments0Value, arguments1Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 5) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 5 & (state & 5) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "matchAll";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                MatchAllData s1_ = this.matchAll_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.toStringNodeForInput_, s1_.speciesConstructNode_, s1_.getFlagsNode_, s1_.toStringNodeForFlags_, s1_.getLastIndexNode_, s1_.toLengthNode_, s1_.setLastIndexNode_, s1_.createRegExpStringIteratorNode_, s1_.isObjectNode_, s1_.indexInIntRangeProf_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "matchAll";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpMatchAllNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpMatchAllNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpMatchAllNode.class)
        private static final class MatchAllData
        extends Node {
            @Node.Child
            JSToStringNode toStringNodeForInput_;
            @Node.Child
            ArrayPrototypeBuiltins.ArraySpeciesConstructorNode speciesConstructNode_;
            @Node.Child
            PropertyGetNode getFlagsNode_;
            @Node.Child
            JSToStringNode toStringNodeForFlags_;
            @Node.Child
            PropertyGetNode getLastIndexNode_;
            @Node.Child
            JSToLengthNode toLengthNode_;
            @Node.Child
            PropertySetNode setLastIndexNode_;
            @Node.Child
            StringPrototypeBuiltins.CreateRegExpStringIteratorNode createRegExpStringIteratorNode_;
            @Node.Child
            IsJSObjectNode isObjectNode_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile indexInIntRangeProf_;

            MatchAllData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpSearchNode.class)
    public static final class JSRegExpSearchNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpSearchNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private IsJSObjectNode search_isObjectNode_;
        @Node.Child
        private JSToStringNode search_toString1Node_;

        private JSRegExpSearchNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        private boolean fallbackGuard_(int state, Object arguments0Value, Object arguments1Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if ((state & 2) == 0 || this.search_isObjectNode_.executeBoolean(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 5) != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && this.search_isObjectNode_.executeBoolean(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.search(arguments0Value__, arguments1Value_, this.search_isObjectNode_, this.search_toString1Node_);
                }
                if ((state & 4) != 0 && this.fallbackGuard_(state, arguments0Value_, arguments1Value_)) {
                    return this.search(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    boolean Search_duplicateFound_ = false;
                    if ((state & 1) != 0 && this.search_isObjectNode_.executeBoolean(arguments0Value_)) {
                        Search_duplicateFound_ = true;
                    }
                    if (!Search_duplicateFound_) {
                        if ((state & 2) == 0) {
                            this.search_isObjectNode_ = (IsJSObjectNode)super.insert((Node)IsJSObjectNode.create());
                            this.state_ = state |= 2;
                        }
                        if (this.search_isObjectNode_.executeBoolean(arguments0Value_) && (state & 1) == 0) {
                            this.search_isObjectNode_ = (IsJSObjectNode)super.insert((Node)IsJSObjectNode.create());
                            this.search_toString1Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                            this.state_ = state |= 1;
                            Search_duplicateFound_ = true;
                        }
                    }
                    if (Search_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.search(arguments0Value_, arguments1Value, this.search_isObjectNode_, this.search_toString1Node_);
                        return object;
                    }
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.search(arguments0Value, arguments1Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 5) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 5 & (state & 5) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "search";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.search_isObjectNode_, this.search_toString1Node_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "search";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpSearchNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpSearchNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpMatchNode.class)
    public static final class JSRegExpMatchNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpMatchNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private MatchData match_cache;

        private JSRegExpMatchNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        private boolean fallbackGuard_(int state, Object arguments0Value, Object arguments1Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if ((state & 2) == 0 || this.match_cache.isObjectNode_.executeBoolean(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 5) != 0) {
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    MatchData s1_ = this.match_cache;
                    if (s1_ != null && s1_.isObjectNode_.executeBoolean(arguments0Value__)) {
                        return this.match(arguments0Value__, arguments1Value_, s1_.isObjectNode_, s1_.toString1Node_, s1_.toString2Node_);
                    }
                }
                if ((state & 4) != 0 && this.fallbackGuard_(state, arguments0Value_, arguments1Value_)) {
                    return this.match(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    MatchData s1_ = this.match_cache;
                    boolean Match_duplicateFound_ = false;
                    if ((state & 1) != 0 && s1_.isObjectNode_.executeBoolean(arguments0Value_)) {
                        Match_duplicateFound_ = true;
                    }
                    if (!Match_duplicateFound_) {
                        if ((state & 2) == 0) {
                            this.match_cache = s1_ = (MatchData)super.insert((Node)new MatchData());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            this.state_ = state |= 2;
                        }
                        if (s1_.isObjectNode_.executeBoolean(arguments0Value_) && (state & 1) == 0) {
                            s1_ = (MatchData)super.insert((Node)new MatchData());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            s1_.toString1Node_ = s1_.insertAccessor(JSToStringNode.create());
                            s1_.toString2Node_ = s1_.insertAccessor(JSToStringNode.create());
                            this.match_cache = s1_;
                            this.state_ = state |= 1;
                            Match_duplicateFound_ = true;
                        }
                    }
                    if (Match_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.match(arguments0Value_, arguments1Value, s1_.isObjectNode_, s1_.toString1Node_, s1_.toString2Node_);
                        return object;
                    }
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.match(arguments0Value, arguments1Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 5) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 5 & (state & 5) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "match";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                MatchData s1_ = this.match_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new JavaScriptBaseNode[]{s1_.isObjectNode_, s1_.toString1Node_, s1_.toString2Node_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "match";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpMatchNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpMatchNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpMatchNode.class)
        private static final class MatchData
        extends Node {
            @Node.Child
            IsJSObjectNode isObjectNode_;
            @Node.Child
            JSToStringNode toString1Node_;
            @Node.Child
            JSToStringNode toString2Node_;

            MatchData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpReplaceNode.class)
    public static final class JSRegExpReplaceNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpReplaceNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private ReplaceCachedData replaceCached_cache;
        @Node.Child
        private JSToStringNode replaceDynamic_toString1Node_;

        private JSRegExpReplaceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 7) != 0) {
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments2Value_)) {
                        String arguments2Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments2Value_);
                        ReplaceCachedData s1_ = this.replaceCached_cache;
                        while (s1_ != null) {
                            if (s1_.cachedReplaceValue_.equals(arguments2Value__)) {
                                return this.replaceCached(arguments0Value__, arguments1Value_, arguments2Value__, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValueWithNamedCG_, s1_.cachedParsedReplaceValueWithoutNamedCG_, s1_.toString1Node_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        return this.replaceDynamic(arguments0Value__, arguments1Value_, arguments2Value_, this.replaceDynamic_toString1Node_);
                    }
                }
                if ((state & 4) != 0 && JSRegExpReplaceNodeGen.fallbackGuard_(state, arguments0Value_, arguments1Value_, arguments2Value_)) {
                    return this.doNoObject(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    int stringCast2;
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (exclude == 0 && (stringCast2 = JSTypesGen.specializeImplicitString(arguments2Value)) != 0) {
                        String arguments2Value_ = JSTypesGen.asImplicitString(stringCast2, arguments2Value);
                        int count1_ = 0;
                        ReplaceCachedData s1_ = this.replaceCached_cache;
                        if ((state & 1) != 0) {
                            while (s1_ != null && !s1_.cachedReplaceValue_.equals(arguments2Value_)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null) {
                            if (count1_ < 3) {
                                s1_ = (ReplaceCachedData)super.insert((Node)new ReplaceCachedData(this.replaceCached_cache));
                                s1_.cachedReplaceValue_ = arguments2Value_;
                                s1_.cachedParsedReplaceValueWithNamedCG_ = RegExpPrototypeBuiltins.JSRegExpReplaceNode.parseReplaceValueWithNCG(arguments2Value_);
                                s1_.cachedParsedReplaceValueWithoutNamedCG_ = RegExpPrototypeBuiltins.JSRegExpReplaceNode.parseReplaceValueWithoutNCG(arguments2Value_);
                                s1_.toString1Node_ = s1_.insertAccessor(JSToStringNode.create());
                                this.replaceCached_cache = s1_;
                                state |= stringCast2 << 3;
                                this.state_ = state |= 1;
                            }
                        } else {
                            state |= stringCast2 << 3;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            String string = this.replaceCached(arguments0Value_, arguments1Value, arguments2Value_, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValueWithNamedCG_, s1_.cachedParsedReplaceValueWithoutNamedCG_, s1_.toString1Node_);
                            return string;
                        }
                    }
                    this.replaceDynamic_toString1Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                    this.exclude_ = exclude |= 1;
                    this.replaceCached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    String string = this.replaceDynamic(arguments0Value_, arguments1Value, arguments2Value, this.replaceDynamic_toString1Node_);
                    return string;
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.doNoObject(arguments0Value, arguments1Value, arguments2Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ReplaceCachedData s1_;
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0 && ((s1_ = this.replaceCached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "replaceCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                ReplaceCachedData s1_ = this.replaceCached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(new Object[]{s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValueWithNamedCG_, s1_.cachedParsedReplaceValueWithoutNamedCG_, s1_.toString1Node_}));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "replaceDynamic";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.replaceDynamic_toString1Node_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doNoObject";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        private static boolean fallbackGuard_(int state, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            return (state & 2) != 0 || !JSTypes.isDynamicObject(arguments0Value);
        }

        public static RegExpPrototypeBuiltins.JSRegExpReplaceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpReplaceNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpReplaceNode.class)
        private static final class ReplaceCachedData
        extends Node {
            @Node.Child
            ReplaceCachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedReplaceValue_;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            ReplaceStringParser.Token[] cachedParsedReplaceValueWithNamedCG_;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            ReplaceStringParser.Token[] cachedParsedReplaceValueWithoutNamedCG_;
            @Node.Child
            JSToStringNode toString1Node_;

            ReplaceCachedData(ReplaceCachedData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpSplitNode.class)
    public static final class JSRegExpSplitNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpSplitNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSRegExpSplitNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1E) == 0 && state != 0) {
                return this.execute_int0(frameValue, state);
            }
            if ((state & 0x1D) == 0 && state != 0) {
                return this.execute_long1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.splitIntLimit(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_long1(VirtualFrame frameValue, int state) {
            long arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state & 2) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.splitLongLimit(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                if ((state & 0xF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    if ((state & 1) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.splitIntLimit(arguments0Value__, arguments1Value_, arguments2Value__);
                    }
                    if ((state & 2) != 0 && arguments2Value_ instanceof Long) {
                        long arguments2Value__ = (Long)arguments2Value_;
                        return this.splitLongLimit(arguments0Value__, arguments1Value_, arguments2Value__);
                    }
                    if ((state & 0xC) != 0) {
                        if ((state & 4) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                            return this.splitUndefinedLimit(arguments0Value__, arguments1Value_, arguments2Value_);
                        }
                        if ((state & 8) != 0 && !JSGuards.isUndefined(arguments2Value_)) {
                            return this.splitObjectLimit(arguments0Value__, arguments1Value_, arguments2Value_);
                        }
                    }
                }
                if ((state & 0x10) != 0 && JSRegExpSplitNodeGen.fallbackGuard_(state, arguments0Value_, arguments1Value_, arguments2Value_)) {
                    return this.doNoObject(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (arguments2Value instanceof Integer) {
                    int arguments2Value_ = (Integer)arguments2Value;
                    this.state_ = state |= 1;
                    return this.splitIntLimit(arguments0Value_, arguments1Value, arguments2Value_);
                }
                if (arguments2Value instanceof Long) {
                    long arguments2Value_ = (Long)arguments2Value;
                    this.state_ = state |= 2;
                    return this.splitLongLimit(arguments0Value_, arguments1Value, arguments2Value_);
                }
                if (JSGuards.isUndefined(arguments2Value)) {
                    this.state_ = state |= 4;
                    return this.splitUndefinedLimit(arguments0Value_, arguments1Value, arguments2Value);
                }
                if (!JSGuards.isUndefined(arguments2Value)) {
                    this.state_ = state |= 8;
                    return this.splitObjectLimit(arguments0Value_, arguments1Value, arguments2Value);
                }
            }
            this.state_ = state |= 0x10;
            return this.doNoObject(arguments0Value, arguments1Value, arguments2Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "splitIntLimit";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "splitLongLimit";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "splitUndefinedLimit";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "splitObjectLimit";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doNoObject";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            return Introspection.Provider.create((Object[])data);
        }

        private static boolean fallbackGuard_(int state, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                if ((state & 1) == 0 && arguments2Value instanceof Integer) {
                    return false;
                }
                if ((state & 2) == 0 && arguments2Value instanceof Long) {
                    return false;
                }
                if ((state & 4) == 0 && JSGuards.isUndefined(arguments2Value)) {
                    return false;
                }
                if ((state & 8) == 0 && !JSGuards.isUndefined(arguments2Value)) {
                    return false;
                }
            }
            return true;
        }

        public static RegExpPrototypeBuiltins.JSRegExpSplitNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpSplitNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpToStringNode.class)
    public static final class JSRegExpToStringNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpToStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ToStringData toString_cache;

        private JSRegExpToStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        private boolean fallbackGuard_(int state, Object arguments0Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if ((state & 2) == 0 || this.toString_cache.isObjectNode_.executeBoolean(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                ToStringData s1_ = this.toString_cache;
                if (s1_ != null && s1_.isObjectNode_.executeBoolean(arguments0Value__)) {
                    return this.toString(arguments0Value__, s1_.isObjectNode_, s1_.toString1Node_, s1_.toString2Node_);
                }
            }
            if ((state & 4) != 0 && this.fallbackGuard_(state, arguments0Value_)) {
                return this.toString(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    ToStringData s1_ = this.toString_cache;
                    boolean ToString_duplicateFound_ = false;
                    if ((state & 1) != 0 && s1_.isObjectNode_.executeBoolean(arguments0Value_)) {
                        ToString_duplicateFound_ = true;
                    }
                    if (!ToString_duplicateFound_) {
                        if ((state & 2) == 0) {
                            this.toString_cache = s1_ = (ToStringData)super.insert((Node)new ToStringData());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            this.state_ = state |= 2;
                        }
                        if (s1_.isObjectNode_.executeBoolean(arguments0Value_) && (state & 1) == 0) {
                            s1_ = (ToStringData)super.insert((Node)new ToStringData());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            s1_.toString1Node_ = s1_.insertAccessor(JSToStringNode.create());
                            s1_.toString2Node_ = s1_.insertAccessor(JSToStringNode.create());
                            this.toString_cache = s1_;
                            this.state_ = state |= 1;
                            ToString_duplicateFound_ = true;
                        }
                    }
                    if (ToString_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        String string = this.toString(arguments0Value_, s1_.isObjectNode_, s1_.toString1Node_, s1_.toString2Node_);
                        return string;
                    }
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.toString(arguments0Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 5) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 5 & (state & 5) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "toString";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                ToStringData s1_ = this.toString_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new JavaScriptBaseNode[]{s1_.isObjectNode_, s1_.toString1Node_, s1_.toString2Node_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "toString";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpToStringNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpToStringNode.class)
        private static final class ToStringData
        extends Node {
            @Node.Child
            IsJSObjectNode isObjectNode_;
            @Node.Child
            JSToStringNode toString1Node_;
            @Node.Child
            JSToStringNode toString2Node_;

            ToStringData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpTestNode.class)
    public static final class JSRegExpTestNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpTestNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private TestData test_cache;

        private JSRegExpTestNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        private boolean fallbackGuard_(int state, Object arguments0Value, Object arguments1Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if ((state & 2) == 0 || this.test_cache.isObjectNode_.executeBoolean(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 5) != 0) {
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    TestData s1_ = this.test_cache;
                    if (s1_ != null && s1_.isObjectNode_.executeBoolean(arguments0Value__)) {
                        return this.test(arguments0Value__, arguments1Value_, s1_.isObjectNode_, s1_.toStringNode_, s1_.regExpNode_);
                    }
                }
                if ((state & 4) != 0 && this.fallbackGuard_(state, arguments0Value_, arguments1Value_)) {
                    return this.test(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    TestData s1_ = this.test_cache;
                    boolean Test_duplicateFound_ = false;
                    if ((state & 1) != 0 && s1_.isObjectNode_.executeBoolean(arguments0Value_)) {
                        Test_duplicateFound_ = true;
                    }
                    if (!Test_duplicateFound_) {
                        if ((state & 2) == 0) {
                            this.test_cache = s1_ = (TestData)super.insert((Node)new TestData());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            this.state_ = state |= 2;
                        }
                        if (s1_.isObjectNode_.executeBoolean(arguments0Value_) && (state & 1) == 0) {
                            s1_ = (TestData)super.insert((Node)new TestData());
                            s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                            s1_.toStringNode_ = s1_.insertAccessor(JSToStringNode.create());
                            s1_.regExpNode_ = s1_.insertAccessor(JSRegExpExecIntlNode.create(this.getContext()));
                            this.test_cache = s1_;
                            this.state_ = state |= 1;
                            Test_duplicateFound_ = true;
                        }
                    }
                    if (Test_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.test(arguments0Value_, arguments1Value, s1_.isObjectNode_, s1_.toStringNode_, s1_.regExpNode_);
                        return object;
                    }
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.test(arguments0Value, arguments1Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 5) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 5 & (state & 5) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "test";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                TestData s1_ = this.test_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new JavaScriptBaseNode[]{s1_.isObjectNode_, s1_.toStringNode_, s1_.regExpNode_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "test";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpTestNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpTestNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpTestNode.class)
        private static final class TestData
        extends Node {
            @Node.Child
            IsJSObjectNode isObjectNode_;
            @Node.Child
            JSToStringNode toStringNode_;
            @Node.Child
            JSRegExpExecIntlNode regExpNode_;

            TestData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpExecES5Node.class)
    public static final class JSRegExpExecES5NodeGen
    extends RegExpPrototypeBuiltins.JSRegExpExecES5Node
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSRegExpExecES5NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSRegExp(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.exec(arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && !JSGuards.isJSRegExp(arguments0Value_)) {
                    return this.exec(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSRegExp(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.exec(arguments0Value_, arguments1Value);
            }
            if (!JSGuards.isJSRegExp(arguments0Value)) {
                this.state_ = state |= 2;
                return this.exec(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "exec";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "exec";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpExecES5Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpExecES5NodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpExecNode.class)
    public static final class JSRegExpExecNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpExecNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToStringNode object_toStringNode_;

        private JSRegExpExecNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        private boolean fallbackGuard_(Object arguments0Value, Object arguments1Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_;
                if (JSTypesGen.isImplicitString(arguments1Value) && this.isRegExp(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    return false;
                }
                arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isRegExp(arguments0Value_)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments1Value_);
                    if (this.isRegExp(arguments0Value__)) {
                        return this.doString(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 2) != 0 && this.isRegExp(arguments0Value__)) {
                    return this.doObject(arguments0Value__, arguments1Value_, this.object_toStringNode_);
                }
            }
            if ((state & 4) != 0 && this.fallbackGuard_(arguments0Value_, arguments1Value_)) {
                return this.doNoRegExp(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (this.isRegExp(arguments0Value_)) {
                            state |= stringCast1 << 3;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.doString(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                    }
                    if (this.isRegExp(arguments0Value_)) {
                        this.object_toStringNode_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doObject(arguments0Value_, arguments1Value, this.object_toStringNode_);
                        return dynamicObject;
                    }
                }
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.doNoRegExp(arguments0Value, arguments1Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doString";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doObject";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.object_toStringNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doNoRegExp";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpExecNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpExecNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpCompileNode.class)
    public static final class JSRegExpCompileNodeGen
    extends RegExpPrototypeBuiltins.JSRegExpCompileNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private Compile0Data compile0_cache;

        private JSRegExpCompileNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    Compile0Data s1_ = this.compile0_cache;
                    if (s1_ != null && JSGuards.isJSRegExp(arguments0Value__)) {
                        return this.compile(arguments0Value__, arguments1Value_, arguments2Value_, s1_.compileRegexNode_, s1_.toStringNode_, s1_.isRegExpProfile_, s1_.compiledRegexAccessor_, s1_.flagsAccessor_);
                    }
                }
                if ((state & 2) != 0 && !JSGuards.isJSRegExp(arguments0Value_)) {
                    return this.compile(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSRegExp(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    Compile0Data s1_ = (Compile0Data)super.insert((Node)new Compile0Data());
                    s1_.compileRegexNode_ = s1_.insertAccessor(CompileRegexNode.create(this.getContext()));
                    s1_.toStringNode_ = s1_.insertAccessor(JSToStringNode.createUndefinedToEmpty());
                    s1_.isRegExpProfile_ = ConditionProfile.createBinaryProfile();
                    s1_.compiledRegexAccessor_ = s1_.insertAccessor(TRegexUtil.TRegexCompiledRegexAccessor.create());
                    s1_.flagsAccessor_ = s1_.insertAccessor(TRegexUtil.TRegexFlagsAccessor.create());
                    this.compile0_cache = s1_;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.compile(arguments0Value_, arguments1Value, arguments2Value, s1_.compileRegexNode_, s1_.toStringNode_, s1_.isRegExpProfile_, s1_.compiledRegexAccessor_, s1_.flagsAccessor_);
                    return dynamicObject;
                }
                if (!JSGuards.isJSRegExp(arguments0Value)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.compile(arguments0Value, arguments1Value, arguments2Value);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "compile";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                Compile0Data s1_ = this.compile0_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.compileRegexNode_, s1_.toStringNode_, s1_.isRegExpProfile_, s1_.compiledRegexAccessor_, s1_.flagsAccessor_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "compile";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RegExpPrototypeBuiltins.JSRegExpCompileNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpCompileNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=RegExpPrototypeBuiltins.JSRegExpCompileNode.class)
        private static final class Compile0Data
        extends Node {
            @Node.Child
            CompileRegexNode compileRegexNode_;
            @Node.Child
            JSToStringNode toStringNode_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile isRegExpProfile_;
            @Node.Child
            TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor_;
            @Node.Child
            TRegexUtil.TRegexFlagsAccessor flagsAccessor_;

            Compile0Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

