/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.ibm.icu.text.BreakIterator;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.SegmentIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSSegmenter;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class SegmentIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SegmentIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SegmentIteratorPrototypeBuiltins();

    protected SegmentIteratorPrototypeBuiltins() {
        super("Segment Iterator.prototype", SegmentIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SegmentIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return SegmentIteratorPrototypeBuiltinsFactory.SegmentIteratorNextNodeGen.create(context, builtin, SegmentIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case preceding: {
                return SegmentIteratorPrototypeBuiltinsFactory.SegmentIteratorPrecedingNodeGen.create(context, builtin, SegmentIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case following: {
                return SegmentIteratorPrototypeBuiltinsFactory.SegmentIteratorFollowingNodeGen.create(context, builtin, SegmentIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class SegmentIteratorFollowingNode
    extends SegmentIteratorAdvanceOpNode {
        public SegmentIteratorFollowingNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        final void doCheckOffsetRange(long offset, int length) {
            if (offset >= (long)length) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorFormat("Offset out of bounds in Intl.Segment iterator %s method.", this, "following");
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        final int doAdvanceOp(BreakIterator icuIterator, int offset) {
            return icuIterator.following(offset);
        }
    }

    public static abstract class SegmentIteratorPrecedingNode
    extends SegmentIteratorAdvanceOpNode {
        public SegmentIteratorPrecedingNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        final void doCheckOffsetRange(long offset, int length) {
            if (offset == 0L || offset > (long)length) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorFormat("Offset out of bounds in Intl.Segment iterator %s method.", this, "preceding");
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        final int doAdvanceOp(BreakIterator icuIterator, int offset) {
            return icuIterator.preceding(offset);
        }
    }

    @ImportStatic(value={JSSegmenter.class})
    public static abstract class SegmentIteratorAdvanceOpNode
    extends SegmentIteratorOpNode {
        protected final BranchProfile errorBranch = BranchProfile.create();

        public SegmentIteratorAdvanceOpNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        int doAdvanceOp(BreakIterator icuIterator, int offset) {
            throw Errors.shouldNotReachHere();
        }

        void doCheckOffsetRange(long offset, int length) {
            throw Errors.shouldNotReachHere();
        }

        private boolean checkRangeAndAdvanceOp(DynamicObject iterator, long offset) {
            String iteratedString = (String)this.getIteratedObjectNode.getValue(iterator);
            this.doCheckOffsetRange(offset, iteratedString.length());
            return this.advanceOp(iterator, (int)offset);
        }

        private boolean advanceOp(DynamicObject iterator, int offset) {
            BreakIterator icuIterator = (BreakIterator)this.getSegmenterNode.getValue(iterator);
            JSSegmenter.Granularity segmenterGranularity = (JSSegmenter.Granularity)this.getSegmentIteratorGranularityNode.getValue(iterator);
            int newIndex = this.doAdvanceOp(icuIterator, offset);
            String breakType = segmenterGranularity.getBreakType(SegmentIteratorAdvanceOpNode.getRuleStatus(icuIterator));
            this.setBreakTypeNode.setValue(iterator, breakType);
            this.setIndexNode.setValue(iterator, newIndex);
            return newIndex == -1;
        }

        @Specialization(guards={"isSegmentIterator(iterator)", "!isUndefined(from)"})
        protected boolean doSegmentIteratorWithFrom(DynamicObject iterator, Object from, @Cached(value="create()") JSToIndexNode toIndexNode) {
            return this.checkRangeAndAdvanceOp(iterator, toIndexNode.executeLong(from));
        }

        @Specialization(guards={"isSegmentIterator(iterator)", "isUndefined(from)"})
        protected boolean doSegmentIteratorNoFrom(DynamicObject iterator, Object from, @Cached(value="createGetHidden(SEGMENT_ITERATOR_INDEX_ID, getContext())") PropertyGetNode getIndexNode) {
            try {
                return this.advanceOp(iterator, getIndexNode.getValueInt(iterator));
            }
            catch (UnexpectedResultException e) {
                throw Errors.shouldNotReachHere();
            }
        }

        @Specialization(guards={"!isSegmentIterator(iterator)"})
        protected DynamicObject doIncompatibleReceiver(Object iterator, Object from) {
            throw Errors.createTypeErrorTypeXExpected("Segment Iterator");
        }
    }

    public static abstract class SegmentIteratorNextNode
    extends SegmentIteratorOpNode {
        @Node.Child
        protected CreateIterResultObjectNode createIterResultObjectNode;

        public SegmentIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        }

        @Specialization(guards={"isSegmentIterator(iterator)"})
        protected DynamicObject doSegmentIterator(VirtualFrame frame, DynamicObject iterator) {
            DynamicObject nextValue;
            Object iteratedString = this.getIteratedObjectNode.getValue(iterator);
            BreakIterator icuIterator = (BreakIterator)this.getSegmenterNode.getValue(iterator);
            JSSegmenter.Granularity segmenterGranularity = (JSSegmenter.Granularity)this.getSegmentIteratorGranularityNode.getValue(iterator);
            return this.createIterResultObjectNode.execute(frame, nextValue, (nextValue = this.nextValue(iterator, (String)iteratedString, segmenterGranularity, icuIterator)) == Undefined.instance);
        }

        @Specialization(guards={"!isSegmentIterator(iterator)"})
        protected DynamicObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeErrorTypeXExpected("Segment Iterator");
        }

        @CompilerDirectives.TruffleBoundary
        protected DynamicObject nextValue(DynamicObject iterator, String s, JSSegmenter.Granularity segmenterGranularity, BreakIterator icuIterator) {
            boolean done;
            int startIndex = icuIterator.current();
            int endIndex = icuIterator.next();
            boolean bl = done = endIndex == -1;
            if (done) {
                this.setBreakTypeNode.setValue(iterator, null);
                return Undefined.instance;
            }
            String segment = s.substring(startIndex, endIndex);
            String breakType = segmenterGranularity.getBreakType(SegmentIteratorNextNode.getRuleStatus(icuIterator));
            DynamicObject result = this.makeIterationResultValue(endIndex, segment, breakType);
            this.setBreakTypeNode.setValue(iterator, breakType);
            this.setIndexNode.setValue(iterator, endIndex);
            return result;
        }

        protected DynamicObject makeIterationResultValue(int endIndex, String segment, String breakType) {
            DynamicObject result = JSUserObject.create(this.getContext());
            JSObject.set(result, "segment", (Object)segment);
            JSObject.set(result, "breakType", breakType == null ? Undefined.instance : breakType);
            JSObject.set(result, "index", (Object)endIndex);
            return result;
        }
    }

    public static abstract class SegmentIteratorOpNode
    extends JSBuiltinNode {
        @Node.Child
        protected HasHiddenKeyCacheNode isSegmentIteratorNode = HasHiddenKeyCacheNode.create(JSSegmenter.SEGMENT_ITERATOR_GRANULARITY_ID);
        @Node.Child
        protected PropertyGetNode getSegmentIteratorGranularityNode;
        @Node.Child
        protected PropertyGetNode getIteratedObjectNode;
        @Node.Child
        protected PropertyGetNode getSegmenterNode;
        @Node.Child
        protected PropertySetNode setBreakTypeNode;
        @Node.Child
        protected PropertySetNode setIndexNode;

        public SegmentIteratorOpNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getSegmentIteratorGranularityNode = PropertyGetNode.createGetHidden(JSSegmenter.SEGMENT_ITERATOR_GRANULARITY_ID, context);
            this.getIteratedObjectNode = PropertyGetNode.createGetHidden(JSRuntime.ITERATED_OBJECT_ID, context);
            this.getSegmenterNode = PropertyGetNode.createGetHidden(JSSegmenter.SEGMENT_ITERATOR_SEGMENTER_ID, context);
            this.setIndexNode = PropertySetNode.createSetHidden(JSSegmenter.SEGMENT_ITERATOR_INDEX_ID, context);
            this.setBreakTypeNode = PropertySetNode.createSetHidden(JSSegmenter.SEGMENT_ITERATOR_BREAK_TYPE_ID, context);
        }

        protected final boolean isSegmentIterator(Object thisObj) {
            return this.isSegmentIteratorNode.executeHasHiddenKey(thisObj);
        }

        @CompilerDirectives.TruffleBoundary
        protected static int getRuleStatus(BreakIterator icuIterator) {
            return icuIterator.getRuleStatus();
        }
    }

    public static enum SegmentIteratorPrototype implements BuiltinEnum<SegmentIteratorPrototype>
    {
        next(0),
        preceding(0),
        following(0);

        private final int length;

        private SegmentIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

