/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.nodes.control.DeletePropertyNodeGen;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.Set;

@NodeInfo(shortName="delete")
public abstract class DeletePropertyNode
extends JSTargetableNode {
    private final boolean strict;
    protected final JSContext context;
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode propertyNode;

    protected DeletePropertyNode(boolean strict, JSContext context, JavaScriptNode targetNode, JavaScriptNode propertyNode) {
        this.strict = strict;
        this.context = context;
        this.targetNode = targetNode;
        this.propertyNode = propertyNode;
    }

    public static DeletePropertyNode create(boolean strict, JSContext context) {
        return DeletePropertyNode.create(null, null, strict, context);
    }

    public static DeletePropertyNode createNonStrict(JSContext context) {
        return DeletePropertyNode.create(null, null, false, context);
    }

    public static DeletePropertyNode create(JavaScriptNode object, JavaScriptNode property, boolean strict, JSContext context) {
        return DeletePropertyNodeGen.create(strict, context, object, property);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.UnaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("operator", ((Object)((Object)this)).getClass().getAnnotation(NodeInfo.class).shortName());
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (this.materializationNeeded() && materializedTags.contains(JSTags.UnaryOperationTag.class)) {
            JavaScriptNode key = DeletePropertyNode.cloneUninitialized(this.propertyNode, materializedTags);
            JavaScriptNode target = DeletePropertyNode.cloneUninitialized(this.targetNode, materializedTags);
            DeletePropertyNode.transferSourceSectionAddExpressionTag(this, key);
            DeletePropertyNode.transferSourceSectionAddExpressionTag(this, target);
            DeletePropertyNode node = DeletePropertyNode.create(target, key, this.strict, this.context);
            DeletePropertyNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    private boolean materializationNeeded() {
        return !this.propertyNode.hasSourceSection() || !this.targetNode.hasSourceSection();
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeWithTarget(frame, this.evaluateTarget(frame));
    }

    @Override
    public final Object evaluateTarget(VirtualFrame frame) {
        return this.getTarget().execute(frame);
    }

    public abstract boolean executeEvaluated(Object var1, Object var2);

    @Specialization(guards={"isJSType(targetObject)"})
    protected final boolean doJSObject(DynamicObject targetObject, Object key, @Cached(value="createIsFastArray()") IsArrayNode isArrayNode, @Cached(value="createBinaryProfile()") ConditionProfile arrayProfile, @Cached(value="create()") ToArrayIndexNode toArrayIndexNode, @Cached(value="createBinaryProfile()") ConditionProfile arrayIndexProfile, @Cached(value="createClassProfile()") ValueProfile arrayTypeProfile, @Cached(value="create()") JSClassProfile jsclassProfile, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode) {
        Object propertyKey;
        boolean isArray = isArrayNode.execute(targetObject);
        if (arrayProfile.profile(isArray)) {
            Object objIndex = toArrayIndexNode.execute(key);
            if (arrayIndexProfile.profile(objIndex instanceof Long)) {
                long longIndex = (Long)objIndex;
                ScriptArray array = (ScriptArray)arrayTypeProfile.profile((Object)JSAbstractArray.arrayGetArrayType(targetObject, isArray));
                if (array.canDeleteElement(targetObject, longIndex, this.strict, isArray)) {
                    JSAbstractArray.arraySetArrayType(targetObject, array.deleteElement(targetObject, longIndex, this.strict, isArray));
                    return true;
                }
                return false;
            }
            propertyKey = objIndex;
        } else {
            propertyKey = toPropertyKeyNode.execute(key);
        }
        return JSObject.delete(targetObject, propertyKey, this.strict, jsclassProfile);
    }

    @Specialization
    protected static boolean doSymbol(Symbol target, Object property) {
        return true;
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger target, Object property) {
        return true;
    }

    @Specialization
    protected static boolean doBigInt(BigInt target, Object property) {
        return true;
    }

    @Specialization
    protected static boolean doString(String target, Object property, @Cached(value="create()") ToArrayIndexNode toArrayIndexNode) {
        Object objIndex = toArrayIndexNode.execute(property);
        if (objIndex instanceof Long) {
            long index = (Long)objIndex;
            return index < 0L || (long)target.length() <= index;
        }
        return !"length".equals(objIndex);
    }

    @Specialization(guards={"isForeignObject(target)"})
    protected boolean member(Object target, String name, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
        try {
            interop.removeMember(target, name);
            return true;
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            return false;
        }
    }

    @Specialization(guards={"isForeignObject(target)"})
    protected boolean arrayElementInt(Object target, int index, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
        return this.arrayElementLong(target, index, interop);
    }

    @Specialization(guards={"isForeignObject(target)", "isNumber(index)"}, replaces={"arrayElementInt"})
    protected boolean arrayElement(Object target, Number index, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop) {
        return this.arrayElementLong(target, JSRuntime.longValue(index), interop);
    }

    private boolean arrayElementLong(Object target, long index, InteropLibrary interop) {
        long length;
        try {
            length = interop.getArraySize(target);
        }
        catch (UnsupportedMessageException e) {
            return false;
        }
        if (index >= 0L && index < length) {
            if (this.strict) {
                throw Errors.createTypeErrorNotConfigurableProperty(Boundaries.stringValueOf(index));
            }
            return false;
        }
        return true;
    }

    @Specialization(guards={"isForeignObject(target)", "!isString(key)", "!isNumber(key)"})
    protected Object foreignObject(Object target, Object key, @Cached.Shared(value="interop") @CachedLibrary(limit="3") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary interopKey) {
        try {
            if (interopKey.isString(key)) {
                return this.member(target, interopKey.asString(key), interop);
            }
            if (interopKey.fitsInInt(key)) {
                return this.arrayElementInt(target, interopKey.asInt(key), interop);
            }
            return false;
        }
        catch (UnsupportedMessageException e) {
            return false;
        }
    }

    @Specialization(guards={"!isTruffleObject(target)", "!isString(target)"})
    public boolean doOther(Object target, Object property) {
        return true;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return DeletePropertyNode.create(DeletePropertyNode.cloneUninitialized(this.getTarget(), materializedTags), DeletePropertyNode.cloneUninitialized(this.propertyNode, materializedTags), this.strict, this.context);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }
}

