/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.IsIdenticalBooleanNode;

@GeneratedBy(value=IsIdenticalBooleanNode.class)
public final class IsIdenticalBooleanNodeGen
extends IsIdenticalBooleanNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private IsIdenticalBooleanNodeGen(JavaScriptNode operand, boolean bool, boolean leftConstant) {
        super(operand, bool, leftConstant);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_ = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_);
        }
        if ((state & 2) != 0 && IsIdenticalBooleanNodeGen.fallbackGuard_(state, operandNodeValue)) {
            return this.doOther(operandNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && state != 0) {
            return this.execute_boolean0(frameValue, state);
        }
        return this.execute_generic1(frameValue, state);
    }

    private Object execute_boolean0(VirtualFrame frameValue, int state) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doBoolean(operandNodeValue_);
    }

    private Object execute_generic1(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__ = (Boolean)operandNodeValue_;
            return this.doBoolean(operandNodeValue__);
        }
        if ((state & 2) != 0 && IsIdenticalBooleanNodeGen.fallbackGuard_(state, operandNodeValue_)) {
            return this.doOther(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && state != 0) {
            return this.executeBoolean_boolean2(frameValue, state);
        }
        return this.executeBoolean_generic3(frameValue, state);
    }

    private boolean executeBoolean_boolean2(VirtualFrame frameValue, int state) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doBoolean(operandNodeValue_);
    }

    private boolean executeBoolean_generic3(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__ = (Boolean)operandNodeValue_;
            return this.doBoolean(operandNodeValue__);
        }
        if ((state & 2) != 0 && IsIdenticalBooleanNodeGen.fallbackGuard_(state, operandNodeValue_)) {
            return this.doOther(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    private boolean executeAndSpecialize(Object operandNodeValue) {
        int state = this.state_;
        if (operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_ = (Boolean)operandNodeValue;
            this.state_ = state |= 1;
            return this.doBoolean(operandNodeValue_);
        }
        this.state_ = state |= 2;
        return this.doOther(operandNodeValue);
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object operandNodeValue) {
        return (state & 1) != 0 || !(operandNodeValue instanceof Boolean);
    }

    public static IsIdenticalBooleanNode create(JavaScriptNode operand, boolean bool, boolean leftConstant) {
        return new IsIdenticalBooleanNodeGen(operand, bool, leftConstant);
    }
}

