/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.Boundaries;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class JSAgentWaiterList {
    private final Map<Integer, JSAgentWaiterListEntry> waiters = new ConcurrentHashMap<Integer, JSAgentWaiterListEntry>();
    private final Lock globalMonitor = new ReentrantLock();

    @CompilerDirectives.TruffleBoundary
    public JSAgentWaiterList() {
    }

    public JSAgentWaiterListEntry getListForIndex(int indexPos) {
        JSAgentWaiterListEntry list = Boundaries.mapPutIfAbsent(this.waiters, indexPos, new JSAgentWaiterListEntry());
        if (list == null) {
            return Boundaries.mapGet(this.waiters, indexPos);
        }
        return list;
    }

    public void lock() {
        this.globalMonitor.lock();
    }

    public void unlock() {
        this.globalMonitor.unlock();
    }

    public static final class JSAgentWaiterListEntry
    extends ConcurrentLinkedQueue<Integer> {
        private static final long serialVersionUID = 2655886588267252886L;
        private final Lock indexMonitor = new ReentrantLock();

        @CompilerDirectives.TruffleBoundary
        public JSAgentWaiterListEntry() {
        }

        public void lock() {
            this.indexMonitor.lock();
        }

        public void unlock() {
            this.indexMonitor.unlock();
        }
    }
}

