/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedIntArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.List;

public final class HolesIntArray
extends AbstractContiguousIntArray {
    private static final HolesIntArray HOLES_INT_ARRAY = new HolesIntArray(0, HolesIntArray.createCache());
    public static final int HOLE_VALUE = Integer.MIN_VALUE;

    private HolesIntArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    public static HolesIntArray makeHolesIntArray(DynamicObject object, int length, int[] array, long indexOffset, int arrayOffset, int usedLength, int holeCount, int integrityLevel) {
        HolesIntArray arrayType = (HolesIntArray)HolesIntArray.createHolesIntArray().setIntegrityLevel(integrityLevel);
        HolesIntArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        JSAbstractArray.arraySetHoleCount(object, holeCount);
        assert (holeCount == arrayType.countHoles(object)) : String.format("holeCount, %d, differs from the actual count, %d", holeCount, arrayType.countHoles(object));
        return arrayType;
    }

    private static HolesIntArray createHolesIntArray() {
        return HOLES_INT_ARRAY;
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        HolesIntArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        JSAbstractArray.arraySetHoleCount(object, holeCount);
        return this;
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, int value, boolean condition) {
        throw Errors.shouldNotReachHere("should not call this method, use setInBounds(Non)Hole");
    }

    public boolean isHoleFast(DynamicObject object, int index, boolean condition) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object, condition));
        return this.isHolePrepared(object, internalIndex, condition);
    }

    public void setInBoundsFastHole(DynamicObject object, int index, int value, boolean condition) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object, condition));
        assert (this.isHolePrepared(object, internalIndex, condition));
        this.incrementHolesCount(object, -1);
        this.setInBoundyFastIntl(object, index, internalIndex, value, condition);
    }

    public void setInBoundsFastNonHole(DynamicObject object, int index, int value, boolean condition) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object, condition));
        assert (!this.isHolePrepared(object, internalIndex, condition));
        this.setInBoundyFastIntl(object, index, internalIndex, value, condition);
    }

    private void setInBoundyFastIntl(DynamicObject object, int index, int internalIndex, int value, boolean condition) {
        HolesIntArray.getArray((DynamicObject)object, (boolean)condition)[internalIndex] = value;
    }

    @Override
    public boolean containsHoles(DynamicObject object, long index, boolean condition) {
        return JSAbstractArray.arrayGetHoleCount(object, condition) > 0 || !this.isInBoundsFast(object, index, condition);
    }

    @Override
    public int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareInBoundsHoles(object, index, condition, profile);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return this.isSupportedHoles(object, index, condition);
    }

    @Override
    public int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareSupportedHoles(object, index, condition, profile);
    }

    @Override
    public AbstractIntArray toNonHoles(DynamicObject object, long index, Object value, boolean condition) {
        assert (!this.containsHoles(object, index, condition));
        int[] array = HolesIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = HolesIntArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        this.setInBoundsFastNonHole(object, (int)index, (Integer)value, condition);
        AbstractIntArray newArray = indexOffset == 0L && arrayOffset == 0 ? ZeroBasedIntArray.makeZeroBasedIntArray(object, length, usedLength, array, this.integrityLevel) : ContiguousIntArray.makeContiguousIntArray(object, length, array, indexOffset, arrayOffset, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            HolesIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index, boolean condition) {
        int value = this.getInBoundsFastInt(object, index, condition);
        if (HolesIntArray.isHoleValue(value)) {
            return Undefined.instance;
        }
        return value;
    }

    @Override
    protected void incrementHolesCount(DynamicObject object, int offset) {
        JSAbstractArray.arraySetHoleCount(object, JSAbstractArray.arrayGetHoleCount(object) + offset);
    }

    @Override
    public HolesIntArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        return this;
    }

    @Override
    public AbstractWritableArray toDouble(DynamicObject object, long index, double value, boolean condition) {
        int[] array = HolesIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = HolesIntArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        int holeCount = JSAbstractArray.arrayGetHoleCount(object, condition);
        double[] doubleCopy = ArrayCopy.intToDoubleHoles(array, arrayOffset, usedLength);
        HolesDoubleArray newArray = HolesDoubleArray.makeHolesDoubleArray(object, length, doubleCopy, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            HolesIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray toObject(DynamicObject object, long index, Object value, boolean condition) {
        int[] array = HolesIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = HolesIntArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        int holeCount = JSAbstractArray.arrayGetHoleCount(object, condition);
        Object[] objectCopy = ArrayCopy.intToObjectHoles(array, arrayOffset, usedLength);
        HolesObjectArray newArray = HolesObjectArray.makeHolesObjectArray(object, length, objectCopy, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            HolesIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    public static boolean isHoleValue(int value) {
        return value == Integer.MIN_VALUE;
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index0, boolean condition) {
        return this.nextElementIndexHoles(object, index0, condition);
    }

    @Override
    public long previousElementIndex(DynamicObject object, long index0, boolean condition) {
        return this.previousElementIndexHoles(object, index0, condition);
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return super.hasElement(object, index, condition) && !this.isHolePrepared(object, this.prepareInBoundsFast(object, (int)index, condition), condition);
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.deleteElementHoles(object, index, condition);
    }

    @Override
    protected HolesObjectArray toObjectHoles(DynamicObject object, boolean condition) {
        throw new UnsupportedOperationException("already a holes array");
    }

    @Override
    public boolean isHolesType() {
        return true;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.removeRangeHoles(object, start, end);
    }

    @Override
    protected HolesIntArray withIntegrityLevel(int newIntegrityLevel) {
        return new HolesIntArray(newIntegrityLevel, this.cache);
    }

    @Override
    public List<Object> ownPropertyKeys(DynamicObject object) {
        return this.ownPropertyKeysHoles(object);
    }
}

