/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.BitSet;
import org.testng.IResultMap;
import org.testng.ITestContext;

public class ExitCode {
    public static final int HAS_NO_TEST = 8;
    private static final int FAILED_WITHIN_SUCCESS = 4;
    private static final int SKIPPED = 2;
    private static final int FAILED = 1;
    private static final int SIZE = 3;
    private final BitSet exitCodeBits;

    ExitCode() {
        this(new BitSet(3));
    }

    public static boolean hasFailureWithinSuccessPercentage(int n) {
        return (n & 4) == 4;
    }

    public static boolean hasSkipped(int n) {
        return (n & 2) == 2;
    }

    public static boolean hasFailure(int n) {
        return (n & 1) == 1;
    }

    public static ExitCode newExitCodeRepresentingFailure() {
        BitSet bitSet = new BitSet(3);
        bitSet.set(0, true);
        bitSet.set(1, false);
        bitSet.set(2, false);
        return new ExitCode(bitSet);
    }

    private ExitCode(BitSet bitSet) {
        this.exitCodeBits = bitSet;
    }

    void computeAndUpdate(ITestContext iTestContext) {
        this.computeAndUpdate(0, iTestContext.getFailedTests(), iTestContext.getFailedConfigurations());
        this.computeAndUpdate(1, iTestContext.getSkippedTests(), iTestContext.getSkippedConfigurations());
        this.computeAndUpdate(2, iTestContext.getFailedButWithinSuccessPercentageTests(), null);
    }

    private void computeAndUpdate(int n, IResultMap iResultMap, IResultMap iResultMap2) {
        boolean bl;
        boolean bl2 = bl = iResultMap.size() != 0;
        if (iResultMap2 != null) {
            boolean bl3 = bl = bl || iResultMap2.size() != 0;
        }
        if (bl) {
            this.exitCodeBits.set(n);
        }
    }

    public boolean hasFailure() {
        return this.exitCodeBits.get(0);
    }

    public boolean hasSkip() {
        return this.exitCodeBits.get(1);
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return this.exitCodeBits.get(2);
    }

    public int getExitCode() {
        int n = 0;
        for (int i = 0; i < this.exitCodeBits.length(); ++i) {
            if (!this.exitCodeBits.get(i)) continue;
            n |= 1 << i;
        }
        return n;
    }
}

