/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.xml.AntProjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.Element;

public class AntScriptUtils {
    private static final Map<FileObject, AntProjectCookie> antProjectCookies = new WeakHashMap<FileObject, AntProjectCookie>();

    private AntScriptUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AntProjectCookie antProjectCookieFor(FileObject script) {
        AntProjectCookie apc;
        block7: {
            try {
                DataObject d = DataObject.find((FileObject)script);
                apc = (AntProjectCookie)d.getCookie(AntProjectCookie.class);
                if (apc != null) {
                    return apc;
                }
            }
            catch (DataObjectNotFoundException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e);
            }
        }
        Map<FileObject, AntProjectCookie> map = antProjectCookies;
        synchronized (map) {
            apc = antProjectCookies.get(script);
            if (apc == null) {
                apc = new AntProjectSupport(script);
                antProjectCookies.put(script, apc);
            }
            return apc;
        }
    }

    public static String getAntScriptName(FileObject script) {
        AntProjectCookie apc = AntScriptUtils.antProjectCookieFor(script);
        Element projEl = apc.getProjectElement();
        if (projEl == null) {
            return null;
        }
        String name = projEl.getAttribute("name");
        return name.length() > 0 ? name : null;
    }

    public static List<String> getCallableTargetNames(FileObject script) throws IOException {
        AntProjectCookie apc = AntScriptUtils.antProjectCookieFor(script);
        Set<TargetLister.Target> allTargets = TargetLister.getTargets(apc);
        TreeSet<Object> targetNames = new TreeSet<Object>(Collator.getInstance());
        for (TargetLister.Target target : allTargets) {
            if (target.isOverridden() || target.isInternal()) continue;
            targetNames.add(target.getName());
        }
        return new ArrayList<Object>(targetNames);
    }
}

