/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.enc;

import com.sun.xml.util.XMLCipherAdapter;
import com.sun.xml.ws.security.opt.crypto.JAXBData;
import com.sun.xml.ws.security.opt.crypto.StreamWriterData;
import com.sun.xml.ws.security.opt.impl.util.OutputStreamWrapper;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.c14n.StAXC14nCanonicalizerImpl;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.crypto.Data;
import javax.xml.stream.XMLStreamException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.jvnet.staxex.NamespaceContextEx;

public class CryptoProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    protected Cipher cipher = null;
    protected Key key = null;
    protected Data data = null;
    private int mode = 1;
    private String algorithm = "";
    private Key dk = null;
    private byte[] ed = null;
    private IvParameterSpec ivSpec = null;
    private byte[] encryptedDataCV = null;

    public CryptoProcessor() {
    }

    public CryptoProcessor(int mode, String algo, Data ed, Key key) throws XWSSecurityException {
        this.mode = mode;
        this.algorithm = algo;
        this.data = ed;
        this.key = key;
    }

    public CryptoProcessor(int mode, String algo, Key dk, Key key) throws XWSSecurityException {
        this.mode = mode;
        this.algorithm = algo;
        this.key = key;
        this.dk = dk;
    }

    public CryptoProcessor(int mode, String algo, Key key) throws XWSSecurityException {
        this.mode = mode;
        this.algorithm = algo;
        this.key = key;
    }

    protected void initCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (this.cipher == null) {
            this.cipher = XMLCipherAdapter.constructCipher(this.getAlgorithm());
            this.cipher.init(this.mode, this.getKey());
        }
    }

    protected String getAlgorithm() {
        return this.algorithm;
    }

    protected String convertAlgURIToTransformation(String algorithmURI) {
        return JCEMapper.translateURItoJCEID(algorithmURI);
    }

    protected Key getKey() {
        return this.key;
    }

    public void encrypt(OutputStream outputStream) throws IOException {
        if (this.mode == 1) {
            this.encryptData(outputStream);
        } else if (this.mode == 3) {
            this.encryptKey(outputStream);
        }
    }

    public byte[] getCipherValueOfEK() {
        try {
            if (this.ed == null) {
                if (this.cipher == null) {
                    this.initCipher();
                }
                this.ed = this.cipher.wrap(this.dk);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1904_UNSUPPORTED_KEYENCRYPTION_ALGORITHM(this.getAlgorithm()), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1905_ERROR_INITIALIZING_CIPHER(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1906_INVALID_KEY_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (IllegalBlockSizeException ibe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1907_INCORRECT_BLOCK_SIZE(), ibe);
            throw new XWSSecurityRuntimeException(ibe);
        }
        return this.ed;
    }

    public void encryptKey(OutputStream outputStream) throws IOException {
        try {
            if (this.ed == null) {
                if (this.cipher == null) {
                    this.initCipher();
                }
                this.ed = this.cipher.wrap(this.dk);
            }
            outputStream.write(this.ed);
            outputStream.flush();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1904_UNSUPPORTED_KEYENCRYPTION_ALGORITHM(this.getAlgorithm()), ex);
            throw new XWSSecurityRuntimeException("Unable to compute CipherValue as " + this.getAlgorithm() + " is not supported", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1905_ERROR_INITIALIZING_CIPHER(), ex);
            throw new XWSSecurityRuntimeException("Error occurred while initializing the Cipher", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1906_INVALID_KEY_ERROR(), ex);
            throw new XWSSecurityRuntimeException("Unable to calculate cipher value as invalid key was provided", ex);
        }
        catch (IllegalBlockSizeException ibe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1907_INCORRECT_BLOCK_SIZE(), ibe);
            throw new XWSSecurityRuntimeException(ibe);
        }
    }

    public void setEncryptedDataCV(byte[] cv) {
        this.encryptedDataCV = cv;
    }

    public byte[] encryptData(byte[] cipherInput) {
        try {
            if (this.cipher == null) {
                this.initCipher();
            }
            byte[] cipherOutput = this.cipher.doFinal(cipherInput);
            byte[] iv = this.cipher.getIV();
            byte[] encryptedBytes = new byte[iv.length + cipherOutput.length];
            System.arraycopy(iv, 0, encryptedBytes, 0, iv.length);
            System.arraycopy(cipherOutput, 0, encryptedBytes, iv.length, cipherOutput.length);
            return encryptedBytes;
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1909_UNSUPPORTED_DATAENCRYPTION_ALGORITHM(this.getAlgorithm()), ex);
            throw new XWSSecurityRuntimeException("Unable to compute CipherValue as " + this.getAlgorithm() + " is not supported", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1905_ERROR_INITIALIZING_CIPHER(), ex);
            throw new XWSSecurityRuntimeException("Error occurred while initializing the Cipher", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1906_INVALID_KEY_ERROR(), ex);
            throw new XWSSecurityRuntimeException("Unable to calculate cipher value as invalid key was provided", ex);
        }
        catch (IllegalBlockSizeException ibse) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1915_INVALID_ALGORITHM_PARAMETERS(this.getAlgorithm()), ibse);
            throw new XWSSecurityRuntimeException(ibse);
        }
        catch (BadPaddingException bpe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1915_INVALID_ALGORITHM_PARAMETERS(this.getAlgorithm()), bpe);
            throw new XWSSecurityRuntimeException(bpe);
        }
    }

    public void encryptData(OutputStream eos) throws IOException {
        try {
            OutputStreamWrapper outputStream = new OutputStreamWrapper(eos);
            if (this.encryptedDataCV != null) {
                outputStream.write(this.encryptedDataCV);
                return;
            }
            if (this.cipher == null) {
                this.initCipher();
            }
            CipherOutputStream cos = new CipherOutputStream(outputStream, this.cipher);
            byte[] iv = this.cipher.getIV();
            outputStream.write(iv);
            outputStream.flush();
            if (this.data instanceof JAXBData) {
                ((JAXBData)this.data).writeTo(cos);
            } else if (this.data instanceof StreamWriterData) {
                StAXEXC14nCanonicalizerImpl exc14n = new StAXEXC14nCanonicalizerImpl();
                NamespaceContextEx nsEx = ((StreamWriterData)this.data).getNamespaceContext();
                for (NamespaceContextEx.Binding binding : nsEx) {
                    ((StAXC14nCanonicalizerImpl)exc14n).writeNamespace(binding.getPrefix(), binding.getNamespaceURI());
                }
                if (logger.isLoggable(Level.FINEST)) {
                    exc14n.setStream(new ByteArrayOutputStream());
                } else {
                    exc14n.setStream(cos);
                }
                try {
                    ((StreamWriterData)this.data).write(exc14n);
                    if (logger.isLoggable(Level.FINEST)) {
                        byte[] cd = ((ByteArrayOutputStream)exc14n.getOutputStream()).toByteArray();
                        logger.log(Level.FINEST, LogStringsMessages.WSS_1951_ENCRYPTED_DATA_VALUE(new String(cd)));
                        cos.write(cd);
                    }
                }
                catch (XMLStreamException ex) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1908_ERROR_WRITING_ENCRYPTEDDATA(), ex);
                }
            }
            cos.flush();
            cos.close();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1909_UNSUPPORTED_DATAENCRYPTION_ALGORITHM(this.getAlgorithm()), ex);
            throw new XWSSecurityRuntimeException("Unable to compute CipherValue as " + this.getAlgorithm() + " is not supported", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1905_ERROR_INITIALIZING_CIPHER(), ex);
            throw new XWSSecurityRuntimeException("Error occurred while initializing the Cipher", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1906_INVALID_KEY_ERROR(), ex);
            throw new XWSSecurityRuntimeException("Unable to calculate cipher value as invalid key was provided", ex);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1910_ERROR_WRITING_NAMESPACES_CANONICALIZER(xse.getMessage()), xse);
            throw new XWSSecurityRuntimeException("Unable to write namespaces to exclusive canonicalizer", xse);
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1911_ERROR_WRITING_CIPHERVALUE(ex.getMessage()), ex);
            throw new XWSSecurityRuntimeException("Unable to calculate cipher value ", ex);
        }
    }

    public Key decryptKey(byte[] encryptedKey, String encAlgo) throws IOException {
        try {
            if (this.mode == 4) {
                if (this.algorithm == null || this.algorithm.length() == 0) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1912_DECRYPTION_ALGORITHM_NULL());
                    throw new IOException("Cannot decrypt a key without knowing the algorithm");
                }
                if (this.key == null) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1913_DECRYPTION_KEY_NULL());
                    throw new IOException("Key used to decrypt EncryptedKey cannot be null");
                }
                if (this.cipher == null) {
                    this.initCipher();
                }
                return this.cipher.unwrap(encryptedKey, JCEMapper.getJCEKeyAlgorithmFromURI(encAlgo), 3);
            }
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1906_INVALID_KEY_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1904_UNSUPPORTED_KEYENCRYPTION_ALGORITHM(this.algorithm), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1905_ERROR_INITIALIZING_CIPHER(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1914_INVALID_CIPHER_MODE(this.mode));
        throw new IOException("Invalid Cipher mode:" + this.mode);
    }

    public InputStream decryptData(InputStream is) throws IOException {
        try {
            if (this.mode == 2) {
                if (this.cipher == null) {
                    this.cipher = XMLCipherAdapter.constructCipher(this.getAlgorithm());
                    int len = this.cipher.getBlockSize();
                    byte[] iv = new byte[len];
                    is.read(iv, 0, len);
                    this.ivSpec = new IvParameterSpec(iv);
                    this.cipher.init(this.mode, this.key, this.ivSpec);
                }
                return new CipherInputStream(is, this.cipher);
            }
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1914_INVALID_CIPHER_MODE(this.mode), "Invalid Cipher mode:" + this.mode);
            throw new IOException("Invalid Cipher mode:" + this.mode);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1906_INVALID_KEY_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1909_UNSUPPORTED_DATAENCRYPTION_ALGORITHM(this.getAlgorithm()), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1905_ERROR_INITIALIZING_CIPHER(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (InvalidAlgorithmParameterException invalidAPE) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1915_INVALID_ALGORITHM_PARAMETERS(this.getAlgorithm()), invalidAPE);
            throw new XWSSecurityRuntimeException(invalidAPE);
        }
    }

    public byte[] decryptData(byte[] encryptedContent) throws IOException {
        try {
            if (this.mode == 2) {
                this.cipher = XMLCipherAdapter.constructCipher(this.getAlgorithm());
                int len = this.cipher.getBlockSize();
                byte[] iv = new byte[len];
                System.arraycopy(encryptedContent, 0, iv, 0, len);
                this.ivSpec = new IvParameterSpec(iv);
                this.cipher.init(this.mode, this.key, this.ivSpec);
                return this.cipher.doFinal(encryptedContent, len, encryptedContent.length - len);
            }
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1914_INVALID_CIPHER_MODE(this.mode));
            throw new IOException("Invalid Cipher mode:" + this.mode);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1906_INVALID_KEY_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1909_UNSUPPORTED_DATAENCRYPTION_ALGORITHM(this.getAlgorithm()), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1905_ERROR_INITIALIZING_CIPHER(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (InvalidAlgorithmParameterException invalidAPE) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1915_INVALID_ALGORITHM_PARAMETERS(this.getAlgorithm()), invalidAPE);
            throw new XWSSecurityRuntimeException(invalidAPE);
        }
        catch (IllegalBlockSizeException ibse) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1915_INVALID_ALGORITHM_PARAMETERS(this.getAlgorithm()), ibse);
            throw new XWSSecurityRuntimeException(ibse);
        }
        catch (BadPaddingException bpe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1915_INVALID_ALGORITHM_PARAMETERS(this.getAlgorithm()), bpe);
            throw new XWSSecurityRuntimeException(bpe);
        }
    }
}

