/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.ws.security.Token;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.BinarySecurityToken;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.SecurityTokenException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.w3c.dom.Document;

public class X509SecurityToken
extends BinarySecurityToken
implements Token {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private X509Certificate cert;

    public X509SecurityToken(Document document, X509Certificate cert, String wsuId, String valueType) throws SecurityTokenException {
        super(document, wsuId, valueType);
        this.cert = cert;
    }

    public X509SecurityToken(Document document, X509Certificate cert) throws SecurityTokenException {
        super(document, null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        this.cert = cert;
    }

    public X509SecurityToken(Document document, X509Certificate cert, String valueType) throws SecurityTokenException {
        super(document, null, valueType);
        this.cert = cert;
    }

    public X509SecurityToken(SOAPElement tokenElement, boolean isBSP) throws XWSSecurityException {
        super(tokenElement, isBSP);
        if (!tokenElement.getLocalName().equals("BinarySecurityToken") || !XMLUtil.inWsseNS(tokenElement)) {
            log.log(Level.SEVERE, "WSS0391.error.creating.X509SecurityToken", tokenElement.getTagName());
            throw new XWSSecurityException("BinarySecurityToken expected, found " + tokenElement.getTagName());
        }
    }

    public X509SecurityToken(SOAPElement tokenElement) throws XWSSecurityException {
        this(tokenElement, false);
    }

    public X509Certificate getCertificate() throws XWSSecurityException {
        if (this.cert == null) {
            byte[] data;
            String encodedData = XMLUtil.getFullTextFromChildren(this);
            try {
                data = Base64.decode(encodedData);
            }
            catch (Base64DecodingException bde) {
                log.log(Level.SEVERE, "WSS0301.unableto.decode.data");
                throw new SecurityTokenException("Unable to decode data", bde);
            }
            try {
                CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                this.cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(data));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0302.unableto.create.x509cert");
                throw new XWSSecurityException("Unable to create X509Certificate from data");
            }
        }
        return this.cert;
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, X509SecurityToken.class);
    }

    @Override
    public String getTextValue() throws XWSSecurityException {
        if (this.encodedText == null) {
            try {
                byte[] rawBytes = this.cert.getEncoded();
                this.setRawValue(rawBytes);
            }
            catch (CertificateEncodingException e) {
                log.log(Level.SEVERE, "WSS0303.unableto.get.encoded.x509cert");
                throw new XWSSecurityException("Unable to get encoded representation of X509Certificate", e);
            }
        }
        return this.encodedText;
    }

    private void checkCertVersion() throws SecurityTokenException {
        if (this.cert.getVersion() != 3 || this.cert.getVersion() != 1) {
            log.log(Level.SEVERE, "WSS0392.invalid.X509cert.version", Integer.toString(this.cert.getVersion()));
            throw new SecurityTokenException("Expected Version 1 or 3 Certificate, found Version " + this.cert.getVersion());
        }
    }

    @Override
    public String getType() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0";
    }

    @Override
    public Object getTokenValue() {
        try {
            return this.getCertificate();
        }
        catch (XWSSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }
}

