/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class FSCompletion
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void query(final CompletionResultSet resultSet, Document doc, final int caretOffset) {
                try {
                    Source source;
                    List includePath;
                    block9: {
                        FileObject file = NavUtils.getFile(doc);
                        if (file == null || caretOffset == -1) {
                            return;
                        }
                        includePath = PhpSourcePath.getIncludePath((FileObject)file);
                        source = Source.create((FileObject)file);
                        if (source != null) break block9;
                        return;
                    }
                    try {
                        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                Parser.Result parserResult = resultIterator.getParserResult();
                                if (parserResult instanceof ParserResult) {
                                    ParserResult parameter = (ParserResult)parserResult;
                                    List<ASTNode> path = NavUtils.underCaret(parameter, caretOffset);
                                    if (path.size() < 2) {
                                        return;
                                    }
                                    ASTNode d1 = path.get(path.size() - 1);
                                    ASTNode d2 = path.get(path.size() - 2);
                                    if (d2 instanceof ParenthesisExpression) {
                                        if (path.size() < 3) {
                                            return;
                                        }
                                        d2 = path.get(path.size() - 3);
                                    }
                                    if (!(d1 instanceof Scalar) || !(d2 instanceof Include)) {
                                        return;
                                    }
                                    Scalar s = (Scalar)d1;
                                    if (s.getScalarType() != Scalar.Type.STRING || !NavUtils.isQuoted(s.getStringValue())) {
                                        return;
                                    }
                                    int startOffset = s.getStartOffset() + 1;
                                    if (startOffset > caretOffset || startOffset < 0 || caretOffset < 0) {
                                        return;
                                    }
                                    String prefix = parameter.getSnapshot().getText().subSequence(startOffset, caretOffset).toString();
                                    LinkedList<FileObject> relativeTo = new LinkedList<FileObject>();
                                    if (!prefix.startsWith("../")) {
                                        relativeTo.addAll(includePath);
                                    }
                                    PHPIncludesFilter filter = new PHPIncludesFilter(parameter.getSnapshot().getSource().getFileObject());
                                    FileObject parent = parameter.getSnapshot().getSource().getFileObject().getParent();
                                    if (parent != null) {
                                        relativeTo.add(parent);
                                    }
                                    resultSet.addAllItems((Collection)FSCompletion.computeRelativeItems(relativeTo, prefix, startOffset, filter));
                                }
                            }
                        });
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                finally {
                    resultSet.finish();
                }
            }
        }, component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static List<? extends CompletionItem> computeRelativeItems(Collection<? extends FileObject> relativeTo, final String prefix, int anchor, FileObjectFilter filter) throws IOException {
        FileObject parent;
        String filePrefix;
        String pathPrefix;
        String goUp = "../";
        assert (relativeTo != null);
        LinkedList<FSCompletionItem> result = new LinkedList<FSCompletionItem>();
        int lastSlash = prefix.lastIndexOf(47);
        if (lastSlash != -1) {
            pathPrefix = prefix.substring(0, lastSlash);
            filePrefix = prefix.substring(lastSlash + 1);
        } else {
            pathPrefix = null;
            filePrefix = prefix;
        }
        HashSet<Object> directories = new HashSet<Object>();
        File prefixFile = null;
        if (pathPrefix != null && !pathPrefix.startsWith(".")) {
            prefixFile = pathPrefix.length() == 0 && prefix.startsWith("/") ? new File("/") : new File(pathPrefix);
        }
        if (prefixFile != null && prefixFile.exists()) {
            File normalizeFile = FileUtil.normalizeFile((File)prefixFile);
            FileObject fileObject = FileUtil.toFileObject((File)normalizeFile);
            if (fileObject != null) {
                directories.add(fileObject);
            }
        } else {
            for (FileObject fileObject : relativeTo) {
                void var12_13;
                if (pathPrefix != null) {
                    File toFile = FileUtil.toFile((FileObject)fileObject);
                    if (toFile != null) {
                        URI resolve = Utilities.toURI((File)toFile).resolve(pathPrefix).normalize();
                        File normalizedFile = FileUtil.normalizeFile((File)Utilities.toFile((URI)resolve));
                        FileObject fileObject2 = FileUtil.toFileObject((File)normalizedFile);
                    } else {
                        FileObject fileObject3 = fileObject.getFileObject(pathPrefix);
                    }
                }
                if (var12_13 == null) continue;
                directories.add(var12_13);
            }
        }
        for (FileObject fileObject : directories) {
            FileObject[] children = fileObject.getChildren();
            for (int cntr = 0; cntr < children.length; ++cntr) {
                FileObject current = children[cntr];
                if (!VisibilityQuery.getDefault().isVisible(current) || !current.getNameExt().toLowerCase().startsWith(filePrefix.toLowerCase()) || !filter.accept(current)) continue;
                result.add(new FSCompletionItem(current, pathPrefix != null ? pathPrefix + "/" : "./", anchor));
            }
        }
        if ("../".startsWith(filePrefix) && directories.size() == 1 && (parent = (FileObject)directories.iterator().next()).getParent() != null && VisibilityQuery.getDefault().isVisible(parent.getParent()) && filter.accept(parent.getParent())) {
            result.add(new FSCompletionItem(parent, "", anchor){

                @Override
                public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
                    CompletionUtilities.renderHtml((ImageIcon)((FSCompletionItem)this).icon, (String)"../", null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
                }

                @Override
                protected String getText() {
                    return (!prefix.equals("..") && !prefix.equals(".") ? prefix : "") + "../";
                }
            });
        }
        return result;
    }

    static interface FileObjectFilter {
        public boolean accept(FileObject var1);
    }

    static class FSCompletionItem
    implements CompletionItem {
        private FileObject file;
        private ImageIcon icon;
        private int anchor;
        private String prefix;

        public FSCompletionItem(FileObject file, String prefix, int anchor) throws IOException {
            this.file = file;
            DataObject od = DataObject.find((FileObject)file);
            this.icon = new ImageIcon(od.getNodeDelegate().getIcon(1));
            this.anchor = anchor;
            this.prefix = prefix;
        }

        private void doSubstitute(final JTextComponent component, String toAdd, final int backOffset) {
            final BaseDocument doc = (BaseDocument)component.getDocument();
            final int caretOffset = component.getCaretPosition();
            final String value = this.getText() + (toAdd != null && (!toAdd.equals("/") || toAdd.equals("/") && !this.getText().endsWith(toAdd)) ? toAdd : "");
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        String pfx = doc.getText(anchor, caretOffset - anchor);
                        doc.remove(caretOffset - pfx.length(), pfx.length());
                        doc.insertString(caretOffset - pfx.length(), value, null);
                        component.setCaretPosition(component.getCaretPosition() - backOffset);
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
        }

        public void defaultAction(JTextComponent component) {
            this.doSubstitute(component, null, 0);
            if (!this.file.isFolder()) {
                Completion.get().hideAll();
            }
        }

        public void processKeyEvent(KeyEvent evt) {
            if (evt.getID() == 400) {
                String strToAdd = "/";
                if (evt.getKeyChar() == '/') {
                    this.doSubstitute((JTextComponent)evt.getSource(), strToAdd, strToAdd.length() - 1);
                    evt.consume();
                }
            }
        }

        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.file.getNameExt(), null, (Graphics)g, (Font)defaultFont);
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)this.icon, (String)this.file.getNameExt(), null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public int getSortPriority() {
            return -1000;
        }

        public CharSequence getSortText() {
            return this.getText();
        }

        public CharSequence getInsertPrefix() {
            return this.getText();
        }

        protected String getText() {
            return this.prefix + this.file.getNameExt() + (this.file.isFolder() ? "/" : "");
        }

        public int hashCode() {
            return this.getText().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FSCompletionItem)) {
                return false;
            }
            FSCompletionItem remote = (FSCompletionItem)o;
            return this.getText().equals(remote.getText());
        }
    }

    private static class PHPIncludesFilter
    implements FileObjectFilter {
        private FileObject currentFile;

        public PHPIncludesFilter(FileObject currentFile) {
            this.currentFile = currentFile;
        }

        @Override
        public boolean accept(FileObject file) {
            if (file.equals(this.currentFile) || PHPIncludesFilter.isNbProjectMetadata(file)) {
                return false;
            }
            if (file.isFolder()) {
                return true;
            }
            String mimeType = FileUtil.getMIMEType((FileObject)file);
            return mimeType != null && mimeType.startsWith("text/");
        }

        private static boolean isNbProjectMetadata(FileObject fo) {
            String metadataName = "nbproject";
            if (fo.getPath().indexOf("nbproject") != -1) {
                while (fo != null) {
                    if (fo.isFolder() && "nbproject".equals(fo.getNameExt())) {
                        return true;
                    }
                    fo = fo.getParent();
                }
            }
            return false;
        }
    }
}

