/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TestNGSuiteHyperlingProvider
implements HyperlinkProvider {
    private int startOffset;
    private int endOffset;
    private String file;
    private String method;
    private LinkType targetType;
    private static final Map<String, LinkType> linkMap = new ConcurrentHashMap<String, LinkType>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHyperlinkPoint(Document doc, int offset) {
        JTextComponent target = EditorRegistry.lastFocusedComponent();
        StyledDocument styledDoc = (StyledDocument)target.getDocument();
        if (styledDoc == null) {
            return false;
        }
        if (target == null || target.getDocument() != doc) {
            return false;
        }
        TokenHierarchy hi = TokenHierarchy.get((Document)doc);
        TokenSequence ts = hi.tokenSequence(XMLTokenId.language());
        ts.move(offset);
        ts.moveNext();
        Token tok = ts.token();
        if (tok == null) return false;
        int tokOffset = ts.offset();
        Token<XMLTokenId> t = this.getAttribute((TokenSequence<XMLTokenId>)ts);
        if (t == null) {
            return false;
        }
        String xpath = "#" + t.text().toString();
        t = this.getParentElement((TokenSequence<XMLTokenId>)ts);
        xpath = this.getElementName(t) + xpath;
        this.targetType = linkMap.get(xpath);
        if (this.targetType == null) {
            return false;
        }
        if (xpath.startsWith("include") || xpath.startsWith("exclude")) {
            t = this.getParentElement((TokenSequence<XMLTokenId>)ts);
            if (!"methods".equals(this.getElementName(t))) return false;
            this.method = tok.text().toString();
            this.getParentElement((TokenSequence<XMLTokenId>)ts);
            this.file = this.getAttributeValue((TokenSequence<XMLTokenId>)ts, "name");
        } else {
            this.method = null;
        }
        this.startOffset = tokOffset + 1;
        this.endOffset = this.startOffset + tok.text().length() - 2;
        if (this.method == null) {
            this.file = tok.text().subSequence(1, tok.text().length() - 1).toString();
            return true;
        } else {
            this.method = this.method.substring(1, this.method.length() - 1);
        }
        return true;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        JTextComponent target = EditorRegistry.lastFocusedComponent();
        StyledDocument styledDoc = (StyledDocument)target.getDocument();
        if (styledDoc == null) {
            return null;
        }
        return new int[]{this.startOffset, this.endOffset};
    }

    public void performClickAction(final Document doc, final int offset) {
        final AtomicBoolean cancel = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TestNGSuiteHyperlingProvider.this.performGoTo(doc, offset, TestNGSuiteHyperlingProvider.this.file, TestNGSuiteHyperlingProvider.this.method, TestNGSuiteHyperlingProvider.this.targetType, cancel);
            }
        }, (String)NbBundle.getMessage(TestNGSuiteHyperlingProvider.class, (String)"LBL_GoToDeclaration"), (AtomicBoolean)cancel, (boolean)false);
    }

    private Token<XMLTokenId> getAttribute(TokenSequence<XMLTokenId> ts) {
        Token tok = ts.token();
        if (tok.id() == XMLTokenId.VALUE) {
            block4: while (ts.movePrevious()) {
                tok = ts.token();
                switch ((XMLTokenId)tok.id()) {
                    case ARGUMENT: {
                        return tok;
                    }
                    case OPERATOR: 
                    case EOL: 
                    case ERROR: 
                    case WS: {
                        continue block4;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private Token<XMLTokenId> getParentElement(TokenSequence<XMLTokenId> ts) {
        int depth = 0;
        block3: while (ts.movePrevious()) {
            Token prev = ts.token();
            switch ((XMLTokenId)prev.id()) {
                case TAG: {
                    if (prev.text().length() == 1) continue block3;
                    if (prev.text().toString().contains("/")) {
                        ++depth;
                        continue block3;
                    }
                    if (--depth != -1) continue block3;
                    return prev;
                }
            }
        }
        return null;
    }

    private String getElementName(Token<XMLTokenId> tok) {
        return tok.text().toString().substring(1);
    }

    private String getAttributeValue(TokenSequence<XMLTokenId> ts, String name) {
        boolean readValue = false;
        block5: while (ts.moveNext()) {
            Token next = ts.token();
            switch ((XMLTokenId)next.id()) {
                case ARGUMENT: {
                    if (!name.equals(next.text().toString())) continue block5;
                    readValue = true;
                    continue block5;
                }
                case VALUE: {
                    if (!readValue) continue block5;
                    CharSequence val = next.text().subSequence(1, next.text().length() - 1);
                    return val.toString();
                }
                case OPERATOR: 
                case EOL: 
                case ERROR: 
                case WS: {
                    continue block5;
                }
            }
            return null;
        }
        return null;
    }

    private void performGoTo(Document doc, int offset, final String file, final String method, LinkType type, AtomicBoolean cancel) {
        switch (type) {
            case RESOURCE: {
                FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
                File target = new File(file);
                FileObject targetFO = target.isAbsolute() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)target)) : fo.getParent().getFileObject(file);
                if (targetFO.isData() && targetFO.isValid() && !targetFO.isVirtual()) {
                    this.openInEditor(targetFO);
                    break;
                }
                String key = "goto_source_source_not_found";
                String msg = NbBundle.getMessage(TestNGSuiteHyperlingProvider.class, (String)key);
                StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, file));
                break;
            }
            case JAVA_SOURCE: {
                final ClasspathInfo cp = ClasspathInfo.create((Document)doc);
                JavaSource js = JavaSource.create((ClasspathInfo)cp, Collections.emptyList());
                try {
                    js.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController cc) throws Exception {
                            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = cc.getElements().getTypeElement(file.trim());
                            if (element != null) {
                                if (method != null) {
                                    List<? extends Element> enclosedElements = cc.getElements().getAllMembers((TypeElement)element);
                                    for (Element element2 : enclosedElements) {
                                        if (element2.getKind() != ElementKind.METHOD || !element2.getSimpleName().toString().equals(method)) continue;
                                        element = element2;
                                        break;
                                    }
                                }
                                if (!ElementOpen.open((ClasspathInfo)cp, (Element)element)) {
                                    String key = "goto_source_source_not_found";
                                    String msg = NbBundle.getMessage(TestNGSuiteHyperlingProvider.class, (String)key);
                                    StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, file));
                                }
                            }
                        }
                    }, false);
                    break;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void openInEditor(FileObject fo) {
        Node.Cookie cookie;
        DataObject dobj;
        try {
            dobj = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            Exceptions.printStackTrace((Throwable)e);
            return;
        }
        if (dobj != null && (cookie = (Node.Cookie)dobj.getLookup().lookup(OpenCookie.class)) != null) {
            ((OpenCookie)cookie).open();
        }
    }

    static {
        linkMap.put("suite-file#path", LinkType.RESOURCE);
        linkMap.put("class#name", LinkType.JAVA_SOURCE);
        linkMap.put("listener#class-name", LinkType.JAVA_SOURCE);
        linkMap.put("selector-class#name", LinkType.JAVA_SOURCE);
        linkMap.put("include#name", LinkType.JAVA_SOURCE);
        linkMap.put("exclude#name", LinkType.JAVA_SOURCE);
    }

    private static enum LinkType {
        RESOURCE,
        JAVA_SOURCE;

    }
}

