/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.createprojectapi;

import java.awt.EventQueue;
import java.io.IOException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectProperties;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class ClientSideProjectGenerator {
    private ClientSideProjectGenerator() {
    }

    @NonNull
    public static Project createProject(@NonNull CreateProjectProperties properties) throws IOException {
        String projectUrl;
        String startFile;
        String platformProvider;
        Parameters.notNull((CharSequence)"properties", (Object)properties);
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Cannot run in UI thread");
        }
        CommonProjectHelper h = ClientSideProjectUtilities.setupProject(properties.getProjectDir(), properties.getProjectName());
        Project project = FileOwnerQuery.getOwner((FileObject)h.getProjectDirectory());
        assert (project != null);
        ClientSideProject clientSideProject = (ClientSideProject)project.getLookup().lookup(ClientSideProject.class);
        if (clientSideProject == null) {
            throw new IllegalStateException("HTML5 project needed but found " + project.getClass().getName());
        }
        ClientSideProjectUtilities.initializeProject(clientSideProject, properties.getSourceFolder(), properties.getSiteRootFolder(), properties.getTestFolder(), properties.getTestSeleniumFolder());
        String jsTestingProvider = properties.getJsTestingProvider();
        if (jsTestingProvider != null) {
            ClientSideProjectUtilities.setJsTestingProvider(project, jsTestingProvider);
        }
        if ((platformProvider = properties.getPlatformProvider()) != null) {
            ClientSideProjectUtilities.setPlatformProvider(project, platformProvider);
        }
        ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(clientSideProject);
        boolean autoconfigured = properties.isAutoconfigured();
        if (autoconfigured) {
            projectProperties.setAutoconfigured(true);
        }
        if ((startFile = properties.getStartFile()) != null) {
            projectProperties.setStartFile(startFile);
        }
        if ((projectUrl = properties.getProjectUrl()) != null) {
            projectProperties.setProjectUrl(projectUrl);
        }
        projectProperties.save();
        String siteRoot = properties.getSiteRootFolder();
        ClientSideProjectUtilities.logUsageProjectCreate(autoconfigured, null, siteRoot == null ? null : Boolean.valueOf(!siteRoot.startsWith("../")), siteRoot == null, platformProvider, autoconfigured);
        return project;
    }
}

