/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallDescriptor;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class CallNode
extends AbstractNode {
    private String htmlDisplayName;

    private CallNode() {
        super(Children.LEAF);
    }

    private CallNode(Children children, CallDescriptor desc) {
        super(children, Lookups.singleton((Object)desc));
        this.setDisplayName(desc.getDisplayName());
    }

    void setHtmlDisplayName(String s) {
        this.htmlDisplayName = s;
    }

    public static CallNode createDefault() {
        CallNode node = new CallNode();
        node.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Default.displayName"));
        return node;
    }

    public static CallNode createPleaseWait() {
        CallNode node = new CallNode();
        node.setIconBaseWithExtension("org/netbeans/modules/java/navigation/resources/wait.gif");
        node.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.PleaseWait.displayName"));
        return node;
    }

    private static CallNode createCanceled() {
        CallNode node = new CallNode();
        node.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Canceled.displayName"));
        return node;
    }

    private static CallNode createIncomplete() {
        CallNode node = new CallNode();
        node.setHtmlDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Incomplete.htmlDisplayName"));
        node.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Incomplete.displayName"));
        node.setIconBaseWithExtension("org/netbeans/modules/java/navigation/resources/wait.gif");
        return node;
    }

    private static CallNode createBroken() {
        CallNode node = new CallNode();
        node.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Broken.displayName"));
        return node;
    }

    public static CallNode createCall(CallDescriptor desc) {
        CallNode node = new CallNode((Children)(desc.isLeaf() ? Children.LEAF : new CallChildren()), desc);
        return node;
    }

    public static Node createRoot(CallHierarchyModel model) {
        Call root = null;
        if (model != null) {
            root = model.getRoot();
        }
        if (root == null) {
            return CallNode.createDefault();
        }
        if (root.isBroken()) {
            return CallNode.createBroken();
        }
        if (root.isCanceled()) {
            return CallNode.createCanceled();
        }
        if (root.isIncomplete()) {
            return CallNode.createPleaseWait();
        }
        return CallNode.createCall(root);
    }

    public Image getIcon(int type) {
        CallDescriptor desc = (CallDescriptor)this.getLookup().lookup(CallDescriptor.class);
        Icon icon = desc != null ? desc.getIcon() : null;
        return icon != null ? ImageUtilities.icon2Image((Icon)icon) : super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName != null) {
            return this.htmlDisplayName;
        }
        CallDescriptor desc = (CallDescriptor)this.getLookup().lookup(CallDescriptor.class);
        String htmlDisplayName = desc != null ? desc.getHtmlDisplayName() : null;
        return htmlDisplayName != null ? htmlDisplayName : super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean context) {
        CallDescriptor desc = (CallDescriptor)this.getLookup().lookup(CallDescriptor.class);
        if (!(desc == null || desc instanceof Call && ((Call)desc).getOccurrences().isEmpty())) {
            return new Action[]{new GoToSourceAction(desc)};
        }
        return new Action[0];
    }

    public Action getPreferredAction() {
        Action[] actions;
        for (Action action : actions = this.getActions(true)) {
            if (!(action instanceof GoToSourceAction)) continue;
            return action;
        }
        return null;
    }

    private static final class GoToSourceAction
    extends AbstractAction {
        private CallDescriptor desc;

        public GoToSourceAction(CallDescriptor desc) {
            super(NbBundle.getMessage(GoToSourceAction.class, (String)"GoToSourceAction.displayName"));
            this.desc = desc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.desc.open();
        }
    }

    static final class CallChildren
    extends Children.Keys<Object>
    implements Runnable {
        private final boolean isOccurrenceView;
        private final AtomicInteger state = new AtomicInteger(0);

        public CallChildren() {
            this(false);
        }

        public CallChildren(boolean isOccurrenceView) {
            this.isOccurrenceView = isOccurrenceView;
        }

        protected void addNotify() {
            Call desc;
            super.addNotify();
            Node parent = this.getNode();
            Call call = desc = parent != null ? (Call)parent.getLookup().lookup(Call.class) : null;
            if (desc == null) {
                return;
            }
            if (this.isOccurrenceView) {
                this.setKeys(desc.getOccurrences());
            } else {
                this.setKeys(new Node[]{CallNode.createPleaseWait()});
                this.state.set(0);
                desc.getModel().computeCalls(desc, this);
            }
        }

        protected Node[] createNodes(Object key) {
            Object node = null;
            if (key instanceof Node) {
                node = (Node)key;
            } else if (key instanceof CallDescriptor) {
                node = CallNode.createCall((CallDescriptor)key);
            } else {
                return null;
            }
            return new Node[]{node};
        }

        @Override
        public void run() {
            List<Object> keys;
            if (this.state.incrementAndGet() == 1) {
                Children.MUTEX.writeAccess((Runnable)this);
                return;
            }
            Node parent = this.getNode();
            Call desc = (Call)parent.getLookup().lookup(Call.class);
            if (desc == null) {
                keys = Collections.emptyList();
            } else {
                keys = desc.getReferences();
                ArrayList<Object> temp = null;
                if (!this.isOccurrenceView && (desc.isCanceled() || desc.isBroken())) {
                    temp = new ArrayList<Object>(keys.size() + 2);
                    temp.addAll(keys);
                    temp.add((Object)(desc.isBroken() ? CallNode.createBroken() : CallNode.createCanceled()));
                    keys = temp;
                }
                if (desc.isIncomplete()) {
                    if (temp == null) {
                        temp = new ArrayList(keys.size() + 1);
                        temp.add((Object)CallNode.createIncomplete());
                        temp.addAll(keys);
                    } else {
                        temp.add(0, (Object)CallNode.createIncomplete());
                    }
                    keys = temp;
                }
            }
            this.setKeys(keys);
        }
    }
}

