/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.Bundle;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.actions.ActionToTaskUtils;
import org.netbeans.modules.gradle.actions.KeyValueTableModel;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.customizer.CustomActionMapping;
import org.netbeans.modules.gradle.execute.GradleExecutorOptionsPanel;
import org.netbeans.modules.gradle.spi.actions.AfterBuildActionHook;
import org.netbeans.modules.gradle.spi.actions.BeforeBuildActionHook;
import org.netbeans.modules.gradle.spi.actions.BeforeReloadActionHook;
import org.netbeans.modules.gradle.spi.actions.GradleActionsProvider;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.OutputWriter;

public class ActionProviderImpl
implements ActionProvider {
    private static final RequestProcessor RP = new RequestProcessor(ActionProviderImpl.class.getName(), 3);
    private static final Logger LOG = Logger.getLogger(ActionProviderImpl.class.getName());
    public static final String COMMAND_DL_SOURCES = "download.sources";
    public static final String COMMAND_DL_JAVADOC = "download.javadoc";
    public static final String COMMAND_DL_SOURCES_JAVADOC = "download.sourcesanddoc";
    private static final Pattern INPUT_PROP_REGEXP = Pattern.compile("\\$\\{input:([ \\w]+)(,([^\\}]+))?\\}");
    private final Project project;

    public ActionProviderImpl(Project project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        List<? extends GradleActionsProvider> providers = ActionToTaskUtils.actionProviders(this.project);
        HashSet<String> actions = new HashSet<String>();
        for (GradleActionsProvider gradleActionsProvider : providers) {
            actions.addAll(gradleActionsProvider.getSupportedActions());
        }
        return actions.toArray(new String[actions.size()]);
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        ActionMapping mapping = ActionToTaskUtils.getActiveMapping(command, this.project);
        ActionProviderImpl.invokeProjectAction(this.project, mapping, context, false);
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            GradleBaseProject gbp = GradleBaseProject.get(this.project);
            return gbp != null && gbp.getSubProjects().isEmpty() && ProjectOperations.isDeleteOperationSupported((Project)this.project);
        }
        return ActionToTaskUtils.isActionEnabled(command, this.project, context);
    }

    static String taskName(Project project, String action, Lookup lkp) {
        String title;
        DataObject dobj = (DataObject)lkp.lookup(DataObject.class);
        String dobjName = dobj != null ? dobj.getName() : "";
        Project prj = project != null ? project : (Project)lkp.lookup(Project.class);
        String prjLabel = prj != null ? ProjectUtils.getInformation((Project)prj).getDisplayName() : "No Project on Lookup";
        switch (action) {
            case "run": {
                title = Bundle.TXT_Run(prjLabel);
                break;
            }
            case "debug": {
                title = Bundle.TXT_Debug(prjLabel);
                break;
            }
            case "delete": {
                title = Bundle.TXT_Delete(prjLabel);
                break;
            }
            case "profile": {
                title = Bundle.TXT_Profile(prjLabel);
                break;
            }
            case "test": {
                title = Bundle.TXT_Test(prjLabel);
                break;
            }
            case "run.single": {
                title = Bundle.TXT_Run(dobjName);
                break;
            }
            case "debug.single": 
            case "debug.test.single": {
                title = Bundle.TXT_Debug(dobjName);
                break;
            }
            case "profile.single": 
            case "profile.test.single": {
                title = Bundle.TXT_Profile(dobjName);
                break;
            }
            case "test.single": {
                title = Bundle.TXT_Test(dobjName);
                break;
            }
            case "debug.fix": {
                title = Bundle.TXT_ApplyCodeChanges(prjLabel);
                break;
            }
            default: {
                title = Bundle.TXT_Build(prjLabel);
            }
        }
        return title;
    }

    private static void invokeProjectAction(Project project, ActionMapping mapping, Lookup context, boolean showUI) {
        boolean needReload;
        boolean reloadOnly;
        String action = mapping.getName();
        String argLine = ActionProviderImpl.askInputArgs(mapping.getDisplayName(), mapping.getArgs());
        if (argLine == null) {
            return;
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        Lookup ctx = ((BeforeBuildActionHook)project.getLookup().lookup(BeforeBuildActionHook.class)).beforeAction(action, context, out);
        NbGradleProjectImpl prj = (NbGradleProjectImpl)project.getLookup().lookup(NbGradleProjectImpl.class);
        String[] args = RunUtils.evaluateActionArgs(project, action, argLine, ctx);
        EnumSet<RunConfig.ExecFlag> flags = mapping.isRepeatable() ? EnumSet.of(RunConfig.ExecFlag.REPEATABLE) : EnumSet.noneOf(RunConfig.ExecFlag.class);
        RunConfig cfg = RunUtils.createRunConfig(project, action, ActionProviderImpl.taskName(project, action, ctx), flags, args);
        if (showUI) {
            GradleExecutorOptionsPanel pnl = new GradleExecutorOptionsPanel(project);
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Run_Gradle());
            pnl.setCommandLine(cfg.getCommandLine());
            Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retValue == DialogDescriptor.OK_OPTION) {
                pnl.rememberAs();
                cfg = cfg.withCommandLine(pnl.getCommandLine());
            } else {
                return;
            }
        }
        boolean bl = reloadOnly = !showUI && args.length == 0;
        if (!reloadOnly) {
            ProjectTrust.getDefault().trustProject(project);
        }
        NbGradleProject.Quality maxQualily = cfg.getCommandLine().hasFlag(GradleCommandLine.Flag.OFFLINE) && mapping.getReloadRule() != ActionMapping.ReloadRule.ALWAYS_ONLINE ? NbGradleProject.Quality.FULL : NbGradleProject.Quality.FULL_ONLINE;
        switch (mapping.getReloadRule()) {
            case ALWAYS_ONLINE: 
            case ALWAYS: {
                needReload = true;
                break;
            }
            case DEFAULT: {
                needReload = maxQualily.betterThan(prj.getGradleProject().getQuality());
                break;
            }
            default: {
                needReload = false;
            }
        }
        if (reloadOnly) {
            boolean canReload = ((BeforeReloadActionHook)project.getLookup().lookup(BeforeReloadActionHook.class)).beforeReload(action, ctx, 0, null);
            if (needReload && canReload) {
                String[] reloadArgs = RunUtils.evaluateActionArgs(project, mapping.getName(), mapping.getReloadArgs(), ctx);
                ActionProgress g = ActionProgress.start((Lookup)context);
                RequestProcessor.Task reloadTask = prj.reloadProject(true, maxQualily, reloadArgs);
                reloadTask.addTaskListener(t -> g.finished(true));
            }
        } else {
            ExecutorTask task = RunUtils.executeGradle(cfg, writer.toString());
            ActionProgress g = ActionProgress.start((Lookup)context);
            Lookup outerCtx = ctx;
            task.addTaskListener(t -> {
                try {
                    OutputWriter out1 = task.getInputOutput().getOut();
                    boolean canReload = ((BeforeReloadActionHook)project.getLookup().lookup(BeforeReloadActionHook.class)).beforeReload(action, outerCtx, task.result(), (PrintWriter)out1);
                    if (needReload && canReload) {
                        String[] reloadArgs = RunUtils.evaluateActionArgs(project, mapping.getName(), mapping.getReloadArgs(), outerCtx);
                        RequestProcessor.Task reloadTask = prj.reloadProject(true, maxQualily, reloadArgs);
                        reloadTask.waitFinished();
                    }
                    ((AfterBuildActionHook)project.getLookup().lookup(AfterBuildActionHook.class)).afterAction(action, outerCtx, task.result(), (PrintWriter)out1);
                    for (AfterBuildActionHook l : context.lookupAll(AfterBuildActionHook.class)) {
                        l.afterAction(action, outerCtx, task.result(), (PrintWriter)out1);
                    }
                }
                catch (Throwable throwable) {
                    task.getInputOutput().getOut().close();
                    task.getInputOutput().getErr().close();
                    g.finished(task.result() == 0);
                    throw throwable;
                }
                task.getInputOutput().getOut().close();
                task.getInputOutput().getErr().close();
                g.finished(task.result() == 0);
            });
        }
    }

    public static Action createCustomGradleAction(Project project, String name, ActionMapping mapping, Lookup context, boolean showUI) {
        return new CustomAction(project, name, mapping, context, showUI);
    }

    public static Action createCustomGradleAction(Project project, String name, String command, Lookup context, boolean showUI) {
        ActionMapping mapping = ActionToTaskUtils.getActiveMapping(command, project);
        return new CustomAction(project, name, mapping, context, showUI);
    }

    public static Action createCustomGradleAction(Project project, String name, String command, Lookup context) {
        return ActionProviderImpl.createCustomGradleAction(project, name, command, context, false);
    }

    public static Action createCustomGradleAction(Project project, String name, String command) {
        return ActionProviderImpl.createCustomGradleAction(project, name, command, Lookup.EMPTY, false);
    }

    public static ContextAwareAction customPopupActions() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(Project p, FileObject fo) {
                CustomPopupActions customPopupActions;
                ActionProviderImpl ap = (ActionProviderImpl)p.getLookup().lookup(ActionProviderImpl.class);
                if (ap != null) {
                    ActionProviderImpl actionProviderImpl = ap;
                    actionProviderImpl.getClass();
                    customPopupActions = actionProviderImpl.new CustomPopupActions(this.triggeredOnFile, this.triggeredOnGradle, fo);
                } else {
                    customPopupActions = null;
                }
                return customPopupActions;
            }
        };
    }

    private static String askInputArgs(String command, String argLine) {
        Matcher m = INPUT_PROP_REGEXP.matcher(argLine);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> defaults = new ArrayList<String>();
        while (m.find()) {
            keys.add(m.group(1));
            defaults.add(m.group(3) != null ? m.group(3) : "");
        }
        String ret = argLine;
        if (!keys.isEmpty()) {
            KeyValueTableModel kvModel = new KeyValueTableModel("input:", keys.toArray(new String[keys.size()]), defaults.toArray(new String[defaults.size()]));
            JPanel panel = new JPanel(new BorderLayout());
            JTable table = new JTable(kvModel);
            table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            table.setRowHeight(table.getRowHeight() * 3 / 2);
            panel.add((Component)new JScrollPane(table), "Center");
            try {
                DefaultCellEditor defaultEditor = (DefaultCellEditor)table.getDefaultEditor(String.class);
                defaultEditor.setClickCountToStart(1);
            }
            catch (ClassCastException defaultEditor) {
                // empty catch block
            }
            DialogDescriptor dlg = new DialogDescriptor((Object)panel, Bundle.TIT_BuildParameters(command));
            ret = DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg) ? ReplaceTokenProvider.replaceTokens(argLine, kvModel.getProperties()) : null;
        }
        return ret;
    }

    private final class CustomPopupActions
    extends AbstractAction
    implements Presenter.Popup {
        private final boolean onFile;
        private final boolean onGradle;
        private final Lookup lookup;

        private CustomPopupActions(boolean onFile, boolean onGradleFile, FileObject fo) {
            this.putValue("Name", onFile ? Bundle.LBL_Custom_Run_File() : Bundle.LBL_Custom_Run());
            this.onFile = onFile;
            this.onGradle = onGradleFile;
            this.lookup = fo != null ? Lookups.singleton((Object)fo) : Lookup.EMPTY;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            final JMenu menu = new JMenu(this.onFile ? Bundle.LBL_Custom_Run_File() : Bundle.LBL_Custom_Run());
            final JMenuItem loading = new JMenuItem(Bundle.LBL_Loading_tasks());
            menu.add(loading);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ProjectActionMappingProvider provider = (ProjectActionMappingProvider)ActionProviderImpl.this.project.getLookup().lookup(ProjectActionMappingProvider.class);
                    ArrayList<Action> acts = new ArrayList<Action>();
                    for (String action : provider.customizedActions()) {
                        if (!action.startsWith("custom-")) continue;
                        ActionMapping mapp = provider.findMapping(action);
                        Action act = ActionProviderImpl.createCustomGradleAction(ActionProviderImpl.this.project, mapp.getName(), mapp, CustomPopupActions.this.lookup, false);
                        String displayName = INPUT_PROP_REGEXP.matcher(mapp.getArgs()).find() ? mapp.getDisplayName() + "..." : mapp.getDisplayName();
                        act.putValue("Name", displayName);
                        acts.add(act);
                    }
                    acts.add(ActionProviderImpl.createCustomGradleAction(ActionProviderImpl.this.project, Bundle.LBL_Custom_run_tasks(), new CustomActionMapping("name"), CustomPopupActions.this.lookup, true));
                    SwingUtilities.invokeLater(() -> {
                        boolean selected = menu.isSelected();
                        menu.remove(loading);
                        for (Action a : acts) {
                            menu.add(new JMenuItem(a));
                        }
                        menu.getPopupMenu().pack();
                        menu.repaint();
                        menu.updateUI();
                        menu.setSelected(selected);
                    });
                }
            }, 100);
            return menu;
        }
    }

    private static abstract class ConditionallyShownAction
    extends AbstractAction
    implements ContextAwareAction {
        protected boolean triggeredOnFile = false;
        protected boolean triggeredOnGradle = false;

        protected ConditionallyShownAction() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            assert (false);
        }

        protected abstract Action forProject(@NonNull Project var1, @NullAllowed FileObject var2);

        public final Action createContextAwareInstance(Lookup actionContext) {
            this.triggeredOnFile = false;
            this.triggeredOnGradle = false;
            Collection projects = actionContext.lookupAll(Project.class);
            if (projects.size() != 1) {
                Collection fobs = actionContext.lookupAll(FileObject.class);
                if (fobs.size() == 1) {
                    FileObject fo = (FileObject)fobs.iterator().next();
                    if ("build.gradle".equals(fo.getNameExt())) {
                        Project p = null;
                        FileObject parent = fo.getParent();
                        for (Project prj : projects) {
                            if (!prj.getProjectDirectory().equals(parent)) continue;
                            p = prj;
                            break;
                        }
                        if (p == null) {
                            p = FileOwnerQuery.getOwner((FileObject)fo);
                        }
                        if (p != null) {
                            this.triggeredOnFile = true;
                            this.triggeredOnGradle = true;
                            Action a = this.forProject(p, null);
                            return a != null ? a : this;
                        }
                    } else {
                        Project p = this.findOwner(projects, fo);
                        if (p == null) {
                            p = FileOwnerQuery.getOwner((FileObject)fo);
                        }
                        if (p != null) {
                            this.triggeredOnFile = true;
                            Action a = this.forProject(p, fo);
                            return a != null ? a : this;
                        }
                    }
                }
                return this;
            }
            Action a = this.forProject((Project)projects.iterator().next(), null);
            return a != null ? a : this;
        }

        private Project findOwner(Collection<? extends Project> projects, FileObject fo) {
            FileObject parent = fo.getParent();
            if (parent == null) {
                return null;
            }
            for (Project project : projects) {
                if (!project.getProjectDirectory().equals(fo.getParent())) continue;
                return project;
            }
            return null;
        }
    }

    private static final class CustomAction
    extends AbstractAction {
        private final ActionMapping mapping;
        private final boolean showUI;
        private final Lookup context;
        private final Project project;

        private CustomAction(Project project, String name, ActionMapping mapping, Lookup context, boolean showUI) {
            super(name);
            this.mapping = mapping;
            this.showUI = showUI;
            this.context = new ProxyLookup(new Lookup[]{context, Lookups.singleton((Object)this)});
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionProviderImpl.invokeProjectAction(this.project, this.mapping, this.context, this.showUI);
        }
    }
}

