/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.cache;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.gradle.tooling.model.GradleProject;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.cache.AbstractDiskCache;
import org.netbeans.modules.gradle.spi.GradleFiles;

public class SubProjectDiskCache
extends AbstractDiskCache<File, SubProjectInfo> {
    private static final String SUBPROJECT_CACHE_FILE_NAME = ".gradle/nb-cache/subprojects.ser";
    private static final int COMPATIBLE_CACHE_VERSION = 1;
    private static Map<File, SubProjectDiskCache> diskCaches = new WeakHashMap<File, SubProjectDiskCache>();

    protected SubProjectDiskCache() {
    }

    private SubProjectDiskCache(File key) {
        super(key);
    }

    @Override
    protected int cacheVersion() {
        return 1;
    }

    @Override
    protected File cacheFile() {
        return new File((File)this.key, SUBPROJECT_CACHE_FILE_NAME);
    }

    @Override
    protected Set<File> cacheInvalidators() {
        return Collections.singleton(new GradleFiles((File)this.key).getSettingsScript());
    }

    public static SubProjectDiskCache get(File key) {
        SubProjectDiskCache ret = diskCaches.get(key);
        if (ret == null) {
            ret = new SubProjectDiskCache(key);
            diskCaches.put(key, ret);
        }
        return ret;
    }

    public static final class SubProjectInfo
    implements Serializable {
        String rootProjectName;
        Map<String, String> path2Name;
        Map<File, String> file2Path;

        protected SubProjectInfo() {
        }

        public SubProjectInfo(GradleProject prj) {
            assert (prj.getParent() == null) : "This shall be called only on a root project!";
            this.rootProjectName = prj.getName();
            this.path2Name = new HashMap<String, String>();
            this.file2Path = new HashMap<File, String>();
            for (GradleProject child : prj.getChildren()) {
                this.path2Name.put(child.getPath(), child.getName());
                File dir = child.getProjectDirectory();
                if (!dir.isAbsolute()) {
                    dir = new File(prj.getProjectDirectory(), dir.toString());
                }
                this.file2Path.put(dir, child.getPath());
            }
        }

        public SubProjectInfo(GradleBaseProject gbp) {
            assert (gbp.isRoot()) : "This shall be called only on a root project!";
            this.rootProjectName = gbp.getName();
            this.path2Name = new HashMap<String, String>();
            this.file2Path = new HashMap<File, String>();
            for (Map.Entry<String, File> sprj : gbp.getSubProjects().entrySet()) {
                this.file2Path.put(sprj.getValue(), sprj.getKey());
                this.path2Name.put(sprj.getKey(), sprj.getKey());
            }
        }

        public String gerRootProjectName() {
            return this.rootProjectName;
        }

        public String getProjectName(String path) {
            return this.path2Name.get(path);
        }

        public String getProjectName(File dir) {
            String path = this.file2Path.get(dir);
            return path != null ? this.path2Name.get(path) : null;
        }

        public String getProjectPath(File dir) {
            return this.file2Path.get(dir);
        }

        public boolean isSubproject(File dir) {
            return this.file2Path.containsKey(dir);
        }

        public String toString() {
            return "SubProjects of [" + this.rootProjectName + "]: " + this.file2Path.keySet();
        }
    }
}

