/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.newproject;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.gradle.newproject.Bundle;
import org.netbeans.modules.gradle.newproject.ProjectAttriburesPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class ProjectAttributesPanelVisual
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    private static final String PROP_CHANGED_PKG = "changedPackageBase";
    final ProjectAttriburesPanel panel;
    private boolean changedPackageBase = false;
    private JButton btBrowse;
    private JCheckBox cbInitWrapper;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel lbDescription;
    private JLabel lbGroup;
    private JLabel lbPackageBase;
    private JLabel lbProjectFolder;
    private JLabel lbProjectLocation;
    private JLabel lbProjectName;
    private JLabel lbVersion;
    JPanel pnlExtraSpace;
    private JTextField tfDescription;
    private JTextField tfGroup;
    private JTextField tfPackageBase;
    private JTextField tfProjectFolder;
    private JTextField tfProjectLocation;
    private JTextField tfProjectName;
    private JTextField tfVersion;

    public ProjectAttributesPanelVisual(ProjectAttriburesPanel panel, Component bottomComponent) {
        this.panel = panel;
        this.initComponents();
        if (bottomComponent != null) {
            this.pnlExtraSpace.add(bottomComponent);
        }
        this.tfProjectName.getDocument().addDocumentListener(this);
        this.tfProjectLocation.getDocument().addDocumentListener(this);
        this.tfGroup.getDocument().addDocumentListener(this);
        this.tfPackageBase.getDocument().addDocumentListener(this);
    }

    @Override
    public String getName() {
        return Bundle.NameAndLocationPanel();
    }

    public void setProjectName(String name) {
        this.tfProjectName.setText(name);
    }

    public String getProjectName() {
        return this.tfProjectName.getText();
    }

    private void initComponents() {
        this.lbProjectName = new JLabel();
        this.lbProjectLocation = new JLabel();
        this.lbProjectFolder = new JLabel();
        this.tfProjectName = new JTextField();
        this.tfProjectLocation = new JTextField();
        this.tfProjectFolder = new JTextField();
        this.btBrowse = new JButton();
        this.tfDescription = new JTextField();
        this.tfGroup = new JTextField();
        this.tfVersion = new JTextField();
        this.tfPackageBase = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.lbDescription = new JLabel();
        this.lbGroup = new JLabel();
        this.lbVersion = new JLabel();
        this.lbPackageBase = new JLabel();
        this.pnlExtraSpace = new JPanel();
        this.cbInitWrapper = new JCheckBox();
        this.lbProjectName.setLabelFor(this.lbProjectName);
        Mnemonics.setLocalizedText((JLabel)this.lbProjectName, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.lbProjectName.text"));
        this.lbProjectLocation.setLabelFor(this.tfProjectLocation);
        Mnemonics.setLocalizedText((JLabel)this.lbProjectLocation, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.lbProjectLocation.text"));
        this.lbProjectFolder.setLabelFor(this.tfProjectFolder);
        Mnemonics.setLocalizedText((JLabel)this.lbProjectFolder, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.lbProjectFolder.text"));
        this.tfProjectFolder.setText(NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.tfProjectFolder.text"));
        this.tfProjectFolder.setEnabled(false);
        this.tfProjectFolder.setFocusable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btBrowse, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.btBrowse.text"));
        this.btBrowse.setActionCommand("BROWSE");
        this.btBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectAttributesPanelVisual.this.btBrowseActionPerformed(evt);
            }
        });
        this.tfVersion.setToolTipText(NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.tfVersion.toolTipText"));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"LBL_optional"));
        this.jLabel1.setEnabled(false);
        this.jLabel2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"LBL_optional"));
        this.jLabel2.setEnabled(false);
        this.jLabel3.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"LBL_optional"));
        this.jLabel3.setEnabled(false);
        this.jLabel4.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"LBL_optional"));
        this.jLabel4.setEnabled(false);
        this.lbDescription.setLabelFor(this.tfDescription);
        Mnemonics.setLocalizedText((JLabel)this.lbDescription, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.lbDescription.text"));
        this.lbGroup.setLabelFor(this.tfGroup);
        Mnemonics.setLocalizedText((JLabel)this.lbGroup, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.lbGroup.text"));
        this.lbVersion.setLabelFor(this.tfVersion);
        Mnemonics.setLocalizedText((JLabel)this.lbVersion, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.lbVersion.text"));
        this.lbPackageBase.setLabelFor(this.tfPackageBase);
        Mnemonics.setLocalizedText((JLabel)this.lbPackageBase, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.lbPackageBase.text"));
        this.pnlExtraSpace.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbInitWrapper, (String)NbBundle.getMessage(ProjectAttributesPanelVisual.class, (String)"ProjectAttributesPanelVisual.cbInitWrapper.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlExtraSpace, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbProjectLocation, -1, -1, Short.MAX_VALUE).addComponent(this.lbProjectName, -1, -1, Short.MAX_VALUE).addComponent(this.lbPackageBase, -1, -1, Short.MAX_VALUE).addComponent(this.lbVersion, -1, -1, Short.MAX_VALUE).addComponent(this.lbGroup, -1, -1, Short.MAX_VALUE).addComponent(this.lbDescription, -1, -1, Short.MAX_VALUE).addComponent(this.lbProjectFolder, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfPackageBase, -1, 430, Short.MAX_VALUE).addComponent(this.tfGroup).addComponent(this.tfDescription).addComponent(this.tfProjectLocation).addComponent(this.tfProjectFolder).addComponent(this.tfVersion).addComponent(this.tfProjectName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btBrowse, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -2, 85, -2)).addComponent(this.jLabel3, -2, 85, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cbInitWrapper))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbProjectName).addComponent(this.tfProjectName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbProjectLocation).addComponent(this.tfProjectLocation, -2, -1, -2).addComponent(this.btBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbProjectFolder).addComponent(this.tfProjectFolder, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfDescription, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.lbDescription)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfGroup, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.lbGroup)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfVersion, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.lbVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfPackageBase, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.lbPackageBase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlExtraSpace, -1, 68, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbInitWrapper).addContainerGap()));
    }

    private void btBrowseActionPerformed(ActionEvent evt) {
        if ("BROWSE".equals(evt.getActionCommand())) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(null);
            chooser.setDialogTitle(Bundle.TIT_Select_Project_Location());
            chooser.setFileSelectionMode(1);
            String path = this.tfProjectLocation.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.tfProjectLocation.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTextFields(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTextFields(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTextFields(e);
    }

    private void updateTextFields(DocumentEvent e) {
        Document doc = e.getDocument();
        if (this.tfProjectName.getDocument() == doc || this.tfProjectLocation.getDocument() == doc) {
            File location = new File(this.tfProjectLocation.getText());
            if (location.isDirectory()) {
                this.tfProjectFolder.setText(this.tfProjectLocation.getText() + File.separator + this.tfProjectName.getText());
            } else {
                this.tfProjectFolder.setText(this.tfProjectLocation.getText());
            }
        }
        if (!(this.changedPackageBase || this.tfProjectName.getDocument() != doc && this.tfGroup.getDocument() != doc)) {
            String part1 = this.tfGroup.getText().trim();
            part1 = !part1.isEmpty() ? part1 + "." : part1;
            String part2 = this.tfProjectName.getText().trim().replaceAll(" ", "").replace('-', '.');
            this.tfPackageBase.getDocument().removeDocumentListener(this);
            this.tfPackageBase.setText(part1 + part2);
            this.tfPackageBase.getDocument().addDocumentListener(this);
        }
        if (this.tfPackageBase.getDocument() == doc) {
            boolean bl = this.changedPackageBase = !this.tfPackageBase.getText().trim().isEmpty();
        }
        if (this.tfProjectName.getDocument() == doc) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.tfProjectName.getText());
        }
    }

    void read(WizardDescriptor settings) {
        File loc = (File)settings.getProperty("projdir");
        if (loc == null || loc.getParentFile() == null || !loc.getParentFile().isDirectory()) {
            loc = ProjectChooser.getProjectsFolder();
        }
        this.tfProjectLocation.setText(loc.getAbsolutePath());
        String name = (String)settings.getProperty("name");
        name = name != null ? name : ProjectAttributesPanelVisual.firstAvailableName(loc, "gradleproject");
        this.tfProjectName.setText(name);
        ProjectAttributesPanelVisual.setText(this.tfGroup, settings, "group");
        ProjectAttributesPanelVisual.setText(this.tfVersion, settings, "version");
        ProjectAttributesPanelVisual.setText(this.tfDescription, settings, "description");
        ProjectAttributesPanelVisual.setText(this.tfPackageBase, settings, "packageBase");
        Boolean initWrapper = (Boolean)settings.getProperty("initWrapper");
        this.cbInitWrapper.setSelected(initWrapper != null ? initWrapper : true);
        Boolean changedPkg = (Boolean)settings.getProperty(PROP_CHANGED_PKG);
        this.changedPackageBase = changedPkg == null ? false : changedPkg;
        this.tfProjectName.selectAll();
    }

    void write(WizardDescriptor settings) {
        File projectFolder = new File(this.tfProjectLocation.getText());
        ProjectChooser.setProjectsFolder((File)projectFolder);
        settings.putProperty("projdir", (Object)projectFolder);
        settings.putProperty("name", (Object)this.tfProjectName.getText());
        settings.putProperty("group", (Object)this.tfGroup.getText());
        settings.putProperty("version", (Object)this.tfVersion.getText());
        settings.putProperty("description", (Object)this.tfDescription.getText());
        settings.putProperty("packageBase", (Object)this.tfPackageBase.getText());
        settings.putProperty(PROP_CHANGED_PKG, (Object)this.changedPackageBase);
        settings.putProperty("initWrapper", (Object)this.cbInitWrapper.isSelected());
    }

    private static void setText(JTextComponent c, WizardDescriptor settings, String prop) {
        String value = (String)settings.getProperty(prop);
        if (value != null) {
            c.setText(value);
        }
    }

    private static String firstAvailableName(File dir, String baseName) {
        String name;
        File folder;
        int index = 1;
        while ((folder = new File(dir, name = baseName + String.valueOf(index++))).exists()) {
        }
        return name;
    }
}

