/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.actions;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Parameters;

public final class TestMethodUtil {
    private static final String GROOVY_PARSER_RESULT_CLASS_NAME = "org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult";
    private static final String GPR_GET_ROOT_ELEMENT = "getRootElement";
    private static final String AST_GET_MODULE_NODE = "getModuleNode";

    static boolean isTestClass(Node activatedNode) {
        FileObject fo = TestMethodUtil.getFileObjectFromNode(activatedNode);
        if (fo != null) {
            return TestMethodUtil.isGroovyFile(fo);
        }
        return false;
    }

    public static int[] getLineAndColumn(String srcText, int cursor) {
        Parameters.notNull((CharSequence)"srcText", (Object)srcText);
        Parameters.notEmpty((CharSequence)"srcText", (CharSequence)srcText);
        int[] ret = new int[]{-1, -1};
        if (cursor > 0) {
            try {
                String line;
                StringReader sr = new StringReader(srcText);
                LineNumberReader lr = new LineNumberReader(sr);
                int counter = 0;
                while ((line = lr.readLine()) != null) {
                    if ((counter += line.length()) >= cursor) {
                        ret[0] = lr.getLineNumber();
                        ret[1] = cursor - (counter - line.length()) + 1;
                    }
                    ++counter;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else if (cursor == 0) {
            ret[0] = 1;
            ret[1] = 1;
        }
        return ret;
    }

    public static boolean isBetweenLinesAndColumns(int startLine, int startCol, int endLine, int endCol, int line, int col) {
        boolean ret = false;
        if (line >= startLine && line <= endLine) {
            ret = true;
            if (line == startLine && col < startCol) {
                ret = false;
            }
            if (line == endLine && col > endCol) {
                ret = false;
            }
        }
        return ret;
    }

    public static ModuleNode extractModuleNode(Parser.Result r) {
        ModuleNode ret = null;
        try {
            Method getRE = r.getClass().getMethod(GPR_GET_ROOT_ELEMENT, new Class[0]);
            Object astRoot = getRE.invoke((Object)r, new Object[0]);
            if (astRoot != null) {
                ModuleNode lmn;
                Method getMN = astRoot.getClass().getMethod(AST_GET_MODULE_NODE, new Class[0]);
                ret = lmn = (ModuleNode)ModuleNode.class.cast(getMN.invoke(astRoot, new Object[0]));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("The given result doesn't appear to come from parsing a Groovy file.", e);
        }
        return ret;
    }

    public static ClassNode getClassNodeForLineAndColumn(ModuleNode root, int line, int col) {
        ClassNode ret = null;
        if (root != null) {
            List classes = root.getClasses();
            for (ClassNode cn : classes) {
                if (!TestMethodUtil.isBetweenLinesAndColumns(cn.getLineNumber(), cn.getColumnNumber(), cn.getLastLineNumber(), cn.getLastColumnNumber(), line, col)) continue;
                return cn;
            }
        }
        return ret;
    }

    public static MethodNode getMethodNodeForLineAndColumn(ClassNode cn, int line, int col) {
        MethodNode ret = null;
        if (cn != null) {
            List methods = cn.getMethods();
            for (MethodNode mn : methods) {
                if (!TestMethodUtil.isBetweenLinesAndColumns(mn.getLineNumber(), mn.getColumnNumber(), mn.getLastLineNumber(), mn.getLastColumnNumber(), line, col)) continue;
                return mn;
            }
        }
        return ret;
    }

    public static SingleMethod getTestMethod(final Document doc, final int cursor) {
        final AtomicReference sm = new AtomicReference();
        if (doc != null) {
            final Source s = Source.create((Document)doc);
            try {
                ParserManager.parseWhenScanFinished(Collections.singleton(s), (UserTask)new UserTask(){

                    public void run(ResultIterator rit) throws Exception {
                        Parser.Result r = rit.getParserResult();
                        int[] lc = TestMethodUtil.getLineAndColumn(doc.getText(0, doc.getLength()), cursor);
                        int line = lc[0];
                        int col = lc[1];
                        ModuleNode root = TestMethodUtil.extractModuleNode(r);
                        ClassNode cn = TestMethodUtil.getClassNodeForLineAndColumn(root, line, col);
                        MethodNode mn = TestMethodUtil.getMethodNodeForLineAndColumn(cn, line, col);
                        if (mn != null) {
                            SingleMethod lsm = new SingleMethod(s.getFileObject(), mn.getName());
                            sm.set(lsm);
                        }
                    }
                });
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return (SingleMethod)sm.get();
    }

    static boolean canHandle(Node activatedNode) {
        FileObject fo = TestMethodUtil.getFileObjectFromNode(activatedNode);
        if (fo != null) {
            if (!TestMethodUtil.isGroovyFile(fo)) {
                return false;
            }
            EditorCookie ec = (EditorCookie)activatedNode.getLookup().lookup(EditorCookie.class);
            if (ec != null) {
                SingleMethod sm;
                AtomicReference doc = new AtomicReference();
                AtomicInteger dot = new AtomicInteger();
                try {
                    EventQueue.invokeAndWait(() -> {
                        JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
                        if (pane != null) {
                            doc.set(pane.getDocument());
                            dot.set(pane.getCaret().getDot());
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                if (doc.get() != null && (sm = TestMethodUtil.getTestMethod((Document)doc.get(), dot.get())) != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dO = (DataObject)node.getLookup().lookup(DataObject.class);
        if (null != dO) {
            return dO.getPrimaryFile();
        }
        DataFolder df = (DataFolder)node.getLookup().lookup(DataFolder.class);
        if (null != df) {
            return df.getPrimaryFile();
        }
        return null;
    }

    private static boolean isGroovyFile(FileObject fileObj) {
        String ext = fileObj.getExt();
        String mtype = FileUtil.getMIMEType((FileObject)fileObj);
        return "groovy".equals(ext) || "text/x-groovy".equals(mtype);
    }
}

