/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.api.model;

import java.beans.FeatureDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.openide.ErrorManager;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class GrammarQueryManager {
    private static Reference<GrammarQueryManager> instance;

    public abstract Enumeration enabled(GrammarEnvironment var1);

    public abstract GrammarQuery getGrammar(GrammarEnvironment var1);

    public abstract FeatureDescriptor getDescriptor();

    public static synchronized GrammarQueryManager getDefault() {
        GrammarQueryManager cached;
        GrammarQueryManager grammarQueryManager = cached = instance != null ? instance.get() : null;
        if (cached == null) {
            cached = new DefaultQueryManager();
            instance = new WeakReference<GrammarQueryManager>(cached);
        }
        return cached;
    }

    private static class DefaultQueryManager
    extends GrammarQueryManager {
        private static final String FOLDER = "Plugins/XML/GrammarQueryManagers";
        private Lookup.Result registrations;
        private static ThreadLocal<GrammarQueryManager> transaction = new ThreadLocal();

        private DefaultQueryManager() {
        }

        @Override
        public FeatureDescriptor getDescriptor() {
            FeatureDescriptor desc = new FeatureDescriptor();
            desc.setHidden(true);
            desc.setName(this.getClass().getName());
            return desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GrammarQuery getGrammar(GrammarEnvironment ctx) {
            try {
                GrammarQueryManager g = transaction.get();
                if (g != null) {
                    Object err;
                    GrammarQuery query = g.getGrammar(ctx);
                    if (query == null) {
                        err = ErrorManager.getDefault();
                        err.log(16, "Broken contract: " + g.getClass());
                    }
                    err = query;
                    return err;
                }
                ErrorManager err = ErrorManager.getDefault();
                IllegalStateException ex = new IllegalStateException("Broken contract");
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                ex.printStackTrace(writer);
                writer.flush();
                err.log(16, stringWriter.getBuffer().toString());
                GrammarQuery grammarQuery = null;
                return grammarQuery;
            }
            finally {
                transaction.set(null);
            }
        }

        @Override
        public Enumeration enabled(GrammarEnvironment ctx) {
            Iterator it = this.getRegistrations();
            transaction.set(null);
            ArrayList list = new ArrayList(5);
            Enumeration en = ctx.getDocumentChildren();
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            Object[] array = list.toArray();
            while (it.hasNext()) {
                GrammarEnvironment env;
                GrammarQueryManager next = (GrammarQueryManager)it.next();
                Enumeration en2 = next.enabled(env = new GrammarEnvironment(Enumerations.array((Object[])array), ctx.getInputSource(), ctx.getFileObject()));
                if (en2 == null) continue;
                transaction.set(next);
                return en2;
            }
            return null;
        }

        private synchronized Iterator getRegistrations() {
            if (this.registrations != null) {
                return this.registrations.allInstances().iterator();
            }
            this.registrations = Lookups.forPath((String)FOLDER).lookupResult(GrammarQueryManager.class);
            return this.registrations.allInstances().iterator();
        }
    }
}

