/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.pattern;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tomcat.util.pattern.Entry;
import org.apache.tomcat.util.pattern.Implication;

public class ImplicationTable
extends Dictionary {
    private Vector table = new Vector();

    public int size() {
        return this.table.size();
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public Enumeration elements() {
        Vector<Object> tmp = new Vector<Object>();
        int i = 0;
        while (i < this.table.size()) {
            Entry e = (Entry)this.table.elementAt(i);
            tmp.addElement(e.value);
            ++i;
        }
        return tmp.elements();
    }

    public Enumeration keys() {
        return this.keys(null);
    }

    public Enumeration keys(Object key) {
        Vector<Object> tmp = new Vector<Object>();
        int i = 0;
        while (i < this.table.size()) {
            Entry e = (Entry)this.table.elementAt(i);
            if (key != null) {
                if (e.key instanceof Implication) {
                    if (((Implication)e.key).implies(key)) {
                        tmp.addElement(e.key);
                    }
                } else if (e.key.hashCode() == key.hashCode() && e.key.equals(key)) {
                    tmp.addElement(e.key);
                }
            } else {
                tmp.addElement(e.key);
            }
            ++i;
        }
        return tmp.elements();
    }

    public synchronized Object put(Object key, Object value) {
        Object val = this.remove(key);
        this.table.addElement(new Entry(key, value));
        return val;
    }

    public synchronized Object putValue(Object key, Object value) {
        return this.put(key, value);
    }

    public Object get(Object key) {
        int i = 0;
        while (i < this.table.size()) {
            Entry e = (Entry)this.table.elementAt(i);
            if (e.key instanceof Implication && ((Implication)e.key).implies(key)) {
                return e.value;
            }
            if (e.key.hashCode() == key.hashCode() && e.key.equals(key)) {
                return e.value;
            }
            ++i;
        }
        return null;
    }

    public Object getValue(Object key) {
        int indx = this.table.indexOf(key);
        if (indx != -1) {
            Entry e = (Entry)this.table.elementAt(indx);
            return e.value;
        }
        return null;
    }

    public synchronized Object remove(Object key) {
        Object val = this.getValue(key);
        if (val != null) {
            this.table.removeElement(key);
        }
        return val;
    }
}

