/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRoleRef;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EjbRefsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class SecurityRoleRefTablePanel
extends DefaultTablePanel {
    private SecurityRoleRefTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;
    private Servlet servlet;

    public SecurityRoleRefTablePanel(final DDDataObject dObj, final SecurityRoleRefTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.dObj = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dObj.modelUpdatedFromUI();
                dObj.setChangedFromUI(true);
                int row = SecurityRoleRefTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
                dObj.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, Servlet servlet, SecurityRoleRef[] roleRefs) {
        this.model.setData((CommonDDBean)servlet, (CommonDDBean[])roleRefs);
        this.model.setWebApp(webApp);
        this.webApp = webApp;
        this.servlet = servlet;
    }

    private boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int row = this.add ? -1 : SecurityRoleRefTablePanel.this.getTable().getSelectedRow();
            final SecurityRoleRefPanel dialogPanel = new SecurityRoleRefPanel(SecurityRoleRefTablePanel.this.webApp.getSecurityRole());
            if (!this.add) {
                SecurityRoleRef roleRef = SecurityRoleRefTablePanel.this.model.getSecurityRoleRef(row);
                dialogPanel.setRoleRefName(roleRef.getRoleName());
                dialogPanel.setRoleRefLink(roleRef.getRoleLink());
                dialogPanel.setDescription(roleRef.getDefaultDescription());
            }
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(EjbRefsTablePanel.class, (String)"TTL_SecurityRoleRef"), this.add){

                protected String validate() {
                    String name = dialogPanel.getRoleRefName().trim();
                    SecurityRoleRef roleRef = null;
                    if (row != -1) {
                        roleRef = SecurityRoleRefTablePanel.this.model.getSecurityRoleRef(row);
                    }
                    if (name.length() == 0) {
                        return NbBundle.getMessage(SecurityRoleRefTablePanel.class, (String)"TXT_EmptySecurityRoleRefName");
                    }
                    SecurityRoleRef[] roleRefs = SecurityRoleRefTablePanel.this.servlet.getSecurityRoleRef();
                    for (int i = 0; i < roleRefs.length; ++i) {
                        if (roleRefs[i] == roleRef || !name.equals(roleRefs[i].getRoleName())) continue;
                        return NbBundle.getMessage(SecurityRoleRefTablePanel.class, (String)"TXT_SecurityRoleRefNameExists", (Object)name);
                    }
                    if (SecurityRoleRefTablePanel.this.isEmpty(dialogPanel.getRoleRefLink())) {
                        return NbBundle.getMessage(SecurityRoleRefTablePanel.class, (String)"TXT_EmptySecurityRoleRefLink");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getRoleRefNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getDescriptionTA().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getRoleRefNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getDescriptionTA().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                SecurityRoleRefTablePanel.this.dObj.modelUpdatedFromUI();
                SecurityRoleRefTablePanel.this.dObj.setChangedFromUI(true);
                String roleRefName = dialogPanel.getRoleRefName();
                String roleRefLink = dialogPanel.getRoleRefLink();
                String description = dialogPanel.getDescription();
                if (this.add) {
                    SecurityRoleRefTablePanel.this.model.addRow(new String[]{roleRefName, roleRefLink, description});
                } else {
                    SecurityRoleRefTablePanel.this.model.editRow(row, new String[]{roleRefName, roleRefLink, description});
                }
                SecurityRoleRefTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

