/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.metamodel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.ManagedProperty;
import org.netbeans.modules.web.jsf.impl.metamodel.Refreshable;

class ManagedBeanImpl
extends PersistentObject
implements FacesManagedBean,
Refreshable {
    private static final Map<String, ManagedBean.Scope> SCOPES = new HashMap<String, ManagedBean.Scope>();
    private Boolean eager;
    private String myName;
    private String myClass;
    private ManagedBean.Scope myScope;
    private String myStringScope;

    ManagedBeanImpl(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    @Override
    public Boolean getEager() {
        return this.eager;
    }

    @Override
    public String getManagedBeanName() {
        return this.myName;
    }

    @Override
    public boolean refresh(TypeElement type) {
        Map types = this.getHelper().getAnnotationsByType(this.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(type));
        AnnotationMirror annotationMirror = (AnnotationMirror)types.get("javax.faces.bean.ManagedBean");
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectPrimitive("eager", Boolean.class, AnnotationParser.defaultValue((Object)Boolean.FALSE));
        parser.expectString("name", null);
        ParseResult parseResult = parser.parse(annotationMirror);
        Boolean eagerAttr = (Boolean)parseResult.get("eager", Boolean.class);
        this.eager = eagerAttr == null ? Boolean.valueOf(false) : eagerAttr;
        this.myClass = type.getQualifiedName().toString();
        this.myName = (String)parseResult.get("name", String.class);
        if (this.myName == null || this.myName.length() == 0) {
            this.myName = ManagedBeanImpl.getConvertedClassName(this.myClass);
        }
        this.setScope(types, type);
        return true;
    }

    @Override
    public String getManagedBeanClass() {
        return this.myClass;
    }

    @Override
    public ManagedBean.Scope getManagedBeanScope() {
        return this.myScope;
    }

    @Override
    public String getManagedBeanScopeString() {
        return this.myStringScope;
    }

    @Override
    public List<ManagedProperty> getManagedProperties() {
        return null;
    }

    private void setScope(Map<String, ? extends AnnotationMirror> types, TypeElement type) {
        boolean isCustom = this.getHelper().hasAnnotation(type.getAnnotationMirrors(), "javax.faces.bean.CustomScoped");
        if (isCustom) {
            AnnotationMirror annotationMirror = types.get("javax.faces.bean.CustomScoped");
            AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
            parser.expectString("value", AnnotationParser.defaultValue((Object)""));
            ParseResult parseResult = parser.parse(annotationMirror);
            String value = (String)parseResult.get("value", String.class);
            if (value == null) {
                value = "";
            }
            if (this.myScope != null) {
                this.myScope = null;
            }
            this.myStringScope = value;
        } else {
            ManagedBean.Scope found = null;
            for (Map.Entry<String, ManagedBean.Scope> entry : SCOPES.entrySet()) {
                String annotation = entry.getKey();
                ManagedBean.Scope scope = entry.getValue();
                if (!this.getHelper().hasAnnotation(type.getAnnotationMirrors(), annotation)) continue;
                found = scope;
                break;
            }
            if (found == null) {
                this.myScope = null;
                this.myStringScope = null;
            } else {
                this.myScope = found;
                this.myStringScope = this.myScope.toString();
            }
        }
    }

    public static String getConvertedClassName(String className) {
        String result = className.substring(className.lastIndexOf(".") + 1);
        if (result.length() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(Character.toLowerCase(result.charAt(0)));
            builder.append(result.substring(1));
            result = builder.toString();
        }
        return result;
    }

    static {
        SCOPES.put("javax.faces.bean.ApplicationScoped", ManagedBean.Scope.APPLICATION);
        SCOPES.put("javax.faces.bean.NoneScoped", ManagedBean.Scope.NONE);
        SCOPES.put("javax.faces.bean.RequestScoped", ManagedBean.Scope.REQUEST);
        SCOPES.put("javax.faces.bean.SessionScoped", ManagedBean.Scope.SESSION);
        SCOPES.put("javax.faces.bean.ViewScoped", ManagedBean.Scope.VIEW);
    }
}

