/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static int indexOf(String haystack, int fromIndex, int maxIndex, char ... needle) {
        ArrayUtils.checkArgs(haystack.length(), fromIndex, maxIndex, needle.length);
        return ArrayUtils.runIndexOf(haystack, fromIndex, maxIndex, needle);
    }

    private static int runIndexOf(String haystack, int fromIndex, int maxIndex, char[] needle) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            for (char c : needle) {
                if (haystack.charAt(i) != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] haystack, int fromIndex, int maxIndex, char ... needle) {
        ArrayUtils.checkArgs(haystack.length, fromIndex, maxIndex, needle.length);
        return ArrayUtils.runIndexOf(haystack, fromIndex, maxIndex, needle);
    }

    private static int runIndexOf(char[] haystack, int fromIndex, int maxIndex, char[] needle) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            for (char c : needle) {
                if (haystack[i] != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(byte[] haystack, int fromIndex, int maxIndex, byte ... needle) {
        ArrayUtils.checkArgs(haystack.length, fromIndex, maxIndex, needle.length);
        return ArrayUtils.runIndexOf(haystack, fromIndex, maxIndex, needle);
    }

    private static int runIndexOf(byte[] haystack, int fromIndex, int maxIndex, byte[] needle) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            for (byte c : needle) {
                if (haystack[i] != c) continue;
                return i;
            }
        }
        return -1;
    }

    private static void checkArgs(int length, int fromIndex, int maxIndex, int nValues) {
        if (fromIndex < 0) {
            ArrayUtils.illegalArgumentException("fromIndex must be positive");
        }
        if (maxIndex > length || maxIndex < fromIndex) {
            ArrayUtils.illegalArgumentException("maxIndex out of range");
        }
        if (nValues == 0) {
            ArrayUtils.illegalArgumentException("no search values provided");
        }
    }

    private static int runIndexOfWithOrMask(byte[] haystack, int fromIndex, int maxIndex, byte needle, byte mask) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            if ((haystack[i] | mask) != needle) continue;
            return i;
        }
        return -1;
    }

    private static int runIndexOfWithOrMask(char[] haystack, int fromIndex, int maxIndex, char needle, char mask) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            if ((haystack[i] | mask) != needle) continue;
            return i;
        }
        return -1;
    }

    private static int runIndexOfWithOrMask(String haystack, int fromIndex, int maxIndex, char needle, char mask) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            if ((haystack.charAt(i) | mask) != needle) continue;
            return i;
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithOrMask(byte[] haystack, int fromIndex, int maxIndex, byte c1, byte c2, byte mask1, byte mask2) {
        for (int i = fromIndex + 1; i < maxIndex; ++i) {
            if ((haystack[i - 1] | mask1) != c1 || (haystack[i] | mask2) != c2) continue;
            return i - 1;
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithOrMask(char[] haystack, int fromIndex, int maxIndex, char c1, char c2, char mask1, char mask2) {
        for (int i = fromIndex + 1; i < maxIndex; ++i) {
            if ((haystack[i - 1] | mask1) != c1 || (haystack[i] | mask2) != c2) continue;
            return i - 1;
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithOrMask(String haystack, int fromIndex, int maxIndex, char c1, char c2, char mask1, char mask2) {
        for (int i = fromIndex + 1; i < maxIndex; ++i) {
            if ((haystack.charAt(i - 1) | mask1) != c1 || (haystack.charAt(i) | mask2) != c2) continue;
            return i - 1;
        }
        return -1;
    }

    public static int indexOfWithOrMask(byte[] haystack, int fromIndex, int length, byte[] needle, byte[] mask) {
        byte mask1;
        ArrayUtils.checkArgsIndexOf(haystack.length, fromIndex, length);
        if (mask != null) {
            ArrayUtils.checkMaskLengthIndexOf(needle.length, mask.length);
        }
        if (needle.length == 0) {
            return fromIndex;
        }
        if (length - needle.length < 0) {
            return -1;
        }
        if (needle.length == 1) {
            return ArrayUtils.runIndexOfWithOrMask(haystack, fromIndex, fromIndex + length, needle[0], mask == null ? (byte)0 : mask[0]);
        }
        int max = fromIndex + length - (needle.length - 2);
        byte mask0 = mask == null ? (byte)0 : mask[0];
        byte by = mask1 = mask == null ? (byte)0 : mask[1];
        for (int index = fromIndex; index < max - 1; ++index) {
            if ((index = ArrayUtils.runIndexOf2ConsecutiveWithOrMask(haystack, index, max, needle[0], needle[1], mask0, mask1)) < 0) {
                return -1;
            }
            if (needle.length != 2 && !ArrayUtils.regionEqualsWithOrMask(haystack, index, needle, 0, needle.length, mask)) continue;
            return index;
        }
        return -1;
    }

    public static int indexOfWithOrMask(char[] haystack, int fromIndex, int length, char[] needle, char[] mask) {
        ArrayUtils.checkArgsIndexOf(haystack.length, fromIndex, length);
        if (mask != null) {
            ArrayUtils.checkMaskLengthIndexOf(needle.length, mask.length);
        }
        if (needle.length == 0) {
            return fromIndex;
        }
        if (length - needle.length < 0) {
            return -1;
        }
        if (needle.length == 1) {
            return ArrayUtils.runIndexOfWithOrMask(haystack, fromIndex, fromIndex + length, needle[0], mask == null ? (char)'\u0000' : mask[0]);
        }
        char mask0 = mask == null ? (char)'\u0000' : mask[0];
        char mask1 = mask == null ? (char)'\u0000' : mask[1];
        int max = fromIndex + length - (needle.length - 2);
        for (int index = fromIndex; index < max - 1; ++index) {
            if ((index = ArrayUtils.runIndexOf2ConsecutiveWithOrMask(haystack, index, max, needle[0], needle[1], mask0, mask1)) < 0) {
                return -1;
            }
            if (needle.length != 2 && !ArrayUtils.regionEqualsWithOrMask(haystack, index, needle, 0, needle.length, mask)) continue;
            return index;
        }
        return -1;
    }

    public static int indexOfWithOrMask(String haystack, int fromIndex, int length, String needle, String mask) {
        ArrayUtils.checkArgsIndexOf(haystack.length(), fromIndex, length);
        if (mask != null) {
            ArrayUtils.checkMaskLengthIndexOf(needle.length(), mask.length());
        }
        if (needle.isEmpty()) {
            return fromIndex;
        }
        if (length - needle.length() < 0) {
            return -1;
        }
        if (needle.length() == 1) {
            return ArrayUtils.runIndexOfWithOrMask(haystack, fromIndex, fromIndex + length, needle.charAt(0), mask == null ? (char)'\u0000' : mask.charAt(0));
        }
        char mask0 = mask == null ? (char)'\u0000' : mask.charAt(0);
        char mask1 = mask == null ? (char)'\u0000' : mask.charAt(1);
        int max = fromIndex + length - (needle.length() - 2);
        for (int index = fromIndex; index < max - 1; ++index) {
            if ((index = ArrayUtils.runIndexOf2ConsecutiveWithOrMask(haystack, index, max, needle.charAt(0), needle.charAt(1), mask0, mask1)) < 0) {
                return -1;
            }
            if (needle.length() != 2 && !ArrayUtils.regionEqualsWithOrMask(haystack, index, needle, 0, needle.length(), mask)) continue;
            return index;
        }
        return -1;
    }

    private static void checkArgsIndexOf(int hayStackLength, int fromIndex, int length) {
        if (fromIndex < 0 || length < 0) {
            ArrayUtils.illegalArgumentException("fromIndex and length must be positive");
        }
        if (fromIndex + length > hayStackLength) {
            ArrayUtils.illegalArgumentException("length out of range");
        }
    }

    private static void checkMaskLengthIndexOf(int needleLength, int maskLength) {
        if (needleLength != maskLength) {
            ArrayUtils.illegalArgumentException("mask and needle length must be equal");
        }
    }

    private static boolean runRegionEquals(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1[fromIndex1 + i] == a2[fromIndex2 + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean runRegionEquals(char[] a1, int fromIndex1, char[] a2, int fromIndex2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1[fromIndex1 + i] == a2[fromIndex2 + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean runRegionEquals(String a1, int fromIndex1, String a2, int fromIndex2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1.charAt(fromIndex1 + i) == a2.charAt(fromIndex2 + i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionEqualsWithOrMask(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length, byte[] mask) {
        ArrayUtils.requireNonNull(a1);
        ArrayUtils.requireNonNull(a2);
        ArrayUtils.checkArgsRegionEquals(fromIndex1, fromIndex2, length);
        if (ArrayUtils.regionEqualsOutOfBounds(a1.length, fromIndex1, a2.length, fromIndex2, length)) {
            return false;
        }
        if (mask == null) {
            return ArrayUtils.runRegionEquals(a1, fromIndex1, a2, fromIndex2, length);
        }
        ArrayUtils.checkMaskLengthRegionEquals(length, mask.length);
        return ArrayUtils.runRegionEqualsWithOrMask(a1, fromIndex1, a2, fromIndex2, mask);
    }

    private static boolean runRegionEqualsWithOrMask(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, byte[] mask) {
        for (int i = 0; i < mask.length; ++i) {
            if ((a1[fromIndex1 + i] | mask[i]) == a2[fromIndex2 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean regionEqualsWithOrMask(char[] a1, int fromIndex1, char[] a2, int fromIndex2, int length, char[] mask) {
        ArrayUtils.requireNonNull(a1);
        ArrayUtils.requireNonNull(a2);
        ArrayUtils.checkArgsRegionEquals(fromIndex1, fromIndex2, length);
        if (ArrayUtils.regionEqualsOutOfBounds(a1.length, fromIndex1, a2.length, fromIndex2, length)) {
            return false;
        }
        if (mask == null) {
            return ArrayUtils.runRegionEquals(a1, fromIndex1, a2, fromIndex2, length);
        }
        ArrayUtils.checkMaskLengthRegionEquals(length, mask.length);
        return ArrayUtils.runRegionEqualsWithOrMask(a1, fromIndex1, a2, fromIndex2, mask);
    }

    private static boolean runRegionEqualsWithOrMask(char[] a1, int fromIndex1, char[] a2, int fromIndex2, char[] mask) {
        for (int i = 0; i < mask.length; ++i) {
            if ((a1[fromIndex1 + i] | mask[i]) == a2[fromIndex2 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean regionEqualsWithOrMask(String a1, int fromIndex1, String a2, int fromIndex2, int length, String mask) {
        ArrayUtils.requireNonNull(a1);
        ArrayUtils.requireNonNull(a2);
        ArrayUtils.checkArgsRegionEquals(fromIndex1, fromIndex2, length);
        if (ArrayUtils.regionEqualsOutOfBounds(a1.length(), fromIndex1, a2.length(), fromIndex2, length)) {
            return false;
        }
        if (mask == null) {
            return ArrayUtils.runRegionEquals(a1, fromIndex1, a2, fromIndex2, length);
        }
        ArrayUtils.checkMaskLengthRegionEquals(length, mask.length());
        return ArrayUtils.runRegionEqualsWithOrMask(a1, fromIndex1, a2, fromIndex2, mask);
    }

    private static boolean runRegionEqualsWithOrMask(String a1, int fromIndex1, String a2, int fromIndex2, String mask) {
        for (int i = 0; i < mask.length(); ++i) {
            if ((a1.charAt(fromIndex1 + i) | mask.charAt(i)) == a2.charAt(fromIndex2 + i)) continue;
            return false;
        }
        return true;
    }

    private static void checkArgsRegionEquals(int fromIndex1, int fromIndex2, int length) {
        if (fromIndex1 < 0 || fromIndex2 < 0 || length < 0) {
            ArrayUtils.illegalArgumentException("length, fromIndex1 and fromIndex2 must be positive");
        }
    }

    private static void checkMaskLengthRegionEquals(int length, int maskLength) {
        if (length > maskLength) {
            ArrayUtils.illegalArgumentException("mask length must be greater or equal to length");
        }
    }

    private static boolean regionEqualsOutOfBounds(int a1Length, int fromIndex1, int a2Length, int fromIndex2, int length) {
        return a1Length - fromIndex1 < length || a2Length - fromIndex2 < length;
    }

    private static void requireNonNull(Object obj) {
        if (obj == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new NullPointerException();
        }
    }

    private static void illegalArgumentException(String msg) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException(msg);
    }
}

