/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.Version;
import org.openide.util.Pair;

public final class LibraryProvider {
    private static final String PROPERTY_VERSIONS = "assets";
    private static final String PROPERTY_VERSION_NAME = "version";
    private static final String PROPERTY_FILES = "files";
    private static final String PROPERTY_FILE_NAME = "name";
    private static final String PROPERTY_RESULT = "results";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_HOMEPAGE = "homepage";
    private static final LibraryProvider INSTANCE = new LibraryProvider();
    private final Map<String, WeakReference<Library[]>> cache = Collections.synchronizedMap(new HashMap());
    private final Map<String, WeakReference<Library>> entryCache = Collections.synchronizedMap(new HashMap());
    private static final String LIBRARY_FILE_URL_PATTERN = System.getProperty("netbeans.cdnjs.downloadurl", "https://cdnjs.cloudflare.com/ajax/libs/{0}/{1}/{2}");
    static final String SEARCH_URL_PREFIX = System.getProperty("netbeans.cdnjs.searchurl", "https://api.cdnjs.com/libraries?fields=description,homepage,assets&search=");
    static final String ASSET_URL_PATTERN = System.getProperty("netbeans.cdnjs.asseturlpattern", "https://api.cdnjs.com/libraries/%1$s?fields=name,description,homepage,assets");
    static final Comparator<Pair<Library.Version, Version>> VERSION_COMPARATOR = new Comparator<Pair<Library.Version, Version>>(){

        @Override
        public int compare(Pair<Library.Version, Version> pair1, Pair<Library.Version, Version> pair2) {
            return Version.Comparator.getInstance(false).compare((Version)pair1.second(), (Version)pair2.second());
        }
    };

    private LibraryProvider() {
    }

    public static LibraryProvider getInstance() {
        return INSTANCE;
    }

    public Library[] findLibraries(String searchTerm) {
        WeakReference<Library[]> reference = this.cache.get(searchTerm);
        Library[] result = null;
        if (reference != null) {
            result = (Library[])reference.get();
        }
        if (result == null) {
            String searchURL = this.getSearchURL(searchTerm);
            String urlContent = LibraryProvider.readUrl(searchURL);
            Library[] libraries = null;
            if (urlContent != null) {
                libraries = this.parse(urlContent);
            }
            this.cache.put(searchTerm, new WeakReference<Library[]>(libraries));
            result = libraries;
        }
        return result;
    }

    public void updateLibraryVersions(Library library) {
        Objects.nonNull(library);
        if (library.getVersions() != null && library.getVersions().length > 0) {
            return;
        }
        Library cachedLibrary = this.getCachedLibrary(library.getName());
        if (cachedLibrary != null) {
            library.setVersions(cachedLibrary.getVersions());
            return;
        }
        String data = LibraryProvider.readUrl(this.getLibraryDataUrl(library.getName()));
        if (data != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject libraryData = (JSONObject)parser.parse(data);
                this.updateLibrary(library, libraryData);
                this.entryCache.put(library.getName(), new WeakReference<Library>(library));
            }
            catch (ParseException ex) {
                Logger.getLogger(LibraryProvider.class.getName()).log(Level.INFO, null, ex);
            }
        }
    }

    public Library loadLibrary(String libraryName) {
        Library cachedLibrary = this.getCachedLibrary(libraryName);
        if (cachedLibrary != null) {
            return cachedLibrary;
        }
        String data = LibraryProvider.readUrl(this.getLibraryDataUrl(libraryName));
        if (data != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject libraryData = (JSONObject)parser.parse(data);
                Library library = this.createLibrary(libraryData);
                this.entryCache.put(library.getName(), new WeakReference<Library>(library));
                return library;
            }
            catch (ParseException ex) {
                Logger.getLogger(LibraryProvider.class.getName()).log(Level.INFO, null, ex);
            }
        }
        return null;
    }

    private Library getCachedLibrary(String name) {
        WeakReference<Library> cachedEntry = this.entryCache.get(name);
        if (cachedEntry != null) {
            return (Library)cachedEntry.get();
        }
        return null;
    }

    private String getLibraryDataUrl(String libraryName) {
        String encodedLibraryName;
        try {
            encodedLibraryName = URLEncoder.encode(libraryName, "UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            Logger.getLogger(LibraryProvider.class.getName()).log(Level.SEVERE, null, ueex);
            encodedLibraryName = libraryName;
        }
        return String.format(ASSET_URL_PATTERN, encodedLibraryName);
    }

    /*
     * Exception decompiling
     */
    public File downloadLibraryFile(Library.Version version, int fileIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void extractVersionInformation(JSONObject data, Library library) {
        JSONArray versionsData = (JSONArray)data.get((Object)PROPERTY_VERSIONS);
        if (versionsData != null) {
            Library.Version[] versions = new Library.Version[versionsData.size()];
            for (int i = 0; i < versions.length; ++i) {
                JSONObject versionData = (JSONObject)versionsData.get(i);
                versions[i] = LibraryProvider.createVersion(library, versionData);
            }
            LibraryProvider.sort(versions);
            library.setVersions(versions);
        } else {
            library.setVersions(new Library.Version[0]);
        }
    }

    private static void sort(Library.Version[] versions) {
        int i;
        Pair[] pairs = new Pair[versions.length];
        for (i = 0; i < versions.length; ++i) {
            Library.Version libraryVersion = versions[i];
            Version version = Version.parse(libraryVersion.getName());
            pairs[i] = Pair.of((Object)libraryVersion, (Object)version);
        }
        Arrays.sort(pairs, VERSION_COMPARATOR);
        for (i = 0; i < versions.length; ++i) {
            versions[i] = (Library.Version)pairs[i].first();
        }
    }

    private static Library.Version createVersion(Library library, JSONObject data) {
        Library.Version version = new Library.Version(library, false);
        String versionName = (String)data.get((Object)PROPERTY_VERSION_NAME);
        version.setName(versionName);
        JSONArray filesData = (JSONArray)data.get((Object)PROPERTY_FILES);
        String[] files = new String[filesData.size()];
        for (int i = 0; i < files.length; ++i) {
            String fileName;
            Object fileInfo = filesData.get(i);
            if (fileInfo instanceof JSONObject) {
                JSONObject fileData = (JSONObject)fileInfo;
                fileName = (String)fileData.get((Object)"name");
            } else {
                fileName = fileInfo.toString();
            }
            files[i] = fileName;
        }
        version.setFileInfo(files, null);
        return version;
    }

    static String readUrl(String url) {
        String urlContent = null;
        try {
            URL urlObject = new URL(url);
            URLConnection urlConnection = urlObject.openConnection();
            StringBuilder content = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append('\n');
                }
            }
            urlContent = content.toString();
        }
        catch (MalformedURLException muex) {
            Logger.getLogger(LibraryProvider.class.getName()).log(Level.INFO, null, muex);
        }
        catch (IOException ioex) {
            Logger.getLogger(LibraryProvider.class.getName()).log(Level.INFO, null, ioex);
        }
        return urlContent;
    }

    String getSearchURL(String searchTerm) {
        String encodedSearchTerm;
        try {
            encodedSearchTerm = URLEncoder.encode(searchTerm, "UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            Logger.getLogger(LibraryProvider.class.getName()).log(Level.SEVERE, null, ueex);
            encodedSearchTerm = searchTerm;
        }
        return SEARCH_URL_PREFIX + encodedSearchTerm;
    }

    Library[] parse(String data) {
        Library[] libraries = null;
        try {
            JSONParser parser = new JSONParser();
            JSONObject searchResult = (JSONObject)parser.parse(data);
            JSONArray libraryArray = (JSONArray)searchResult.get((Object)PROPERTY_RESULT);
            libraries = new Library[libraryArray.size()];
            for (int i = 0; i < libraries.length; ++i) {
                JSONObject libraryData = (JSONObject)libraryArray.get(i);
                libraries[i] = this.createLibrary(libraryData);
            }
        }
        catch (ParseException pex) {
            Logger.getLogger(LibraryProvider.class.getName()).log(Level.INFO, null, pex);
        }
        return libraries;
    }

    Library createLibrary(JSONObject data) {
        Library library = new Library();
        this.updateLibrary(library, data);
        return library;
    }

    void updateLibrary(Library library, JSONObject data) {
        String name = (String)data.get((Object)"name");
        library.setName(name);
        String description = (String)data.get((Object)PROPERTY_DESCRIPTION);
        library.setDescription(description);
        String homepage = (String)data.get((Object)PROPERTY_HOMEPAGE);
        library.setHomePage(homepage);
        LibraryProvider.extractVersionInformation(data, library);
    }
}

