/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.MetaModelSupport;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.index.JsfIndex;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.NamespaceUtils;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JsfSupportImpl
implements JsfSupport {
    private static final Logger LOG = Logger.getLogger(JsfSupportImpl.class.getSimpleName());
    private FaceletsLibrarySupport faceletsLibrarySupport;
    private Project project;
    private WebModule wm;
    private ClassPath sourceClassPath;
    private ClassPath compileClasspath;
    private ClassPath executeClassPath;
    private ClassPath bootClassPath;
    private JsfIndex index;
    private MetadataModel<WebBeansModel> webBeansModel;
    private Lookup lookup;

    public static JsfSupportImpl findFor(Source source) {
        return JsfSupportImpl.getOwnImplementation(JsfSupportProvider.get((Source)source));
    }

    public static JsfSupportImpl findFor(FileObject file) {
        return JsfSupportImpl.getOwnImplementation(JsfSupportProvider.get((FileObject)file));
    }

    private static JsfSupportImpl getOwnImplementation(JsfSupport instance) {
        if (instance instanceof JsfSupportImpl) {
            return (JsfSupportImpl)instance;
        }
        return null;
    }

    static JsfSupportImpl findForProject(Project project) {
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            ClassPath executeCP;
            ClassPath compileCP;
            if (webModule.getDocumentBase() == null) {
                LOG.log(Level.INFO, "project ''{0}'' does not have valid documentBase", project);
                return null;
            }
            ClassPath sourceCP = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/source");
            if (!JsfSupportImpl.validateUpdateClasspaths(project, webModule, sourceCP, compileCP = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile"), executeCP = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/execute"))) {
                return null;
            }
            ClassPath bootCP = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/boot");
            return new JsfSupportImpl(project, webModule, sourceCP, compileCP, executeCP, bootCP);
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length > 0) {
            HashSet<ClassPath> sourceCps = new HashSet<ClassPath>();
            HashSet<ClassPath> compileCps = new HashSet<ClassPath>();
            HashSet<ClassPath> executeCps = new HashSet<ClassPath>();
            HashSet<ClassPath> bootCps = new HashSet<ClassPath>();
            for (SourceGroup sg : sourceGroups) {
                sourceCps.add(ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/source"));
                compileCps.add(ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/compile"));
                executeCps.add(ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/execute"));
                bootCps.add(ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/boot"));
            }
            return new JsfSupportImpl(project, null, ClassPathSupport.createProxyClassPath((ClassPath[])sourceCps.toArray(new ClassPath[0])), ClassPathSupport.createProxyClassPath((ClassPath[])compileCps.toArray(new ClassPath[0])), ClassPathSupport.createProxyClassPath((ClassPath[])executeCps.toArray(new ClassPath[0])), ClassPathSupport.createProxyClassPath((ClassPath[])bootCps.toArray(new ClassPath[0])));
        }
        return null;
    }

    private static boolean validateUpdateClasspaths(Project project, WebModule webModule, ClassPath sourceCP, ClassPath compileCP, ClassPath executeCP) {
        if (compileCP == null) {
            LOG.log(Level.INFO, "project ''{0}'' does not have compilation classpath; documentBase={1}", new Object[]{project, webModule.getDocumentBase()});
            return false;
        }
        if (sourceCP == null) {
            LOG.log(Level.INFO, "project ''{0}'' does not have source classpath; documentBase={1}", new Object[]{project, webModule.getDocumentBase()});
            return false;
        }
        if (executeCP == null) {
            LOG.log(Level.INFO, "project ''{0}'' does not have execution classpath; documentBase={1}", new Object[]{project, webModule.getDocumentBase()});
            return false;
        }
        return true;
    }

    private JsfSupportImpl(Project project, WebModule wm, ClassPath sourceClassPath, ClassPath compileClassPath, ClassPath executeClassPath, ClassPath bootClassPath) {
        this.project = project;
        this.wm = wm;
        this.sourceClassPath = sourceClassPath;
        this.compileClasspath = compileClassPath;
        this.executeClassPath = executeClassPath;
        this.bootClassPath = bootClassPath;
        this.faceletsLibrarySupport = new FaceletsLibrarySupport(this);
        this.compileClasspath.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JsfSupportImpl jsfSupportImpl = JsfSupportImpl.this;
                synchronized (jsfSupportImpl) {
                    JsfSupportImpl.this.index = null;
                }
            }
        });
        this.webBeansModel = new MetaModelSupport(project).getMetaModel();
        InstanceContent ic = new InstanceContent();
        ic.add(this.webBeansModel);
        this.lookup = new AbstractLookup((AbstractLookup.Content)ic);
    }

    public Project getProject() {
        return this.project;
    }

    public ClassPath getClassPath() {
        return this.compileClasspath;
    }

    public FileObject[] getClassPathRoots() {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        roots.addAll(Arrays.asList(this.sourceClassPath.getRoots()));
        roots.addAll(Arrays.asList(this.compileClasspath.getRoots()));
        roots.addAll(Arrays.asList(this.executeClassPath.getRoots()));
        return roots.toArray(new FileObject[0]);
    }

    public WebModule getWebModule() {
        return this.wm;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public Library getLibrary(String namespace) {
        return (Library)NamespaceUtils.getForNs(this.faceletsLibrarySupport.getLibraries(), (String)namespace);
    }

    public Map<String, Library> getLibraries() {
        return this.faceletsLibrarySupport.getLibraries();
    }

    public boolean isFileOnClasspath(FileObject file) {
        return this.sourceClassPath.contains(file) || this.compileClasspath.contains(file) || this.executeClassPath.contains(file);
    }

    public void indexedContentPossiblyChanged() {
        this.faceletsLibrarySupport.indexedContentPossiblyChanged();
    }

    public synchronized JsfIndex getIndex() {
        if (this.index == null) {
            this.index = JsfIndex.create(this.sourceClassPath, this.compileClasspath, this.executeClassPath, this.bootClassPath);
        }
        return this.index;
    }

    public FaceletsLibrarySupport getFaceletsLibrarySupport() {
        return this.faceletsLibrarySupport;
    }

    public synchronized MetadataModel<WebBeansModel> getWebBeansModel() {
        return this.webBeansModel;
    }

    public boolean isJsf22Plus() {
        if (this.wm != null) {
            JSFVersion version = JSFVersion.forWebModule((WebModule)this.wm);
            return version != null && version.isAtLeast(JSFVersion.JSF_2_2);
        }
        return true;
    }

    public String toString() {
        return String.format("JsfSupportImpl[%s]", this.getBaseFile().getPath());
    }

    private FileObject getBaseFile() {
        return this.wm != null ? this.wm.getDocumentBase() : this.project.getProjectDirectory();
    }
}

