/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.CPPVariable;
import org.netbeans.modules.cpplite.debugger.Command;
import org.netbeans.modules.cpplite.debugger.EvaluateException;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Pair;

public final class CPPFrame
implements DebuggingView.DVFrame {
    private static final Logger LOGGER = Logger.getLogger(CPPFrame.class.getName());
    private final CPPThread thread;
    private final String address;
    public final String shortFileName;
    public final String fullFileName;
    public final String functionName;
    public final int line;
    public final int level;
    private volatile Map<String, CPPVariable> variables;

    CPPFrame(CPPThread thread, MITList frame) {
        Objects.requireNonNull(thread);
        this.thread = thread;
        this.address = frame.getConstValue("addr");
        this.shortFileName = frame.valueOf("file") != null ? frame.valueOf("file").asConst().value() : null;
        this.functionName = frame.valueOf("func").asConst().value();
        this.fullFileName = frame.valueOf("fullname") != null ? frame.valueOf("fullname").asConst().value() : null;
        this.line = frame.valueOf("line") != null ? Integer.parseInt(frame.valueOf("line").asConst().value()) : 1;
        this.level = frame.valueOf("level") != null ? Integer.parseInt(frame.valueOf("level").asConst().value()) : 0;
    }

    String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.functionName;
    }

    @CheckForNull
    public Line location() {
        FileObject file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.fullFileName)));
        if (file == null) {
            return null;
        }
        LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
        return lc.getLineSet().getOriginal(this.line - 1);
    }

    public CPPThread getThread() {
        return this.thread;
    }

    public void makeCurrent() {
        this.thread.getDebugger().setCurrentStackFrame(this);
    }

    public URI getSourceURI() {
        FileObject file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.fullFileName)));
        if (file != null) {
            return file.toURI();
        }
        return null;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CPPVariable> getVariables() {
        Map<String, CPPVariable> vars = this.variables;
        if (vars == null) {
            CPPFrame cPPFrame = this;
            synchronized (cPPFrame) {
                vars = this.variables;
                if (vars == null) {
                    this.variables = vars = CPPFrame.retrieveVariables(this, null);
                }
            }
        }
        return vars;
    }

    static Map<String, CPPVariable> retrieveVariables(CPPFrame frame, CPPVariable parentVar) {
        MIRecord record;
        try {
            record = parentVar == null ? frame.thread.getDebugger().sendAndGet("-stack-list-variables --thread " + frame.thread.getId() + " --frame " + frame.level + " --no-frame-filters 2") : frame.thread.getDebugger().sendAndGet("-var-list-children --thread " + frame.thread.getId() + " --frame " + frame.level + " --all-values " + parentVar.getUniqueName());
        }
        catch (InterruptedException ex) {
            return Collections.emptyMap();
        }
        if (record.isError()) {
            return Collections.singletonMap(record.error(), null);
        }
        MITList results = record.results();
        if (results.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, CPPVariable> map = new LinkedHashMap<String, CPPVariable>(results.size());
        MIValue children = results.valueOf("children");
        if (children != null) {
            for (MITListItem item : children.asList()) {
                MITList child = ((MIResult)item).value().asTList();
                String uniqueName = child.getConstValue("name");
                String name = child.getConstValue("exp");
                int numChildren = Integer.parseInt(child.getConstValue("numchild"));
                String type = child.getConstValue("type");
                MIValue value = child.valueOf("value");
                map.put(name, new CPPVariable(frame, uniqueName, name, type, value, numChildren));
            }
        } else {
            MIValue resultValue = results.valueOf("variables");
            if (resultValue.isConst()) {
                return Collections.singletonMap(((MIConst)resultValue).value(), null);
            }
            results = (MITList)resultValue;
            LOGGER.log(Level.FINE, "retrieveVariables: have {0} variables:", results.size());
            for (MITListItem item : results) {
                MITList varList = (MITList)item;
                String name = varList.getConstValue("name");
                String type = varList.getConstValue("type");
                MIValue value = varList.valueOf("value");
                Pair<String, Integer> uniqueVar = CPPFrame.createVariable(frame, name);
                String uniqueName = (String)uniqueVar.first();
                int numChildren = (Integer)uniqueVar.second();
                LOGGER.log(Level.FINE, "  {0} = ({1}) {2} ; [{3}]", new Object[]{name, type, value, numChildren});
                map.put(name, new CPPVariable(frame, uniqueName, name, type, value, numChildren));
            }
        }
        return map;
    }

    private static Pair<String, Integer> createVariable(CPPFrame frame, String variableName) {
        String uniqueName = null;
        int numChildren = 0;
        try {
            MIRecord record = frame.thread.getDebugger().sendAndGet("-var-create --thread " + frame.thread.getId() + " --frame " + frame.level + " - * " + variableName);
            if (!record.isError() && !record.isEmpty()) {
                uniqueName = record.results().getConstValue("name");
                String numchild = record.results().getConstValue("numchild");
                numChildren = Integer.parseInt(numchild);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Pair.of(uniqueName, (Object)numChildren);
    }

    private static int retrieveNumChildren(CPPFrame frame, String variableName) {
        int numChildren = 0;
        try {
            String numchild;
            MIRecord record = frame.thread.getDebugger().sendAndGet("-var-info-num-children --thread " + frame.thread.getId() + " --frame " + frame.level + " " + variableName);
            if (!(record.isError() || record.isEmpty() || (numchild = record.results().getConstValue("numchild")).isEmpty())) {
                numChildren = Integer.parseInt(numchild);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return numChildren;
    }

    public void evaluateLazy(final String expression, final Consumer<CPPVariable> result, final Consumer<EvaluateException> exception) {
        CPPVariable value = this.getVariables().get(expression);
        if (value != null) {
            result.accept(value);
            return;
        }
        this.thread.getDebugger().send(new Command("-var-create - * " + expression){

            @Override
            protected void onDone(MIRecord record) {
                MITList results = record.results();
                String varName = results.valueOf("name").asConst().value();
                MIValue typeValue = results.valueOf("type");
                String type = typeValue != null ? typeValue.asConst().value() : null;
                MIValue resultValue = results.valueOf("value");
                MIValue numchildValue = results.valueOf("numchild");
                int numChildren = numchildValue != null ? Integer.parseInt(numchildValue.asConst().value()) : CPPFrame.retrieveNumChildren(CPPFrame.this, varName);
                result.accept(new CPPVariable(CPPFrame.this, expression, expression, type, resultValue, numChildren));
                CPPFrame.this.thread.getDebugger().send(new Command("-var-delete " + varName));
            }

            @Override
            protected void onError(MIRecord record) {
                exception.accept(new EvaluateException(record.error()));
            }
        });
    }
}

