/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.hintsimpl;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class LoggerStringConcat {
    private static final Logger LOG = Logger.getLogger(LoggerStringConcat.class.getName());

    public static ErrorDescription hint1(HintContext ctx) {
        return LoggerStringConcat.compute(ctx, null);
    }

    public static ErrorDescription hint2(HintContext ctx) {
        String methodName;
        TreePath inv = ctx.getPath();
        MethodInvocationTree mit = (MethodInvocationTree)inv.getLeaf();
        ExpressionTree sel = mit.getMethodSelect();
        String string = methodName = sel.getKind() == Tree.Kind.MEMBER_SELECT ? ((MemberSelectTree)sel).getIdentifier().toString() : ((IdentifierTree)sel).getName().toString();
        if (LoggerStringConcat.findConstant(ctx.getInfo(), methodName) != null) {
            return LoggerStringConcat.compute(ctx, methodName);
        }
        boolean dev = false;
        if (!$assertionsDisabled) {
            dev = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (dev) {
            StringBuilder log = new StringBuilder();
            log.append("Please add the following info the bug #180865:\n");
            log.append("tree: ").append(ctx.getPath().getLeaf()).append("\n");
            TreePath loggerVar = (TreePath)ctx.getVariables().get("$logger");
            if (loggerVar != null) {
                log.append("logger type: ").append(ctx.getInfo().getTrees().getTypeMirror(loggerVar)).append("\n");
            } else {
                log.append("$logger == null\n");
            }
            log.append("source level: ").append((Object)ctx.getInfo().getSourceVersion()).append("\n");
            log.append("End of #180865 debug info");
            LOG.info(log.toString());
        }
        return null;
    }

    private static ErrorDescription compute(HintContext ctx, String methodName) {
        TreePath message = (TreePath)ctx.getVariables().get("$message");
        List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements(ctx.getInfo(), message);
        if (sorted.size() <= 1) {
            return null;
        }
        for (List<TreePath> tps : sorted) {
            for (TreePath tp : tps) {
                if (tp.getLeaf().getKind() != Tree.Kind.ERRONEOUS) continue;
                return null;
            }
        }
        FixImpl fix = new FixImpl(NbBundle.getMessage(LoggerStringConcat.class, (String)"MSG_LoggerStringConcat_fix"), methodName, TreePathHandle.create((TreePath)ctx.getPath(), (CompilationInfo)ctx.getInfo()), TreePathHandle.create((TreePath)message, (CompilationInfo)ctx.getInfo()));
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)message, (String)NbBundle.getMessage(LoggerStringConcat.class, (String)"MSG_LoggerStringConcat"), (Fix[])new Fix[]{fix.toEditorFix()});
    }

    private static String literalToMessageFormat(String v) {
        String fmtValue = v.replaceAll("'", "''");
        fmtValue = fmtValue.replaceAll(Pattern.quote("{"), Matcher.quoteReplacement("'{'"));
        fmtValue = fmtValue.replaceAll(Pattern.quote("}"), Matcher.quoteReplacement("'}'"));
        return fmtValue;
    }

    private static void rewrite(WorkingCopy wc, ExpressionTree level, MethodInvocationTree invocation, TreePath message) {
        List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements((CompilationInfo)wc, message);
        StringBuilder workingLiteral = new StringBuilder();
        LinkedList<Tree> newMessage = new LinkedList<Tree>();
        LinkedList<ExpressionTree> newParams = new LinkedList<ExpressionTree>();
        int variablesCount = 0;
        TreeMaker make = wc.getTreeMaker();
        Tree singleLeaf = null;
        for (List<TreePath> element : sorted) {
            if (element.size() == 1 && !Utilities.isConstantString((CompilationInfo)wc, element.get(0), true)) {
                workingLiteral.append("{");
                workingLiteral.append(Integer.toString(variablesCount++));
                workingLiteral.append("}");
                newParams.add((ExpressionTree)element.get(0).getLeaf());
                continue;
            }
            for (TreePath p : element) {
                Tree l = p.getLeaf();
                if (Utilities.isStringOrCharLiteral(l)) {
                    singleLeaf = workingLiteral.length() == 0 ? l : null;
                    workingLiteral.append(LoggerStringConcat.literalToMessageFormat(((LiteralTree)l).getValue().toString()));
                    continue;
                }
                if (singleLeaf != null) {
                    newMessage.add(singleLeaf);
                    workingLiteral = new StringBuilder();
                } else if (workingLiteral.length() > 0) {
                    newMessage.add(make.Literal((Object)workingLiteral.toString()));
                    workingLiteral = new StringBuilder();
                }
                newMessage.add(l);
            }
        }
        if (workingLiteral.length() > 0) {
            newMessage.add(make.Literal((Object)workingLiteral.toString()));
        }
        ExpressionTree messageFinal = (ExpressionTree)newMessage.remove(0);
        while (!newMessage.isEmpty()) {
            messageFinal = make.Binary(Tree.Kind.PLUS, messageFinal, (ExpressionTree)newMessage.remove(0));
        }
        LinkedList<ExpressionTree> nueParams = new LinkedList<ExpressionTree>();
        nueParams.add(level);
        nueParams.add(messageFinal);
        if (newParams.size() > 1) {
            nueParams.add(make.NewArray((Tree)make.QualIdent((Element)wc.getElements().getTypeElement("java.lang.Object")), Collections.emptyList(), newParams));
        } else {
            nueParams.addAll(newParams);
        }
        ExpressionTree sel = invocation.getMethodSelect();
        ExpressionTree nueSel = sel.getKind() == Tree.Kind.MEMBER_SELECT ? make.MemberSelect(((MemberSelectTree)sel).getExpression(), (CharSequence)"log") : make.Identifier((CharSequence)"log");
        MethodInvocationTree nue = make.MethodInvocation(invocation.getTypeArguments(), nueSel, nueParams);
        wc.rewrite((Tree)invocation, (Tree)nue);
    }

    private static VariableElement findConstant(CompilationInfo info, String logMethodName) {
        logMethodName = logMethodName.toUpperCase();
        TypeElement julLevel = info.getElements().getTypeElement("java.util.logging.Level");
        if (julLevel == null) {
            return null;
        }
        for (VariableElement el : ElementFilter.fieldsIn(julLevel.getEnclosedElements())) {
            if (!el.getSimpleName().contentEquals(logMethodName)) continue;
            return el;
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private final String displayName;
        private final String logMethodName;
        private final TreePathHandle message;

        public FixImpl(String displayName, String logMethodName, TreePathHandle invocation, TreePathHandle message) {
            super(invocation);
            this.displayName = displayName;
            this.logMethodName = logMethodName;
            this.message = message;
        }

        public String getText() {
            return this.displayName;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath invocation = ctx.getPath();
            TreePath message = this.message.resolve((CompilationInfo)wc);
            MethodInvocationTree mit = (MethodInvocationTree)invocation.getLeaf();
            ExpressionTree level = null;
            if (this.logMethodName != null) {
                String logMethodNameUpper = this.logMethodName.toUpperCase();
                VariableElement c = LoggerStringConcat.findConstant((CompilationInfo)wc, logMethodNameUpper);
                level = wc.getTreeMaker().QualIdent((Element)c);
            } else {
                level = mit.getArguments().get(0);
            }
            LoggerStringConcat.rewrite(wc, level, mit, message);
        }
    }
}

