/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteScopeFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

abstract class JSWriteScopeFrameSlotNode
extends JSWriteFrameSlotNode {
    @Node.Child
    @Executed
    ScopeFrameNode scopeFrameNode;
    @Node.Child
    @Executed
    JavaScriptNode rhsNode;

    protected JSWriteScopeFrameSlotNode(FrameSlot frameSlot, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode, FrameDescriptor frameDescriptor) {
        super(frameSlot, frameDescriptor);
        this.scopeFrameNode = scopeFrameNode;
        this.rhsNode = rhsNode;
    }

    @Specialization(guards={"isBooleanKind(levelFrame)"})
    protected final boolean doBoolean(Frame levelFrame, boolean value) {
        levelFrame.setBoolean(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"(isIntegerKind(frame) || isLongKind(frame)) || isDoubleKind(frame)"})
    protected final int doInteger(Frame frame, int value) {
        if (this.isIntegerKind(frame)) {
            frame.setInt(this.frameSlot, value);
        } else if (this.isLongKind(frame)) {
            frame.setLong(this.frameSlot, (long)value);
        } else if (this.isDoubleKind(frame)) {
            frame.setDouble(this.frameSlot, (double)value);
        }
        return value;
    }

    @Specialization(guards={"isLongKind(levelFrame)"})
    protected final SafeInteger doSafeInteger(Frame levelFrame, SafeInteger value) {
        levelFrame.setLong(this.frameSlot, value.longValue());
        return value;
    }

    @Specialization
    protected final long doLong(Frame levelFrame, long value) {
        this.ensureObjectKind(levelFrame);
        levelFrame.setObject(this.frameSlot, (Object)value);
        return value;
    }

    @Specialization(guards={"isDoubleKind(levelFrame)"}, replaces={"doInteger", "doSafeInteger"})
    protected final double doDouble(Frame levelFrame, double value) {
        levelFrame.setDouble(this.frameSlot, value);
        return value;
    }

    @Specialization(replaces={"doBoolean", "doInteger", "doDouble", "doSafeInteger", "doLong"})
    protected final Object doObject(Frame levelFrame, Object value) {
        this.ensureObjectKind(levelFrame);
        levelFrame.setObject(this.frameSlot, value);
        return value;
    }

    @Override
    public final Object executeWithFrame(Frame frame, Object value) {
        return this.executeEvaluated(null, frame, value);
    }

    abstract Object executeEvaluated(VirtualFrame var1, Frame var2, Object var3);

    @Override
    public final Object executeWrite(VirtualFrame frame, Object value) {
        return this.executeEvaluated(frame, this.getLevelFrameNode().executeFrame((Frame)frame), value);
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return this.scopeFrameNode;
    }

    @Override
    public JavaScriptNode getRhs() {
        return this.rhsNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSWriteScopeFrameSlotNodeGen.create(this.frameSlot, this.getLevelFrameNode(), JSWriteScopeFrameSlotNode.cloneUninitialized(this.getRhs(), materializedTags), this.frameDescriptor);
    }
}

