/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.netbeans.upgrade.AutoUpgradePanel;
import org.netbeans.upgrade.Copy;
import org.netbeans.upgrade.CopyFiles;
import org.netbeans.upgrade.IncludeExclude;
import org.netbeans.upgrade.PathTransformation;
import org.netbeans.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;

public final class AutoUpgrade {
    private static final Logger LOGGER = Logger.getLogger(AutoUpgrade.class.getName());
    static final Comparator<String> APACHE_VERSION_COMPARATOR = (v1, v2) -> new SpecificationVersion(v1).compareTo(new SpecificationVersion(v2));
    static final List<String> APACHE_VERSION_TO_CHECK = Arrays.asList(NbBundle.getMessage(AutoUpgrade.class, (String)"apachenetbeanspreviousversion").split(",")).stream().sorted(APACHE_VERSION_COMPARATOR.reversed()).collect(Collectors.toList());

    public static void main(String[] args) throws Exception {
        File sourceFolder;
        String noteChangedDefaults = "";
        if (AutoUpgrade.madeObsoleteMessagesLog()) {
            noteChangedDefaults = NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_ChangedDefaults", (Object)System.getProperty("netbeans.user", ""));
        }
        if ((sourceFolder = AutoUpgrade.checkPreviousOnOsSpecificPlace(APACHE_VERSION_TO_CHECK)) != null) {
            if (!AutoUpgrade.showUpgradeDialog(sourceFolder, noteChangedDefaults)) {
                throw new UserCancelException();
            }
        } else if (!noteChangedDefaults.isEmpty()) {
            AutoUpgrade.showNoteDialog(noteChangedDefaults);
        }
    }

    private static File checkPreviousOnOsSpecificPlace(List<String> versionsToCheck) {
        String defaultUserdirRoot = System.getProperty("netbeans.default_userdir_root");
        if (defaultUserdirRoot != null) {
            File userHomeFile = new File(defaultUserdirRoot);
            for (String ver : versionsToCheck) {
                File sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (!sourceFolder.exists() || !sourceFolder.isDirectory()) continue;
                return sourceFolder;
            }
        }
        return null;
    }

    private static boolean madeObsoleteMessagesLog() {
        File oldUserdir;
        String userHome;
        String defaultUserdirRoot;
        String ud = System.getProperty("netbeans.user", "");
        if ((Utilities.isMac() || Utilities.isWindows()) && ud.endsWith(File.separator + "dev") && (defaultUserdirRoot = System.getProperty("netbeans.default_userdir_root", null)) != null && new File(ud).getParentFile().equals(new File(defaultUserdirRoot)) && (userHome = System.getProperty("user.home")) != null && (oldUserdir = new File(new File(userHome).getAbsolutePath(), ".netbeans/dev")).exists() && !oldUserdir.equals(new File(ud))) {
            File log = new File(oldUserdir, "/var/log/messages.log");
            File obsolete = new File(oldUserdir, "/var/log/messages.log.obsolete");
            if (!obsolete.exists() && log.exists()) {
                return log.renameTo(obsolete);
            }
        }
        return false;
    }

    private static boolean showUpgradeDialog(File source, String note) {
        Util.setDefaultLookAndFeel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new AutoUpgradePanel(source.getAbsolutePath(), note), "Center");
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        progressBar.setIndeterminate(true);
        panel.add((Component)progressBar, "South");
        progressBar.setVisible(false);
        JButton bYES = new JButton("Yes");
        bYES.setMnemonic(89);
        JButton bNO = new JButton("No");
        bNO.setMnemonic(78);
        Object[] options = new JButton[]{bYES, bNO};
        JOptionPane p = new JOptionPane(panel, 3, 0, null, options, bYES);
        JDialog d = Util.createJOptionProgressDialog(p, NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_Confirmation_Title"), source, progressBar);
        d.setVisible(true);
        return Integer.valueOf(0).equals(p.getValue());
    }

    private static void showNoteDialog(String note) {
        Util.setDefaultLookAndFeel();
        JOptionPane p = new JOptionPane(new AutoUpgradePanel(null, note), 1, -1);
        JDialog d = Util.createJOptionDialog(p, NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_Note_Title"));
        d.setVisible(true);
    }

    static void doUpgrade(File source, String oldVersion) throws IOException, PropertyVetoException {
        IncludeExclude includeExclude;
        File userdir = new File(System.getProperty("netbeans.user", ""));
        try (InputStreamReader r = new InputStreamReader(AutoUpgrade.class.getResourceAsStream("copy" + oldVersion), "utf-8");){
            includeExclude = IncludeExclude.create(r);
        }
        catch (IOException ex) {
            throw new IOException("Cannot import from version: " + oldVersion, ex);
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + oldVersion + ". Importing from " + source + " to " + userdir);
        File oldConfig = new File(source, "config");
        LocalFileSystem lfs = new LocalFileSystem();
        lfs.setRootDirectory(oldConfig);
        XMLFileSystem xmlfs = null;
        try {
            URL url = AutoUpgrade.class.getResource("layer" + oldVersion + ".xml");
            xmlfs = url != null ? new XMLFileSystem(url) : null;
        }
        catch (SAXException ex) {
            throw new IOException("Cannot import from version: " + oldVersion, ex);
        }
        LocalFileSystem old = xmlfs != null ? AutoUpgrade.createLayeredSystem(lfs, xmlfs) : lfs;
        Copy.copyDeep(old.getRoot(), FileUtil.getConfigRoot(), includeExclude, PathTransformation.getInstance(oldVersion));
    }

    static MultiFileSystem createLayeredSystem(LocalFileSystem lfs, XMLFileSystem xmlfs) {
        MultiFileSystem old = new MultiFileSystem(new FileSystem[]{lfs, xmlfs}){
            {
                this.setPropagateMasks(true);
            }
        };
        return old;
    }

    private static void copyToUserdir(File source) throws IOException, PropertyVetoException {
        File userdir = new File(System.getProperty("netbeans.user", ""));
        File netBeansDir = InstalledFileLocator.getDefault().locate("modules", null, false).getParentFile().getParentFile();
        File importFile = new File(netBeansDir, "etc/netbeans.import");
        LOGGER.fine("Import file: " + importFile);
        LOGGER.info("Importing from " + source + " to " + userdir);
        CopyFiles.copyDeep(source, userdir, importFile);
    }

    public static void doCopyToUserDir(File source) throws IOException, PropertyVetoException {
        AutoUpgrade.copyToUserdir(source);
    }
}

