/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javascript.bower.options.BowerOptions;
import org.netbeans.modules.javascript.bower.options.BowerOptionsValidator;
import org.netbeans.modules.javascript.bower.ui.options.BowerOptionsPanel;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class BowerOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String OPTIONS_CATEGORY = "Html5";
    public static final String OPTIONS_SUBCATEGORY = "Bower";
    public static final String OPTIONS_PATH = "Html5/Bower";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private BowerOptionsPanel bowerOptionsPanel;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPanel().setBower(this.getBowerOptions().getBower());
            this.getPanel().setIgnoreBowerComponents(this.getBowerOptions().isIgnoreBowerComponents());
        }
        this.changed = false;
    }

    public void applyChanges() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BowerOptionsPanelController.this.getBowerOptions().setBower(BowerOptionsPanelController.this.getPanel().getBower());
                BowerOptionsPanelController.this.getBowerOptions().setIgnoreBowerComponents(BowerOptionsPanelController.this.getPanel().isIgnoreBowerComponents());
                BowerOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPanel().setBower(this.getBowerOptions().getBower());
            this.getPanel().setIgnoreBowerComponents(this.getBowerOptions().isIgnoreBowerComponents());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        BowerOptionsPanel panel = this.getPanel();
        ValidationResult result = new BowerOptionsValidator().validateBower(panel.getBower()).getResult();
        if (result.hasErrors()) {
            panel.setError(result.getFirstErrorMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(result.getFirstWarningMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getBowerOptions().getBower();
        String current = this.getPanel().getBower().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        return this.getBowerOptions().isIgnoreBowerComponents() != this.getPanel().isIgnoreBowerComponents();
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.bower.ui.options.BowerOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private BowerOptionsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.bowerOptionsPanel == null) {
            this.bowerOptionsPanel = new BowerOptionsPanel();
            this.bowerOptionsPanel.addChangeListener(this);
        }
        return this.bowerOptionsPanel;
    }

    private BowerOptions getBowerOptions() {
        return BowerOptions.getInstance();
    }
}

