/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hyperlinks;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.hyperlinks.Bundle;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class HyperlinkProviderImpl
implements HyperlinkProviderExt {
    private static final Logger LOG = Logger.getLogger(HyperlinkProviderImpl.class.getName());

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        PomHyperlinkInfo hyperLinkInfo = new PomHyperlinkInfo(doc, offset);
        doc.render(new PomParserRunnable(hyperLinkInfo, doc, offset));
        return hyperLinkInfo.isHyperlinkPoint();
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        PomHyperlinkInfo hyperLinkInfo = new PomHyperlinkInfo(doc, offset);
        doc.render(new PomParserRunnable(hyperLinkInfo, doc, offset));
        return hyperLinkInfo.getHyperLinkSpan();
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        PomHyperlinkInfo hyperLinkInfo = new PomHyperlinkInfo(doc, offset);
        doc.render(new PomParserRunnable(hyperLinkInfo, doc, offset));
        hyperLinkInfo.performClickAction();
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return Collections.singleton(HyperlinkType.GO_TO_DECLARATION);
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        PomHyperlinkInfo hyperLinkInfo = new PomHyperlinkInfo(doc, offset);
        doc.render(new PomParserRunnable(hyperLinkInfo, doc, offset));
        String[] tooltip = hyperLinkInfo.getTooltipText();
        if (tooltip == null) {
            return Bundle.Hint_prop_cannot();
        }
        if (tooltip.length == 2) {
            return Bundle.Hint_prop_resolution(tooltip[0], tooltip[1]);
        }
        return tooltip[0];
    }

    public static void openAtSource(InputLocation location) {
        FileObject fobj;
        InputSource source = location.getSource();
        if (source != null && source.getLocation() != null && (fobj = FileUtilities.convertStringToFileObject((String)source.getLocation())) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)NodeUtils.readOnlyLocalRepositoryFile((FileObject)fobj));
                EditCookie edit = (EditCookie)dobj.getLookup().lookup(EditCookie.class);
                if (edit != null) {
                    edit.edit();
                }
                LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                lc.getLineSet().getOriginal(location.getLineNumber() - 1).show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, location.getColumnNumber() - 1);
            }
            catch (DataObjectNotFoundException ex) {
                LOG.log(Level.FINE, "dataobject not found", ex);
            }
        }
    }

    private Tuple findProperty(String textToken, int tokenOffset, int currentOffset) {
        if (textToken == null) {
            return null;
        }
        int ff = currentOffset - tokenOffset;
        if (ff > -1 && ff < textToken.length()) {
            String before = textToken.substring(0, ff);
            String after = textToken.substring(ff);
            int bo = before.lastIndexOf("${");
            int bc = before.lastIndexOf("}");
            int ao = after.indexOf("${");
            int ac = after.indexOf("}");
            if (bo > bc && ac > -1 && (ac < ao || ao == -1)) {
                return new Tuple(textToken.substring(bo, before.length() + ac + 1), tokenOffset + bo, tokenOffset + ff + ac + 1);
            }
            if (before.length() == 0 && ao == 0 && ac > 0) {
                return new Tuple(textToken.substring(0, ac + 1), tokenOffset, tokenOffset + ac + 1);
            }
        }
        return null;
    }

    private FileObject getProjectDir(Document doc) {
        DataObject dObject = NbEditorUtilities.getDataObject((Document)doc);
        if (dObject != null) {
            return dObject.getPrimaryFile().getParent();
        }
        return null;
    }

    private NbMavenProject getNbMavenProject(Document doc) {
        Project prj = this.getProject(doc);
        if (prj != null) {
            return (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        }
        return null;
    }

    private Project getProject(Document doc) {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        if (dobj != null) {
            return FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile());
        }
        return null;
    }

    private FileObject getPath(FileObject parent, String path) {
        if (path.startsWith("${basedir}/")) {
            path = path.substring("${basedir}/".length());
        }
        while (path.startsWith("../") && parent.getParent() != null) {
            path = path.substring("../".length());
            parent = parent.getParent();
        }
        return parent.getFileObject(path);
    }

    private class PomHyperlinkInfo {
        final Document doc;
        final int documentOffset;
        final FileObject projectFileObject;
        boolean isText;
        int ftokenOff;
        String ftext;
        String artifactId;
        String groupId;
        String version;
        String type;

        public PomHyperlinkInfo(Document doc, int documentOffset) {
            this.doc = doc;
            this.documentOffset = documentOffset;
            this.projectFileObject = HyperlinkProviderImpl.this.getProjectDir(doc);
        }

        boolean isHyperlinkUrl() {
            return this.ftext != null && (this.ftext.startsWith("http://") || this.ftext.startsWith("https://"));
        }

        private FileObject getFileSystemLinkObject() {
            FileObject fo = HyperlinkProviderImpl.this.getProjectDir(this.doc);
            if (fo != null && this.ftext != null) {
                return HyperlinkProviderImpl.this.getPath(fo, this.ftext);
            }
            return null;
        }

        boolean isMavenProperty() {
            int ff;
            if (this.ftext != null && (ff = this.documentOffset - this.ftokenOff) > -1 && ff < this.ftext.length()) {
                String before = this.ftext.substring(0, ff);
                String after = this.ftext.substring(ff);
                int bo = before.lastIndexOf("${");
                int bc = before.lastIndexOf("}");
                int ao = after.indexOf("${");
                int ac = after.indexOf("}");
                if (bo > bc && ac > -1 && (ac < ao || ao == -1)) {
                    return true;
                }
            }
            return false;
        }

        boolean isMavenDependency() {
            return this.artifactId != null && this.groupId != null && this.version != null;
        }

        boolean isHyperlinkPoint() {
            return this.isHyperlinkUrl() || this.getFileSystemLinkObject() != null || this.isMavenProperty() || this.isMavenDependency() && this.getMavenArtifactAbsolutePomPath() != null;
        }

        private void calculateInfo(Token<XMLTokenId> token, TokenSequence<XMLTokenId> xml) {
            block22: {
                block23: {
                    boolean bl = this.isText = token.id() == XMLTokenId.TEXT;
                    if (!this.isText) break block22;
                    this.ftokenOff = xml.offset();
                    this.ftext = token.text().toString();
                    if (this.projectFileObject == null || HyperlinkProviderImpl.this.getPath(this.projectFileObject, this.ftext) == null) break block23;
                    xml.movePrevious();
                    token = xml.token();
                    if (token == null || !((XMLTokenId)token.id()).equals((Object)XMLTokenId.TAG) || !TokenUtilities.equals((CharSequence)token.text(), (Object)">")) break block22;
                    xml.movePrevious();
                    token = xml.token();
                    if (token != null && ((XMLTokenId)token.id()).equals((Object)XMLTokenId.TAG) && TokenUtilities.equals((CharSequence)token.text(), (Object)"<module") && !this.ftext.endsWith("/pom.xml")) {
                        this.ftext = this.ftext + "/pom.xml";
                    }
                    break block22;
                }
                xml.movePrevious();
                token = xml.token();
                if (token != null && ((XMLTokenId)token.id()).equals((Object)XMLTokenId.TAG) && TokenUtilities.equals((CharSequence)token.text(), (Object)">")) {
                    xml.movePrevious();
                    String tokenString = xml.token().text().toString();
                    if ("<artifactId".equals(tokenString) || "<groupId".equals(tokenString) || "<type".equals(tokenString) || "<version".equals(tokenString) && !this.ftext.startsWith("${")) {
                        this.resetSequenceToDependencytagToken(xml);
                        if (TokenUtilities.equals((CharSequence)xml.token().text(), (Object)"<dependency")) {
                            NbMavenProject projectForDocument;
                            while (!TokenUtilities.equals((CharSequence)xml.token().text(), (Object)"</dependency")) {
                                switch (xml.token().text().toString()) {
                                    case "<artifactId": {
                                        this.moveToXmlTokenById(xml, XMLTokenId.TEXT);
                                        token = xml.token();
                                        this.artifactId = token.text().toString();
                                        break;
                                    }
                                    case "<groupId": {
                                        this.moveToXmlTokenById(xml, XMLTokenId.TEXT);
                                        token = xml.token();
                                        this.groupId = token.text().toString();
                                        break;
                                    }
                                    case "<version": {
                                        this.moveToXmlTokenById(xml, XMLTokenId.TEXT);
                                        token = xml.token();
                                        if (TokenUtilities.startsWith((CharSequence)token.text(), (CharSequence)"${")) {
                                            Project nbprj = HyperlinkProviderImpl.this.getProject(this.doc);
                                            if (nbprj == null) break;
                                            try {
                                                this.version = (String)PluginPropertyUtils.createEvaluator((Project)nbprj).evaluate(token.text().toString());
                                            }
                                            catch (ExpressionEvaluationException eee) {
                                                LOG.log(Level.INFO, "Unable to evaluate property: " + token.text().toString(), eee);
                                            }
                                            break;
                                        }
                                        this.version = token.text().toString();
                                        break;
                                    }
                                    case "<type": {
                                        this.moveToXmlTokenById(xml, XMLTokenId.TEXT);
                                        token = xml.token();
                                        this.type = token.text().toString();
                                    }
                                }
                                xml.moveNext();
                                this.moveToXmlTokenById(xml, XMLTokenId.TAG);
                            }
                            if (this.version == null && (projectForDocument = HyperlinkProviderImpl.this.getNbMavenProject(this.doc)) != null) {
                                MavenProject mavenProject = projectForDocument.getMavenProject();
                                for (Artifact artifact : mavenProject.getArtifacts()) {
                                    if (!artifact.getGroupId().equals(this.groupId) || !artifact.getArtifactId().equals(this.artifactId)) continue;
                                    this.version = artifact.getVersion();
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }

        String[] getTooltipText() {
            if (this.isText) {
                String text = this.ftext;
                int tokenOff = this.ftokenOff;
                if (this.isMavenProperty()) {
                    Tuple tup = HyperlinkProviderImpl.this.findProperty(text, tokenOff, this.documentOffset);
                    if (tup != null) {
                        String prop = tup.value.substring("${".length(), tup.value.length() - 1);
                        try {
                            Object exRes;
                            Project nbprj = HyperlinkProviderImpl.this.getProject(this.doc);
                            if (nbprj != null && (exRes = PluginPropertyUtils.createEvaluator((Project)nbprj).evaluate(tup.value)) != null) {
                                return new String[]{prop, (String)exRes};
                            }
                        }
                        catch (ExpressionEvaluationException ex) {
                            return null;
                        }
                    }
                } else if (this.isMavenDependency()) {
                    return new String[]{this.getMavenArtifactAbsolutePomPath()};
                }
            }
            return null;
        }

        String getMavenArtifactAbsolutePomPath() {
            if (!this.isMavenDependency()) {
                return null;
            }
            MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
            Artifact mavenArtifact = embedder.createArtifact(this.groupId, this.artifactId, this.version, this.type == null ? "jar" : this.type);
            String mavenPomPath = embedder.getLocalRepository().find(mavenArtifact).getFile().getAbsolutePath().replace(".jar", ".pom");
            if (mavenPomPath == null) {
                return null;
            }
            return new File(mavenPomPath).exists() ? mavenPomPath : null;
        }

        private int[] getHyperLinkSpan() {
            if (this.isText) {
                Tuple prop;
                FileObject fo = HyperlinkProviderImpl.this.getProjectDir(this.doc);
                if (fo != null && HyperlinkProviderImpl.this.getPath(fo, this.ftext) != null) {
                    return new int[]{this.ftokenOff, this.ftokenOff + this.ftext.length()};
                }
                if (this.isHyperlinkUrl()) {
                    return new int[]{this.ftokenOff, this.ftokenOff + this.ftext.length()};
                }
                if (this.ftext != null && (prop = HyperlinkProviderImpl.this.findProperty(this.ftext, this.ftokenOff, this.documentOffset)) != null) {
                    return new int[]{prop.spanStart, prop.spanEnd};
                }
                if (this.isMavenDependency()) {
                    return new int[]{this.ftokenOff, this.ftokenOff + this.ftext.length()};
                }
            }
            return null;
        }

        private void resetSequenceToDependencytagToken(TokenSequence<XMLTokenId> xml) {
            while (!(TokenUtilities.equals((CharSequence)"<dependency", (Object)xml.token().text()) || TokenUtilities.equals((CharSequence)"<plugin", (Object)xml.token().text()) || TokenUtilities.equals((CharSequence)"<parent", (Object)xml.token().text()) || TokenUtilities.equals((CharSequence)"<exclusion", (Object)xml.token().text()) || TokenUtilities.equals((CharSequence)"<project", (Object)xml.token().text()))) {
                xml.movePrevious();
            }
        }

        private void performClickAction() {
            if (this.isText) {
                File pomFile;
                FileObject fileToOpen;
                int tokenOff = this.ftokenOff;
                String text = this.ftext;
                FileObject fileSystemLinkObject = this.getFileSystemLinkObject();
                if (fileSystemLinkObject != null) {
                    NodeUtils.openPomFile((FileObject)fileSystemLinkObject);
                } else if (this.isHyperlinkUrl()) {
                    try {
                        Project nbprj;
                        String urlText = text;
                        if (urlText.contains("${") && (nbprj = HyperlinkProviderImpl.this.getProject(this.doc)) != null) {
                            try {
                                Object exRes = PluginPropertyUtils.createEvaluator((Project)nbprj).evaluate(urlText);
                                if (exRes != null) {
                                    urlText = exRes.toString();
                                }
                            }
                            catch (ExpressionEvaluationException ex) {
                                LOG.log(Level.FINE, "Expression evaluation failed", ex);
                            }
                        }
                        URL url = new URL(urlText);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, "malformed url for hyperlink", ex);
                    }
                } else if (this.isMavenProperty()) {
                    Tuple tup = HyperlinkProviderImpl.this.findProperty(text, tokenOff, this.documentOffset);
                    if (tup != null) {
                        String prop = tup.value.substring(2, tup.value.length() - 1);
                        NbMavenProject nbprj = HyperlinkProviderImpl.this.getNbMavenProject(this.doc);
                        if (nbprj != null) {
                            InputLocation location;
                            InputLocation propLoc;
                            if (prop != null && (prop.startsWith("project.") || prop.startsWith("pom."))) {
                                String val = prop.substring(prop.indexOf(46) + 1, prop.length());
                                InputLocation iloc = nbprj.getMavenProject().getModel().getLocation((Object)val);
                                if (iloc != null) {
                                    ModelUtils.openAtSource((InputLocation)iloc);
                                    return;
                                }
                            }
                            if ((propLoc = nbprj.getMavenProject().getModel().getLocation((Object)"properties")) != null && (location = propLoc.getLocation((Object)prop)) != null) {
                                ModelUtils.openAtSource((InputLocation)location);
                            }
                        }
                    }
                } else if (this.isMavenDependency() && (fileToOpen = FileUtil.toFileObject((File)(pomFile = new File(this.getMavenArtifactAbsolutePomPath())))) != null) {
                    NodeUtils.openPomFile((FileObject)fileToOpen);
                }
            }
        }

        private void moveToXmlTokenById(TokenSequence<XMLTokenId> xml, XMLTokenId tokenId) {
            while (xml.token() != null && !((XMLTokenId)xml.token().id()).equals((Object)tokenId)) {
                xml.moveNext();
            }
        }
    }

    private class PomParserRunnable
    implements Runnable {
        private final PomHyperlinkInfo hyperLinkInfo;
        private final Document document;
        private final int offset;

        public PomParserRunnable(PomHyperlinkInfo hyperLinkInfo, Document document, int offset) {
            this.hyperLinkInfo = hyperLinkInfo;
            this.document = document;
            this.offset = offset;
        }

        @Override
        public void run() {
            TokenHierarchy th = TokenHierarchy.get((Document)this.document);
            TokenSequence xml = th.tokenSequence(XMLTokenId.language());
            xml.move(this.offset);
            xml.moveNext();
            Token token = xml.token();
            if (token == null) {
                return;
            }
            if (token.id() == XMLTokenId.TEXT) {
                this.hyperLinkInfo.calculateInfo((Token<XMLTokenId>)token, (TokenSequence<XMLTokenId>)xml);
            }
        }
    }

    private static class Tuple {
        final int spanStart;
        final int spanEnd;
        final String value;

        public Tuple(String val, int start, int end) {
            this.value = val;
            this.spanStart = start;
            this.spanEnd = end;
        }
    }
}

