/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.jsch;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.support.Logger;

final class PortForwarding {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private final List<PortForwardingInfoR> rinfo = new ArrayList<PortForwardingInfoR>();
    private final List<PortForwardingInfoL> linfo = new ArrayList<PortForwardingInfoL>();

    PortForwarding() {
    }

    public synchronized void initSession(Session session) {
        for (PortForwardingInfoR r : this.rinfo) {
            try {
                session.setPortForwardingR(r.bind_address, r.rport, r.host, r.lport);
            }
            catch (JSchException ex) {
                log.log(Level.FINE, "setPortForwardingR({0}, {1}, {2}, {3} failed", new Object[]{r.bind_address, r.rport, r.host, r.lport});
                log.log(Level.FINE, "", ex);
            }
        }
        for (PortForwardingInfoL l : this.linfo) {
            try {
                session.setPortForwardingL(l.lport, l.host, l.rport);
            }
            catch (JSchException ex) {
                log.log(Level.FINE, "setPortForwardingL({0}, {1}, {2} failed", new Object[]{l.lport, l.host, l.rport});
                log.log(Level.FINE, "", ex);
            }
        }
    }

    public synchronized void addPortForwardingInfoR(String bind_address, int rport, String host, int lport) {
        this.rinfo.add(new PortForwardingInfoR(bind_address, rport, host, lport));
    }

    public synchronized void addPortForwardingInfoL(int lport, String host, int rport) {
        this.linfo.add(new PortForwardingInfoL(lport, host, rport));
    }

    public synchronized void removePortForwardingInfoR(int rport) {
        Iterator<PortForwardingInfoR> it = this.rinfo.iterator();
        while (it.hasNext()) {
            if (it.next().rport != rport) continue;
            it.remove();
        }
    }

    public synchronized void removePortForwardingInfoL(int lport) {
        Iterator<PortForwardingInfoL> it = this.linfo.iterator();
        while (it.hasNext()) {
            if (it.next().lport != lport) continue;
            it.remove();
        }
    }

    static final class PortForwardingInfoL {
        final int lport;
        final String host;
        final int rport;

        private PortForwardingInfoL(int lport, String host, int rport) {
            this.lport = lport;
            this.host = host;
            this.rport = rport;
        }
    }

    static final class PortForwardingInfoR {
        final String bind_address;
        final int rport;
        final String host;
        final int lport;

        private PortForwardingInfoR(String bind_address, int rport, String host, int lport) {
            this.bind_address = bind_address;
            this.rport = rport;
            this.host = host;
            this.lport = lport;
        }
    }
}

